package org.gcube.social_networking;

import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.idm.client.IdmClientFactory;
import org.gcube.idm.common.is.IsServerConfig;
import org.gcube.smartgears.ApplicationManager;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.configuration.Mode;
import org.gcube.social_networking.utils.InfrastructureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Ahmed Ibrahim
 */
public class SocialServiceApplicationManager implements ApplicationManager {
	Logger logger = LoggerFactory.getLogger(SocialServiceApplicationManager.class);

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void onInit() {
		Secret isSecret = InfrastructureUtils.getSecretForInfrastructure();
		IdmClientFactory factory = IdmClientFactory.getSingleton();
		factory.setSecret(isSecret);

		String baseurl = "http://146.48.85.179:9999/idm-service/";
		IsServerConfig config = new IsServerConfig(baseurl);
		factory.setConfig(config);

		if (ContextProvider.get().container().configuration().mode() == Mode.offline) {

			logger.debug("init called in offline mode");
		} else {
			Secret secret = SecretManagerProvider.get();
			if (secret != null) {
				logger.debug("init called in context {}", secret.getContext());
			} else {
				logger.debug("init called in null context");
			}
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void onShutdown() {
		if (ContextProvider.get().container().configuration().mode() == Mode.offline) {
			logger.debug("shutDown called in offline mode");
		} else {
			Secret secret = SecretManagerProvider.get();
			if (secret != null) {
				logger.debug("shutDown called in context {}", secret.getContext());
			} else {
				logger.debug("shutDown called in null context");
			}
		}
	}
}