/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.social_networking.server;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.CreateKeyspace;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.List;
import org.gcube.social_networking.server.CassandraCluster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CassandraClusterConnection {
    private static final Logger _log = LoggerFactory.getLogger(CassandraClusterConnection.class);
    private static List<InetSocketAddress> hosts;
    private static String datacenterName;
    private static String keyspaceName;
    private CqlSession myKeyspaceSession;

    protected CassandraClusterConnection(boolean dropSchema) throws Exception {
        if (hosts == null || datacenterName == null || keyspaceName == null) {
            CassandraCluster cluster = CassandraCluster.getInstance(null);
            hosts = cluster.getHosts();
            datacenterName = cluster.getDatacenterName();
            keyspaceName = cluster.getKeyspaceName();
        }
        _log.info(keyspaceName + " KeySpace SetUp ...");
        this.SetUpKeySpaces(dropSchema);
        this.myKeyspaceSession = CassandraClusterConnection.connect(keyspaceName);
        _log.info("CONNECTED! using KeySpace: " + keyspaceName);
    }

    protected CassandraClusterConnection(boolean dropSchema, String infrastructureName) throws Exception {
        if (hosts == null || datacenterName == null || keyspaceName == null) {
            CassandraCluster cluster = CassandraCluster.getInstance(infrastructureName);
            hosts = cluster.getHosts();
            datacenterName = cluster.getDatacenterName();
            keyspaceName = cluster.getKeyspaceName();
        }
        _log.info(keyspaceName + " KeySpace SetUp ...");
        this.SetUpKeySpaces(dropSchema);
        this.myKeyspaceSession = CassandraClusterConnection.connect(keyspaceName);
        _log.info("CONNECTED! using KeySpace: " + keyspaceName);
    }

    public CqlSession getKeyspaceSession() {
        if (this.myKeyspaceSession.isClosed()) {
            this.myKeyspaceSession = CassandraClusterConnection.connect(keyspaceName);
        }
        return this.myKeyspaceSession;
    }

    public void SetUpKeySpaces(boolean dropSchema) {
        boolean createNew = false;
        boolean found = false;
        CqlSession session = CassandraClusterConnection.connect();
        Metadata metaData = session.getMetadata();
        for (KeyspaceMetadata meta : metaData.getKeyspaces().values()) {
            if (!meta.getName().toString().equals(keyspaceName)) continue;
            found = true;
            break;
        }
        try {
            if (dropSchema && found) {
                _log.info("Dropping Keyspace: " + keyspaceName + " ...");
                try {
                    ResultSet returned = CassandraClusterConnection.dropKeyspace();
                    Thread.sleep(2000L);
                    if (returned.wasApplied()) {
                        _log.info("Dropped " + keyspaceName);
                    } else {
                        _log.info("Couldn't drop " + keyspaceName);
                    }
                }
                catch (Exception e) {
                    _log.error("Dropping Keyspace operation Failed ... " + keyspaceName + " does NOT exists");
                    return;
                }
                createNew = true;
            }
            if (!found || createNew) {
                _log.info("Keyspace does not exist, triggering schema creation ... ");
                int replicationFactor = 2;
                CassandraClusterConnection.createKeyspace(keyspaceName, replicationFactor);
                CassandraClusterConnection.closeSession(session);
                this.createTables();
                _log.info("Using Keyspace " + keyspaceName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static CqlSession connect() {
        CqlSession cqlSession = (CqlSession)((CqlSessionBuilder)((CqlSessionBuilder)CassandraClusterConnection.configBuilder(CqlSession.builder()).addContactPoints(hosts)).withLocalDatacenter(datacenterName)).build();
        _log.info("[OK] Connected to Cassandra Cluster");
        return cqlSession;
    }

    private static CqlSession connect(String KEYSPACE_NAME) {
        CqlSession cqlSession = (CqlSession)((CqlSessionBuilder)((CqlSessionBuilder)((CqlSessionBuilder)CassandraClusterConnection.configBuilder(CqlSession.builder()).addContactPoints(hosts)).withKeyspace(KEYSPACE_NAME)).withLocalDatacenter(datacenterName)).build();
        _log.info("[OK] Connected to Keyspace {} ", (Object)KEYSPACE_NAME);
        return cqlSession;
    }

    public static void closeSession(CqlSession session) {
        if (session != null) {
            session.close();
        }
        _log.info("[OK]Session is now closed");
    }

    public void closeConnection() {
        if (!this.myKeyspaceSession.isClosed()) {
            try {
                _log.info("Closing connection");
                CassandraClusterConnection.closeSession(this.myKeyspaceSession);
                _log.info("Connection closed!");
            }
            catch (Exception e) {
                _log.error("Unable to close connection", (Throwable)e);
            }
        }
    }

    private static CqlSessionBuilder configBuilder(CqlSessionBuilder cqlSessionBuilder) {
        return (CqlSessionBuilder)cqlSessionBuilder.withConfigLoader(((ProgrammaticDriverConfigLoaderBuilder)((ProgrammaticDriverConfigLoaderBuilder)((ProgrammaticDriverConfigLoaderBuilder)DriverConfigLoader.programmaticBuilder().withDuration((DriverOption)DefaultDriverOption.METADATA_SCHEMA_REQUEST_TIMEOUT, Duration.ofMillis(240000L))).withDuration((DriverOption)DefaultDriverOption.CONNECTION_INIT_QUERY_TIMEOUT, Duration.ofMillis(240000L))).withDuration((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT, Duration.ofMillis(240000L))).build());
    }

    private static void createKeyspace(String keyspaceName, int replicationFactor) {
        try (CqlSession cqlSession = (CqlSession)((CqlSessionBuilder)((CqlSessionBuilder)CassandraClusterConnection.configBuilder(CqlSession.builder()).addContactPoints(hosts)).withLocalDatacenter(datacenterName)).build();){
            cqlSession.execute((Statement)((CreateKeyspace)((CreateKeyspace)SchemaBuilder.createKeyspace((String)keyspaceName).ifNotExists().withSimpleStrategy(replicationFactor)).withDurableWrites(true)).build());
            _log.info("+ Keyspace '{}' created.", (Object)keyspaceName);
            CassandraClusterConnection.closeSession(cqlSession);
        }
    }

    private static ResultSet dropKeyspace() {
        ResultSet toreturn;
        try (CqlSession cqlSession = (CqlSession)((CqlSessionBuilder)((CqlSessionBuilder)CassandraClusterConnection.configBuilder(CqlSession.builder()).addContactPoints(hosts)).withLocalDatacenter(datacenterName)).build();){
            toreturn = cqlSession.execute((Statement)SchemaBuilder.dropKeyspace((String)keyspaceName).ifExists().build());
            _log.info("Keyspace {} dropped.", (Object)keyspaceName);
            CassandraClusterConnection.closeSession(cqlSession);
        }
        return toreturn;
    }

    private void createTables() {
        try (CqlSession cqlSession = (CqlSession)((CqlSessionBuilder)((CqlSessionBuilder)((CqlSessionBuilder)CassandraClusterConnection.configBuilder(CqlSession.builder()).addContactPoints(hosts)).withLocalDatacenter(datacenterName)).withKeyspace(keyspaceName)).build();){
            this.createTableUSERNotificationsPreferences(cqlSession);
            this.createTableUSERNotifications(cqlSession);
            this.createTableVRETimeline(cqlSession);
            this.createTableAppTimeline(cqlSession);
            this.createTableUSERTimeline(cqlSession);
            this.createTableHashtaggedPosts(cqlSession);
            this.createTableHashtaggedComments(cqlSession);
            this.createTableHashtagsCounter(cqlSession);
            this.createTableUSERNotificationsUnread(cqlSession);
            this.createTableUSERLikes(cqlSession);
            this.createTableVREInvites(cqlSession);
            this.createTableEMAILInvites(cqlSession);
            this.createTableAttachments(cqlSession);
            this.createTableInvites(cqlSession);
            this.createTableLikes(cqlSession);
            this.createTableComments(cqlSession);
            this.createTableNotifications(cqlSession);
            this.createTablePosts(cqlSession);
            CassandraClusterConnection.closeSession(cqlSession);
        }
    }

    private void createTableUSERNotificationsPreferences(CqlSession cqlSession) {
        cqlSession.execute((Statement)SchemaBuilder.createTable((String)"UserNotificationsPreferences").ifNotExists().withPartitionKey("userid", DataTypes.TEXT).withPartitionKey("type", DataTypes.TEXT).withColumn("preference", DataTypes.TEXT).withCompactStorage().build());
        _log.info("+ Table '{}' has been created (if needed).", (Object)"USERNotificationsPreferences");
    }

    private void createTableUSERNotifications(CqlSession cqlSession) {
        cqlSession.execute((Statement)SchemaBuilder.createTable((String)"UserNotifications").ifNotExists().withPartitionKey("userid", DataTypes.TEXT).withPartitionKey("timestamp", DataTypes.TIMESTAMP).withColumn("notid", DataTypes.UUID).withCompactStorage().build());
        _log.info("+ Table '{}' has been created (if needed).", (Object)"USERNotifications");
    }

    private void createTableVRETimeline(CqlSession cqlSession) {
        cqlSession.execute((Statement)SchemaBuilder.createTable((String)"VRETimeline").ifNotExists().withPartitionKey("vreid", DataTypes.TEXT).withPartitionKey("timestamp", DataTypes.TIMESTAMP).withColumn("postid", DataTypes.UUID).withCompactStorage().build());
        _log.info("+ Table '{}' has been created (if needed).", (Object)"VRETimeline");
    }

    private void createTableAppTimeline(CqlSession cqlSession) {
        cqlSession.execute((Statement)SchemaBuilder.createTable((String)"AppTimeline").ifNotExists().withPartitionKey("appid", DataTypes.TEXT).withPartitionKey("timestamp", DataTypes.TIMESTAMP).withColumn("postid", DataTypes.UUID).withCompactStorage().build());
        _log.info("+ Table '{}' has been created (if needed).", (Object)"AppTimeline");
    }

    private void createTableUSERTimeline(CqlSession cqlSession) {
        cqlSession.execute((Statement)SchemaBuilder.createTable((String)"UserTimeline").ifNotExists().withPartitionKey("userid", DataTypes.TEXT).withPartitionKey("timestamp", DataTypes.TIMESTAMP).withColumn("postid", DataTypes.UUID).withCompactStorage().build());
        _log.info("+ Table '{}' has been created (if needed).", (Object)"USERTimeline");
    }

    private void createTableHashtaggedPosts(CqlSession cqlSession) {
        cqlSession.execute((Statement)SchemaBuilder.createTable((String)"HashtaggedPosts").ifNotExists().withPartitionKey("hashtag", DataTypes.TEXT).withPartitionKey("postid", DataTypes.UUID).withColumn("vreid", DataTypes.TEXT).withCompactStorage().build());
        _log.info("+ Table '{}' has been created (if needed).", (Object)"HashtaggedPosts");
    }

    private void createTableHashtaggedComments(CqlSession cqlSession) {
        cqlSession.execute((Statement)SchemaBuilder.createTable((String)"HashtaggedComments").ifNotExists().withPartitionKey("hashtag", DataTypes.TEXT).withPartitionKey("commentid", DataTypes.UUID).withColumn("vreid", DataTypes.TEXT).withCompactStorage().build());
        _log.info("+ Table '{}' has been created (if needed).", (Object)"HashtaggedComments");
    }

    private void createTableHashtagsCounter(CqlSession cqlSession) {
        cqlSession.execute((Statement)SchemaBuilder.createTable((String)"HashtagsCounter").ifNotExists().withPartitionKey("vreid", DataTypes.TEXT).withPartitionKey("hashtag", DataTypes.TEXT).withColumn("count", DataTypes.BIGINT).withCompactStorage().build());
        _log.info("+ Table '{}' has been created (if needed).", (Object)"HashtagsCounter");
    }

    private void createTableUSERNotificationsUnread(CqlSession cqlSession) {
        cqlSession.execute((Statement)SchemaBuilder.createTable((String)"UserUnreadNotifications").ifNotExists().withPartitionKey("userid", DataTypes.TEXT).withPartitionKey("timestamp", DataTypes.TIMESTAMP).withColumn("notid", DataTypes.UUID).withCompactStorage().build());
        _log.info("+ Table '{}' has been created (if needed).", (Object)"USERNotificationsUnread");
    }

    private void createTableUSERLikes(CqlSession cqlSession) {
        cqlSession.execute((Statement)SchemaBuilder.createTable((String)"UserLikes").ifNotExists().withPartitionKey("userid", DataTypes.TEXT).withPartitionKey("likeid", DataTypes.UUID).withColumn("postid", DataTypes.UUID).withCompactStorage().build());
        _log.info("+ Table '{}' has been created (if needed).", (Object)"USERLikes");
    }

    private void createTableVREInvites(CqlSession cqlSession) {
        cqlSession.execute((Statement)SchemaBuilder.createTable((String)"VREInvites").ifNotExists().withPartitionKey("vreid", DataTypes.TEXT).withPartitionKey("inviteid", DataTypes.UUID).withColumn("status", DataTypes.TEXT).withCompactStorage().build());
        _log.info("+ Table '{}' has been created (if needed).", (Object)"VREInvites");
    }

    private void createTableEMAILInvites(CqlSession cqlSession) {
        cqlSession.execute((Statement)SchemaBuilder.createTable((String)"EmailInvites").ifNotExists().withPartitionKey("email", DataTypes.TEXT).withPartitionKey("vreid", DataTypes.TEXT).withColumn("inviteid", DataTypes.UUID).withCompactStorage().build());
        _log.info("+ Table '{}' has been created (if needed).", (Object)"EMAILInvites");
    }

    private void createTableAttachments(CqlSession cqlSession) {
        cqlSession.execute((Statement)SchemaBuilder.createTable((String)"Attachments").ifNotExists().withPartitionKey("attachid", DataTypes.UUID).withColumn("postid", DataTypes.UUID).withColumn("uri", DataTypes.TEXT).withColumn("name", DataTypes.TEXT).withColumn("description", DataTypes.TEXT).withColumn("urithumbnail", DataTypes.TEXT).withColumn("mimetype", DataTypes.TEXT).withCompactStorage().build());
        cqlSession.execute((Statement)SchemaBuilder.createIndex((String)"post_attach").ifNotExists().onTable("Attachments").andColumn("postid").build());
        _log.info("+ Table '{}' has been created (if needed).", (Object)"Attachments");
    }

    private void createTableInvites(CqlSession cqlSession) {
        cqlSession.execute((Statement)SchemaBuilder.createTable((String)"Invites").ifNotExists().withPartitionKey("inviteid", DataTypes.UUID).withColumn("senderuserid", DataTypes.TEXT).withColumn("vreid", DataTypes.TEXT).withColumn("email", DataTypes.TEXT).withColumn("controlcode", DataTypes.TEXT).withColumn("status", DataTypes.TEXT).withColumn("timestamp", DataTypes.TIMESTAMP).withColumn("senderfullname", DataTypes.TEXT).withCompactStorage().build());
        cqlSession.execute((Statement)SchemaBuilder.createIndex((String)"sender").ifNotExists().onTable("Invites").andColumn("senderuserid").build());
        _log.info("+ Table '{}' has been created (if needed).", (Object)"Invites");
    }

    private void createTableLikes(CqlSession cqlSession) {
        cqlSession.execute((Statement)SchemaBuilder.createTable((String)"Likes").ifNotExists().withPartitionKey("likeid", DataTypes.UUID).withColumn("userid", DataTypes.TEXT).withColumn("fullname", DataTypes.TEXT).withColumn("thumbnailurl", DataTypes.TEXT).withColumn("postid", DataTypes.UUID).withColumn("timestamp", DataTypes.TIMESTAMP).withCompactStorage().build());
        cqlSession.execute((Statement)SchemaBuilder.createIndex((String)"post_likes").ifNotExists().onTable("Likes").andColumn("postid").build());
        _log.info("+ Table '{}' has been created (if needed).", (Object)"Likes");
    }

    private void createTableComments(CqlSession cqlSession) {
        cqlSession.execute((Statement)SchemaBuilder.createTable((String)"Comments").ifNotExists().withPartitionKey("commentid", DataTypes.UUID).withColumn("userid", DataTypes.TEXT).withColumn("fullname", DataTypes.TEXT).withColumn("thumbnailurl", DataTypes.TEXT).withColumn("comment", DataTypes.TEXT).withColumn("postid", DataTypes.UUID).withColumn("timestamp", DataTypes.TIMESTAMP).withColumn("isedit", DataTypes.BOOLEAN).withColumn("lastedittime", DataTypes.TIMESTAMP).withCompactStorage().build());
        cqlSession.execute((Statement)SchemaBuilder.createIndex((String)"post_comments").ifNotExists().onTable("Comments").andColumn("postid").build());
        _log.info("+ Table '{}' has been created (if needed).", (Object)"Comments");
    }

    private void createTableNotifications(CqlSession cqlSession) {
        cqlSession.execute((Statement)SchemaBuilder.createTable((String)"Notifications").ifNotExists().withPartitionKey("notid", DataTypes.UUID).withColumn("type", DataTypes.TEXT).withColumn("userid", DataTypes.TEXT).withColumn("subjectid", DataTypes.TEXT).withColumn("timestamp", DataTypes.TIMESTAMP).withColumn("description", DataTypes.TEXT).withColumn("uri", DataTypes.TEXT).withColumn("senderid", DataTypes.TEXT).withColumn("senderfullname", DataTypes.TEXT).withColumn("senderthumbnailurl", DataTypes.TEXT).withColumn("isread", DataTypes.BOOLEAN).withCompactStorage().build());
        cqlSession.execute((Statement)SchemaBuilder.createIndex((String)"not_type").ifNotExists().onTable("Notifications").andColumn("type").build());
        _log.info("+ Table '{}' has been created (if needed).", (Object)"Notifications");
    }

    private void createTablePosts(CqlSession cqlSession) {
        cqlSession.execute((Statement)SchemaBuilder.createTable((String)"Posts").ifNotExists().withPartitionKey("postid", DataTypes.UUID).withColumn("linkhost", DataTypes.TEXT).withColumn("description", DataTypes.TEXT).withColumn("email", DataTypes.TEXT).withColumn("likesno", DataTypes.BIGINT).withColumn("thumbnailurl", DataTypes.TEXT).withColumn("linkdescription", DataTypes.TEXT).withColumn("timestamp", DataTypes.TIMESTAMP).withColumn("uri", DataTypes.TEXT).withColumn("isapplicationpost", DataTypes.BOOLEAN).withColumn("entityid", DataTypes.TEXT).withColumn("privacy", DataTypes.TEXT).withColumn("type", DataTypes.TEXT).withColumn("urithumbnail", DataTypes.TEXT).withColumn("vreid", DataTypes.TEXT).withColumn("multifileupload", DataTypes.BOOLEAN).withColumn("fullname", DataTypes.TEXT).withColumn("commentsno", DataTypes.BIGINT).withColumn("linktitle", DataTypes.TEXT).withCompactStorage().build());
        cqlSession.execute((Statement)SchemaBuilder.createIndex((String)"posts_privacy").ifNotExists().onTable("Posts").andColumn("privacy").build());
        _log.info("+ Table '{}' has been created (if needed).", (Object)"Posts");
    }
}

