/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.social_networking.caches;

import java.io.Serializable;
import java.util.List;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.social_networking.caches.CachesManager;
import org.gcube.social_networking.liferay.ws.GroupManagerWSBuilder;
import org.gcube.social_networking.liferay.ws.UserManagerWSBuilder;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsersCache {
    private static final Logger logger = LoggerFactory.getLogger(UsersCache.class);
    private static UsersCache singleton = new UsersCache();

    private UsersCache() {
        new Thread(){

            @Override
            public void run() {
                try {
                    logger.debug("Fetching users and putting them into cache");
                    Ehcache usersCache = CachesManager.getCache("users_cache");
                    GroupManager groupManager = GroupManagerWSBuilder.getInstance().getGroupManager();
                    UserManager userManager = UserManagerWSBuilder.getInstance().getUserManager();
                    ApplicationContext ctx = ContextProvider.get();
                    List users = userManager.listUsersByGroup(groupManager.getGroupIdFromInfrastructureScope("/" + ctx.container().configuration().infrastructure()));
                    for (GCubeUser gCubeUser : users) {
                        usersCache.put(new Element((Serializable)Long.valueOf(gCubeUser.getUserId()), (Serializable)gCubeUser));
                    }
                }
                catch (Exception e) {
                    logger.error("Unable to retrieve user's usernames. Other users will be discovered later on", (Throwable)e);
                }
            }
        }.start();
    }

    public static UsersCache getSingleton() {
        return singleton;
    }

    public GCubeUser getUser(long userId) {
        Ehcache usersCache = CachesManager.getCache("users_cache");
        if (usersCache.get((Serializable)Long.valueOf(userId)) != null) {
            return (GCubeUser)usersCache.get((Serializable)Long.valueOf(userId)).getObjectValue();
        }
        return null;
    }

    public void pushEntry(long id, GCubeUser user) {
        Ehcache usersCache = CachesManager.getCache("users_cache");
        usersCache.put(new Element((Serializable)Long.valueOf(id), (Serializable)user));
    }
}

