package org.gcube.social_networking.model.providers;

import org.slf4j.LoggerFactory;

import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.PropertyNamingStrategy;
import org.gcube.com.fasterxml.jackson.databind.SerializationFeature;

import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.Provider;

/**
 * Custom mapper with property CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES to
 * perform serialization/deserialization
 * with snake case over camel case for json beans.
 * 
 * @author Costantino Perciante at ISTI-CNR (costantino.perciante@isti.cnr.it)
 */
@Provider
public class CustomObjectMapper implements ContextResolver<ObjectMapper> {

	private static final org.slf4j.Logger logger = LoggerFactory.getLogger(CustomObjectMapper.class);
	private final ObjectMapper mapper;

	public CustomObjectMapper() {
		logger.debug("new ObjectMapperResolver()");
		mapper = new ObjectMapper();
		mapper.enable(SerializationFeature.INDENT_OUTPUT);
		mapper.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);

	}

	@Override
	public ObjectMapper getContext(Class<?> type) {
		logger.debug("ObjectMapperResolver.getContext(...) invoked");
		return mapper;
	}
}