package org.gcube.social_networking.socialnetworking.model.beans;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeName("ITEM_NEW")
public class WorkspaceNotificationAddedItem extends WorkspaceNotification {
	/**
	 * the username of the user you wish to notify
	 */
	@JsonProperty("userIdToNotify")
	@NotNull(message="recipient cannot be missing")
	private String userIdToNotify;	
	
	@JsonProperty("fileItem")
	@NotNull(message="fileItem cannot be missing")
	private WorkspaceFileItemBean item;
	
	public WorkspaceNotificationAddedItem() {
		super(WorkspaceNotificationType.ITEM_NEW);
		// TODO Auto-generated constructor stub
	}

	public WorkspaceNotificationAddedItem(String userIdToNotify, WorkspaceFileItemBean item) {
		super(WorkspaceNotificationType.ITEM_NEW);
		this.userIdToNotify = userIdToNotify;
		this.item = item;
	}

	public String getUserIdToNotify() {
		return userIdToNotify;
	}

	public void setUserIdToNotify(String userIdToNotify) {
		this.userIdToNotify = userIdToNotify;
	}

	public WorkspaceFileItemBean getItem() {
		return item;
	}

	public void setItem(WorkspaceFileItemBean item) {
		this.item = item;
	}

	@Override
	public String toString() {
		return "WorkspaceNotificationAddedItem [userIdToNotify=" + userIdToNotify + ", item=" + item + "]";
	}

	
}
