/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.social_networking.socialnetworking.model.beans;

import java.io.Serializable;
import java.util.ArrayList;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.gcube.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.gcube.com.fasterxml.jackson.annotation.JsonProperty;
import org.gcube.social_networking.socialnetworking.model.beans.Recipient;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MessageInputBean
implements Serializable {
    private static final long serialVersionUID = -1317811686036127456L;
    @JsonProperty(value="body")
    @NotNull(message="body cannot be missing")
    @Size(min=1, message="body cannot be empty")
    private @NotNull(message="body cannot be missing") @Size(min=1, message="body cannot be empty") String body;
    @JsonProperty(value="subject")
    @NotNull(message="subject cannot be missing")
    @Size(min=1, message="subject cannot be empty")
    private @NotNull(message="subject cannot be missing") @Size(min=1, message="subject cannot be empty") String subject;
    @JsonProperty(value="recipients")
    @NotNull(message="recipients cannot be missing")
    @Size(min=1, message="at least a recipient is needed")
    @Valid
    private @NotNull(message="recipients cannot be missing") @Size(min=1, message="at least a recipient is needed") @Valid ArrayList<Recipient> recipients;
    @JsonProperty(value="attachmentIds")
    @Valid
    private ArrayList<String> attachmentIds;

    public MessageInputBean() {
    }

    public MessageInputBean(String body, String subject, ArrayList<Recipient> recipients) {
        this.body = body;
        this.subject = subject;
        this.recipients = recipients;
        this.attachmentIds = new ArrayList();
    }

    public MessageInputBean(String body, String subject, ArrayList<Recipient> recipients, ArrayList<String> attachmentIds) {
        this.body = body;
        this.subject = subject;
        this.recipients = recipients;
        this.attachmentIds = attachmentIds;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public ArrayList<Recipient> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(ArrayList<Recipient> recipients) {
        this.recipients = recipients;
    }

    public ArrayList<String> getAttachmentIds() {
        return this.attachmentIds;
    }

    public void setAttachmentIds(ArrayList<String> attachmentIds) {
        this.attachmentIds = attachmentIds;
    }

    public String toString() {
        return "MessageInputBean [body=" + this.body + ", subject=" + this.subject + ", recipients=" + String.valueOf(this.recipients) + ", attachmentIds=" + String.valueOf(this.attachmentIds) + "]";
    }
}

