package org.gcube.social_networking.social_networking_client_library.filter;

import java.io.IOException;

import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;

import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Authorization filter for the jersey client.
 * @author Costantino Perciante at ISTI-CNR (costantino.perciante@isti.cnr.it)
 */
public class AuthorizationFilter implements ClientRequestFilter{
	private final static String AUTH_TOKEN_PARAMETER = "gcube-token";
	private static Logger logger = LoggerFactory.getLogger(AuthorizationFilter.class);

	@Override
	public void filter(ClientRequestContext original) throws IOException {
		logger.debug("Adding token to the request " + original.getUri());
		String token = SecurityTokenProvider.instance.get();
		original.getHeaders().add(AUTH_TOKEN_PARAMETER, token);
	}
}
