/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.impl.utils.discovery;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

class Tree<T> {
    private final Node<T> rootElement;
    private static final Comparator NATURAL_ORDER = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }
    };
    private final Comparator<?> comparator;

    public void visitNodes(NodeVisitor<T> visitor) {
        Tree.doVisit(this.rootElement, visitor);
    }

    private static <T> boolean doVisit(Node<T> node, NodeVisitor<T> visitor) {
        boolean result = visitor.visit(node);
        if (result) {
            for (Node subNode : ((Node)node).children) {
                if (Tree.doVisit(subNode, visitor)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public Node<T> getRootElement() {
        return this.rootElement;
    }

    public Tree() {
        this(null, null);
    }

    public Tree(Comparator<? super T> comparator) {
        this(comparator, null);
    }

    public Tree(Comparator<? super T> comparator, T rootValue) {
        this.comparator = comparator == null ? NATURAL_ORDER : comparator;
        this.rootElement = new Node<T>(rootValue, null, this.comparator);
    }

    public Tree(T rootValue) {
        this(null, rootValue);
    }

    public static class Node<T> {
        private final SortedSet<Node<T>> children;
        private final Node<T> parent;
        private T value;
        private final Comparator<?> comparator;

        Node(T value, Node<T> parent, Comparator<?> comparator) {
            this.value = value;
            this.parent = parent;
            this.comparator = comparator;
            this.children = new TreeSet(new NodeComparator(comparator));
        }

        public List<Node<T>> getChildren() {
            return new ArrayList<Node<T>>(this.children);
        }

        public Node<T> getParent() {
            return this.parent;
        }

        public T getValue() {
            return this.value;
        }

        public Node<T> addChild(T value) {
            Node<T> node = new Node<T>(value, this, this.comparator);
            return this.children.add(node) ? node : null;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static final class NodeComparator<T>
    implements Comparator<Node<T>> {
        private final Comparator<T> wrapped;

        @Override
        public int compare(Node<T> o1, Node<T> o2) {
            return this.wrapped.compare(((Node)o1).value, ((Node)o2).value);
        }

        public NodeComparator(Comparator<T> wrappedComparator) {
            this.wrapped = wrappedComparator;
        }
    }

    public static interface NodeVisitor<T> {
        public boolean visit(Node<T> var1);
    }
}

