/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.sru.search.adapter.commons.discoverer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.gcube.rest.resourcemanager.discoverer.Discoverer;
import org.gcube.rest.resourcemanager.discoverer.exceptions.DiscovererException;
import org.gcube.rest.resourcemanager.discoverer.ri.RunningInstancesDiscoverer;
import org.gcube.rest.resourcemanager.harvester.IResourceHarvester;
import org.gcube.search.sru.search.adapter.commons.discoverer.SruSearchAdapterDiscovererAPI;
import org.gcube.search.sru.search.adapter.commons.discoverer.exceptions.SruSearchAdapterDiscoverException;
import org.gcube.search.sru.search.adapter.commons.resources.SruSearchAdapterResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SruSearchAdapterDiscoverer
extends Discoverer<SruSearchAdapterResource>
implements SruSearchAdapterDiscovererAPI<SruSearchAdapterResource> {
    private static final Logger logger = LoggerFactory.getLogger(SruSearchAdapterDiscoverer.class);

    @Inject
    public SruSearchAdapterDiscoverer(RunningInstancesDiscoverer riDiscoverer, IResourceHarvester<SruSearchAdapterResource> harvester) {
        super(riDiscoverer, harvester);
    }

    @Override
    public Map<String, Set<String>> discoverSruSearchAdapterNodes(String scope, String searchsystemEndpoint) throws SruSearchAdapterDiscoverException {
        logger.info("calling discoverSruSearchAdapterNodes with parameters. scope : " + scope + ", searchsystemEndpoint : " + searchsystemEndpoint);
        Set<String> endpoints = this.discoverSruSearchAdapterNodeRunningInstances(scope);
        try {
            Map foundResources = this.discoverResources(endpoints, SruSearchAdapterResource.class, scope);
            if (foundResources == null || foundResources.size() == 0) {
                logger.warn("No resources found by the default discoverer");
                return null;
            }
            HashMap<String, Set<String>> serviceResources = new HashMap<String, Set<String>>();
            for (Map.Entry entry : foundResources.entrySet()) {
                String endpoint = (String)entry.getKey();
                Set resources = (Set)entry.getValue();
                for (SruSearchAdapterResource resource : resources) {
                    if (!SruSearchAdapterDiscoverer.filterResource(resource, scope, searchsystemEndpoint).booleanValue()) continue;
                    if (!serviceResources.containsKey(endpoint)) {
                        serviceResources.put(endpoint, new HashSet());
                    }
                    ((Set)serviceResources.get(endpoint)).add(resource.getResourceID());
                }
            }
            return serviceResources;
        }
        catch (DiscovererException e) {
            throw new SruSearchAdapterDiscoverException("error while discovering sru search adapter resources", (Exception)((Object)e));
        }
    }

    @Override
    public Set<SruSearchAdapterResource> discoverSruSearchAdapterNodeResources(String scope, String searchsystemEndpoint) throws SruSearchAdapterDiscoverException {
        logger.info("calling discoverSruSearchAdapterNodeResources with parameters. scope : " + scope + ", searchsystemEndpoint : " + searchsystemEndpoint);
        Set<String> endpoints = this.discoverSruSearchAdapterNodeRunningInstances(scope);
        try {
            Map foundResources = this.discoverResources(endpoints, SruSearchAdapterResource.class, scope);
            if (foundResources == null || foundResources.size() == 0) {
                logger.warn("No resources found by the default discoverer");
                return null;
            }
            HashSet<SruSearchAdapterResource> serviceResources = new HashSet<SruSearchAdapterResource>();
            for (Map.Entry entry : foundResources.entrySet()) {
                Set resources = (Set)entry.getValue();
                for (SruSearchAdapterResource resource : resources) {
                    if (!SruSearchAdapterDiscoverer.filterResource(resource, scope, searchsystemEndpoint).booleanValue()) continue;
                    serviceResources.add(resource);
                }
            }
            return serviceResources;
        }
        catch (DiscovererException e) {
            throw new SruSearchAdapterDiscoverException("error while discovering sru db resources", (Exception)((Object)e));
        }
    }

    @Override
    public Set<String> discoverSruSearchAdapterNodeRunningInstances(String scope) {
        return this.discoverRunningInstances("Search", "SruSearchAdapter", "resteasy-servlet", scope);
    }

    private static Boolean filterResource(SruSearchAdapterResource resource, String scope, String searchsystemEndpoint) {
        logger.info("calling filterResource with parameters : scope : " + scope + ", searchsystemEndpoint : " + searchsystemEndpoint);
        logger.info("                      resource params : scope : " + resource.getScope() + ", searchsystemEndpoint : " + resource.getSearchSystemEndpoint());
        if (!(searchsystemEndpoint == null || resource.getSearchSystemEndpoint() != null && resource.getSearchSystemEndpoint().equalsIgnoreCase(searchsystemEndpoint))) {
            logger.info("resource databaseName different than : " + searchsystemEndpoint + ". resource has : " + resource.getSearchSystemEndpoint());
            return false;
        }
        if (!(scope == null || resource.getScope() != null && resource.getScope().equalsIgnoreCase(scope))) {
            logger.info("resource scope different than : " + scope + " .resource has : " + resource.getScope());
            return false;
        }
        return true;
    }
}

