/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.sru.geonetwork.service.responses;

import org.gcube.search.sru.geonetwork.service.exceptions.NotSupportedException;

public class Explain {
    private final String xmlnsSru = "http://www.loc.gov/zing/srw/";
    private final String xmlnsZr = "http://explain.z3950.org/dtd/2.0/";
    private final String dcContextIdentifier = "info:srw/cql-context-set/1/dc-v1.1";
    private final String dcSchemaIdentifier = "info:srw/schema/1/dc-v1.1";
    private final String recordSchema = "http://explain.z3950.org/dtd/2.0/";
    private Float version;
    private String recordPacking;
    private String host;
    private String port;
    private String basePath;
    private String sruName;
    private int numOfRecords;

    public Explain(Float version, String recordPacking, String host, String port, String basePath, String sruName, int numOfRecords) throws NotSupportedException {
        if (version == null) {
            version = Float.valueOf(Float.parseFloat("1.1"));
        }
        if ((double)version.floatValue() >= 1.2) {
            throw new NotSupportedException("Only version 1.1 is supported.");
        }
        this.version = version;
        if (recordPacking == null) {
            recordPacking = "xml";
        }
        if (!"xml".equals(recordPacking)) {
            throw new NotSupportedException("Record packing other than xml is not supported.");
        }
        this.recordPacking = recordPacking;
        this.host = host;
        this.port = port;
        this.basePath = basePath;
        this.sruName = sruName;
        this.numOfRecords = numOfRecords;
    }

    public String getExplainResponse() {
        String xml = "<sru:explainResponse xmlns:sru=\"http://www.loc.gov/zing/srw/\">\n\t\t\t\t <sru:version>" + this.version + "</sru:version>\n\t\t\t\t <sru:record>\n\t\t\t\t   <sru:recordPacking>" + this.recordPacking + "</sru:recordPacking>\n\t\t\t\t   <sru:recordSchema>" + "http://explain.z3950.org/dtd/2.0/" + "</sru:recordSchema>\n\t\t\t\t   <sru:recordData>\n\t\t\t\t   <zr:explain xmlns:zr=\"" + "http://explain.z3950.org/dtd/2.0/" + "\">\n\t\t\t\t     <zr:serverInfo protocol=\"SRU\" version=\"" + this.version + "\" transport=\"http\" method=\"GET POST SOAP\">\n\t\t\t\t        <zr:host>" + this.host + "</zr:host>\n\t\t\t\t        <zr:port>" + this.port + "</zr:port>\n\t\t\t\t        <zr:database>" + this.basePath + "</zr:database>\n\t\t\t\t     </zr:serverInfo>\n\t\t\t\t     <zr:databaseInfo>\n\t\t\t\t       <title lang=\"en\" primary=\"true\">" + this.sruName + "</title>\n\t\t\t\t     </zr:databaseInfo>\n\t\t\t\t     <zr:indexInfo>\n\t\t\t\t       <zr:set name=\"dc\" identifier=\"" + "info:srw/cql-context-set/1/dc-v1.1" + "\"/>\n\t\t\t\t        <zr:index>\n\t\t\t\t          <zr:map><zr:name set=\"dc\">title</zr:name></zr:map>\n\t\t\t\t        </zr:index>\n\t\t\t\t     </zr:indexInfo>\n\t\t\t\t     <zr:schemaInfo>\n\t\t\t\t        <zr:schema name=\"dc\" identifier=\"" + "info:srw/schema/1/dc-v1.1" + "\">\n\t\t\t\t          <zr:title>Simple Dublin Core</zr:title>\n\t\t\t\t        </zr:schema>\n\t\t\t\t     </zr:schemaInfo>\n\t\t\t\t     <zr:configInfo>\n\t\t\t\t         <zr:default type=\"numberOfRecords\">" + this.numOfRecords + "</zr:default>\n\t\t\t\t         <zr:setting type=\"maximumRecords\">" + this.numOfRecords + "</zr:setting>\n\t\t\t\t         <zr:supports type=\"proximity\"/>\n\t\t\t\t     </zr:configInfo>\n\t\t\t\t    </zr:explain>\n\t\t\t\t   </sru:recordData>\n\t\t\t\t </sru:record>\n\t\t\t\t</sru:explainResponse>";
        return xml;
    }

    public static void main(String[] args) throws NumberFormatException, NotSupportedException {
        Explain e = new Explain(Float.valueOf(Float.parseFloat("1.1")), "xml", "dionysus.di.uoa.gr", "8080", "aaa/aa", "srrrr", 1000);
        System.out.println(e.getExplainResponse());
    }
}

