/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.sru.geonetwork.service;

import com.google.inject.Singleton;
import it.geosolutions.geonetwork.GNClient;
import it.geosolutions.geonetwork.exception.GNLibException;
import it.geosolutions.geonetwork.exception.GNServerException;
import it.geosolutions.geonetwork.util.GNSearchRequest;
import it.geosolutions.geonetwork.util.GNSearchResponse;
import java.io.IOException;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.gcube.rest.commons.filter.IResourceFilter;
import org.gcube.rest.commons.resourceawareservice.resources.ResourceFactory;
import org.gcube.rest.commons.resourceawareservice.resources.exceptions.StatefulResourceException;
import org.gcube.rest.commons.resourcefile.IResourceFileUtils;
import org.gcube.rest.resourceawareservice.ResourceAwareService;
import org.gcube.rest.resourceawareservice.exceptions.ResourceAwareServiceException;
import org.gcube.rest.resourcemanager.discoverer.Discoverer;
import org.gcube.rest.resourcemanager.publisher.ResourcePublisher;
import org.gcube.search.sru.geonetwork.commons.api.SruGeoNwResourceFactory;
import org.gcube.search.sru.geonetwork.commons.api.SruGeoNwServiceAPI;
import org.gcube.search.sru.geonetwork.commons.resources.SruGeoNwResource;
import org.gcube.search.sru.geonetwork.service.exceptions.CqlException;
import org.gcube.search.sru.geonetwork.service.exceptions.GeonetworkAccessException;
import org.gcube.search.sru.geonetwork.service.exceptions.NotSupportedException;
import org.gcube.search.sru.geonetwork.service.parsers.CqlParser;
import org.gcube.search.sru.geonetwork.service.responses.Explain;
import org.gcube.search.sru.geonetwork.service.responses.SearchRetrieve;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

@Path(value="/")
@Singleton
public class SruGeoNwService
extends ResourceAwareService<SruGeoNwResource>
implements SruGeoNwServiceAPI {
    private String scope;
    private String hostname;
    private String port;
    private GNClient client;
    private String geonetworkUrl;
    private String username;
    private String password;
    private static final long serialVersionUID = 1L;
    private DocumentBuilder simpleDocBuilder;
    private static final Logger logger = LoggerFactory.getLogger(SruGeoNwService.class);

    public SruGeoNwService(SruGeoNwResourceFactory geoNwResource, ResourcePublisher<SruGeoNwResource> geoNwResourcePublisher, Discoverer<SruGeoNwResource> geoNwResourceDiscoverer, IResourceFilter<SruGeoNwResource> resourceFilter, IResourceFileUtils<SruGeoNwResource> resourceFileUtils, String hostname, String port) throws ResourceAwareServiceException {
        super((ResourceFactory)geoNwResource, geoNwResourcePublisher, resourceFilter, resourceFileUtils);
        this.hostname = hostname;
        this.port = port;
        try {
            geoNwResource.createResource("", "");
        }
        catch (StatefulResourceException e) {
            logger.debug("Could not create the geonetwork resources file from the default properties file. Should now create a resource manually");
        }
    }

    private void setGNClient() throws GeonetworkAccessException {
        if (this.client != null) {
            return;
        }
        for (SruGeoNwResource res : this.getAllResources()) {
            if (res.getUrl() == null || res.getUrl().isEmpty()) continue;
            logger.debug("Initializing client of geonetwork: " + res.getUrl());
            this.client = new GNClient(res.getUrl());
            this.geonetworkUrl = res.getUrl();
            this.username = res.getUsername();
            this.password = res.getPassword();
            boolean logged = this.client.login(res.getUsername(), res.getPassword());
            if (logged) break;
            logger.debug("Could not log in. Will operate only on it's public resources.");
            break;
        }
        try {
            this.simpleDocBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            logger.error("Could not instantiate the document builder");
        }
    }

    private int getTotalNumOfRepoRecords() throws GeonetworkAccessException {
        GNSearchRequest searchRequest = new GNSearchRequest();
        try {
            GNSearchResponse searchResponse;
            if (this.client == null) {
                logger.debug("Client is not initiated properly");
            }
            if ((searchResponse = this.client.search(searchRequest)) == null) {
                logger.debug("Could not search Geonetwork for maximum records");
            }
            return searchResponse.getCount();
        }
        catch (GNLibException | GNServerException ex) {
            throw new GeonetworkAccessException("Could not connect to geonetwork to retrieve the max number of metadata records.");
        }
    }

    @GET
    @Path(value="/printAllResources")
    @Produces(value={"application/xml; charset=UTF-8"})
    public Response printAllResources() {
        StringBuilder sb = new StringBuilder(1000);
        sb.append("<resources>");
        for (SruGeoNwResource res : this.getAllResources()) {
            sb.append("<resource>");
            sb.append("<id>" + res.getResourceID() + "</id>");
            sb.append("<url>" + res.getUrl() + "</url>");
            sb.append("<username>" + res.getUsername() + "</username>");
            sb.append("<password>" + res.getPassword() + "</password>");
            sb.append("</resource>");
        }
        sb.append("</resources>");
        return Response.status((Response.Status)Response.Status.OK).entity((Object)sb.toString()).build();
    }

    @POST
    @Path(value="/CreateResource")
    @Produces(value={"text/plain; charset=UTF-8"})
    public Response createResource(@HeaderParam(value="gcube-scope") String scopeHeader, @FormParam(value="resourceXML") String resourceXML, @FormParam(value="url") String url, @FormParam(value="username") String username, @FormParam(value="password") String password) throws Exception {
        if (resourceXML != null && !resourceXML.isEmpty()) {
            String resourceID = this.createResource(resourceXML);
            logger.debug("created resource with id: " + resourceID);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"Created successfully config file").build();
        }
        if (url != null && !url.isEmpty()) {
            resourceXML = "<SruGeoNwResource><url>" + url + "</url><username>" + username + "</username><password>" + password + "</password></SruGeoNwResource>";
            String resourceID = this.createResource(resourceXML);
            logger.debug("created resource with id: " + resourceID);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"Created successfully config file").build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Should provide either a 'resourceXML' parameter or a {url,username,password} parameter set").build();
    }

    @POST
    @Path(value="/RemoveResource")
    @Produces(value={"text/plain; charset=UTF-8"})
    public Response removeResource(@HeaderParam(value="gcube-scope") String scopeHeader, @FormParam(value="id") String id) throws Exception {
        boolean removed = this.destroyResource(id);
        if (removed) {
            logger.debug("removed resource with id: " + id);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)("Successfully removed config file with id: " + id)).build();
        }
        logger.debug("Could not remove resource with id: " + id);
        return Response.status((Response.Status)Response.Status.NOT_MODIFIED).entity((Object)("Could not remove config file with id: " + id)).build();
    }

    @GET
    @Path(value="/sru")
    @Produces(value={"application/xml; charset=UTF-8"})
    public Response get(@HeaderParam(value="gcube-scope") String scope, @QueryParam(value="resourceID") String resourceID, @QueryParam(value="operation") String operation, @QueryParam(value="version") Float version, @QueryParam(value="recordPacking") String recordPacking, @QueryParam(value="query") String query, @QueryParam(value="maximumRecords") Integer maximumRecords, @QueryParam(value="recordSchema") String recordSchema) {
        return this.post(scope, resourceID, operation, version, recordPacking, query, maximumRecords, recordSchema);
    }

    @POST
    @Path(value="/sru")
    @Produces(value={"application/xml; charset=UTF-8"})
    public Response post(@HeaderParam(value="gcube-scope") String scope, @FormParam(value="resourceID") String resourceID, @FormParam(value="operation") String operation, @FormParam(value="version") Float version, @FormParam(value="recordPacking") String recordPacking, @FormParam(value="query") String query, @FormParam(value="maximumRecords") Integer maximumRecords, @FormParam(value="recordSchema") String recordSchema) {
        try {
            this.setGNClient();
        }
        catch (GeonetworkAccessException ex) {
            logger.debug("", (Throwable)ex);
        }
        if ("searchRetrieve".equalsIgnoreCase(operation)) {
            try {
                GNClient client;
                boolean logged;
                if (query == null || query.isEmpty()) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Parameter 'query' was also expected.").build();
                }
                if (version == null) {
                    version = Float.valueOf("1.1");
                }
                if (!(logged = (client = new GNClient(this.geonetworkUrl)).login(this.username, this.password))) {
                    logger.debug("Could not log in. Will operate on public resources.");
                }
                CqlParser parser = new CqlParser();
                GNSearchRequest searchRequest = parser.getRequestByCqlQuery(query);
                GNSearchResponse searchResponse = client.search(searchRequest);
                logger.debug("Got " + searchResponse.getCount() + " results from geonetwork");
                SearchRetrieve sr = new SearchRetrieve(version, recordPacking, this.hostname, operation, "", "", String.valueOf(searchResponse.getCount()));
                int numToProcess = searchResponse.getCount();
                if (maximumRecords != null && maximumRecords < searchResponse.getCount()) {
                    numToProcess = maximumRecords;
                }
                Document doc = this.simpleDocBuilder.newDocument();
                Element searchRetrieveResponse = doc.createElementNS("zs", "searchRetrieveResponse");
                sr.getClass();
                searchRetrieveResponse.setAttribute("xmlns:zs", "http://explain.z3950.org/dtd/2.1/");
                Element v = doc.createElementNS("zs", "version");
                v.appendChild(doc.createTextNode(String.valueOf(version)));
                searchRetrieveResponse.appendChild(v);
                Element totalnumofrecs = doc.createElementNS("zs", "numberOfRecords");
                totalnumofrecs.appendChild(doc.createTextNode(String.valueOf(searchResponse.getCount())));
                searchRetrieveResponse.appendChild(totalnumofrecs);
                Element records = doc.createElementNS("zs", "records");
                for (int i = 0; i < numToProcess; ++i) {
                    Element record = doc.createElementNS("zs", "record");
                    Element recSchema = doc.createElementNS("zs", "recordSchema");
                    sr.getClass();
                    recSchema.appendChild(doc.createTextNode("info:srw/schema/1/dc-v1.1"));
                    record.appendChild(recSchema);
                    Element recPacking = doc.createElementNS("zs", "recordPacking");
                    recPacking.appendChild(doc.createTextNode(sr.getRecordPacking()));
                    record.appendChild(recPacking);
                    Element recData = doc.createElementNS("zs", "recordData");
                    Element rec = sr.transformRecord(client.get(searchResponse.getMetadata(i).getId()), this.simpleDocBuilder);
                    Node imported = recData.getOwnerDocument().importNode(rec, true);
                    recData.appendChild(imported);
                    record.appendChild(recData);
                    Element recPos = doc.createElementNS("zs", "recordPosition");
                    recPos.appendChild(doc.createTextNode(String.valueOf(i + 1)));
                    record.appendChild(recPos);
                    records.appendChild(record);
                }
                searchRetrieveResponse.appendChild(records);
                LSSerializer serializer = ((DOMImplementationLS)((Object)searchRetrieveResponse.getOwnerDocument().getImplementation())).createLSSerializer();
                serializer.getDomConfig().setParameter("xml-declaration", false);
                return Response.status((Response.Status)Response.Status.OK).entity((Object)serializer.writeToString(searchRetrieveResponse)).build();
            }
            catch (GNLibException | GNServerException | IOException | CqlException | NotSupportedException e) {
                e.printStackTrace();
            }
        } else if ("explain".equalsIgnoreCase(operation) || operation == null) {
            this.client = new GNClient(this.geonetworkUrl);
            GNSearchRequest searchRequest = new GNSearchRequest();
            searchRequest.addConfig(GNSearchRequest.Config.remote, "off");
            try {
                Explain explain = new Explain(version, recordPacking, this.hostname, this.port, "/", "", this.getTotalNumOfRepoRecords());
                return Response.status((Response.Status)Response.Status.OK).entity((Object)explain.getExplainResponse()).build();
            }
            catch (GeonetworkAccessException | NotSupportedException ex) {
                logger.debug("", ex);
            }
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).entity((Object)"Call ended without returning any content").build();
    }

    public String getResourceClass() {
        return "SRUResources";
    }

    public String getResourceNamePref() {
        return "SRUGeonetwork";
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }
}

