/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.sru.geonetwork.service.parsers;

import it.geosolutions.geonetwork.util.GNSearchRequest;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.gcube.search.sru.geonetwork.service.exceptions.CqlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CqlParser {
    private static final Logger logger = LoggerFactory.getLogger(CqlParser.class);

    public GNSearchRequest getRequestByCqlQuery(String cqlQuery) throws CqlException {
        if (StringUtils.containsIgnoreCase((String)cqlQuery, (String)" like ")) {
            throw new CqlException("CQL parser does not support 'like'. You can use wildcards within ordinary search terms.");
        }
        if (cqlQuery.startsWith("(") || cqlQuery.endsWith(")")) {
            return this.getRequestByCqlQueryAlternative(cqlQuery);
        }
        try {
            GNSearchRequest searchRequest = new GNSearchRequest();
            searchRequest.addConfig(GNSearchRequest.Config.remote, "off");
            if (!cqlQuery.contains("=")) {
                searchRequest.addParam(GNSearchRequest.Param.any, cqlQuery);
                return searchRequest;
            }
            logger.debug("Parsing cql and trying to transform into geonetwork query (non-cql)");
            StringBuilder cqlQueryReplica = new StringBuilder();
            boolean inQuotes = false;
            for (int i = 0; i < cqlQuery.length(); ++i) {
                if (cqlQuery.charAt(i) == '\'' || cqlQuery.charAt(i) == '\"') {
                    inQuotes = !inQuotes;
                    continue;
                }
                if (cqlQuery.charAt(i) == ' ' && inQuotes) {
                    cqlQueryReplica.append("_-_");
                    continue;
                }
                cqlQueryReplica.append(cqlQuery.charAt(i));
            }
            String[] params = cqlQueryReplica.toString().split(" ");
            for (int i = 0; i < params.length; ++i) {
                params[i] = params[i].replace("_-_", " ");
            }
            HashMap<String, String> ors = new HashMap<String, String>();
            HashMap<String, List<Object>> ands = new HashMap<String, List<Object>>();
            if (params.length == 1) {
                if (params[0].split("=")[0].equalsIgnoreCase("title")) {
                    searchRequest.addParam(GNSearchRequest.Param.title, params[0].split("=")[1]);
                } else {
                    searchRequest.addParam(GNSearchRequest.Param.any, params[0].split("=")[1]);
                }
            }
            for (int i = 1; i < params.length - 1; ++i) {
                if (params[i].contains("=")) continue;
                String prevKey = params[i - 1].split("=")[0].toLowerCase();
                String prevVal = params[i - 1].split("=")[1];
                String afterKey = params[i + 1].split("=")[0].toLowerCase();
                String afterVal = params[i + 1].split("=")[1];
                if ("and".equalsIgnoreCase(params[i])) {
                    ArrayList<String> tmp;
                    if (i > 2) {
                        if (ands.get(afterKey) != null) {
                            tmp = new ArrayList<String>();
                            tmp.addAll((Collection)ands.get(afterKey));
                            tmp.add(afterVal);
                            ands.put(afterKey, tmp);
                            continue;
                        }
                        ands.put(afterKey, Arrays.asList(afterVal));
                        continue;
                    }
                    if (ands.get(prevKey) != null) {
                        tmp = new ArrayList();
                        tmp.addAll((Collection)ands.get(prevKey));
                        tmp.add(prevVal);
                        ands.put(prevKey, tmp);
                    } else {
                        ands.put(prevKey, Arrays.asList(prevVal));
                    }
                    if (ands.get(afterKey) != null) {
                        tmp = new ArrayList();
                        tmp.addAll((Collection)ands.get(afterKey));
                        tmp.add(afterVal);
                        ands.put(afterKey, tmp);
                        continue;
                    }
                    ands.put(afterKey, Arrays.asList(afterVal));
                    continue;
                }
                if (!"or".equalsIgnoreCase(params[i])) continue;
                if (i > 2) {
                    if (ors.get(afterKey) != null) {
                        ors.put(afterKey, (String)ors.get(afterKey) + "|" + afterVal);
                        continue;
                    }
                    ors.put(afterKey, afterVal);
                    continue;
                }
                if (ors.get(prevKey) != null) {
                    ors.put(prevKey, (String)ors.get(prevKey) + "|" + prevVal);
                } else {
                    ors.put(prevKey, prevVal);
                }
                if (ors.get(afterKey) != null) {
                    ors.put(afterKey, (String)ors.get(afterKey) + "|" + afterVal);
                    continue;
                }
                ors.put(afterKey, afterVal);
            }
            for (String key : ors.keySet()) {
                if (key.equalsIgnoreCase("title")) {
                    searchRequest.addParam(GNSearchRequest.Param.title, (String)ors.get(key));
                    continue;
                }
                searchRequest.addParam(key, (String)ors.get(key));
            }
            for (String key : ands.keySet()) {
                for (String val : (List)ands.get(key)) {
                    if (key.equalsIgnoreCase("title")) {
                        searchRequest.addParam(GNSearchRequest.Param.title, val);
                        continue;
                    }
                    searchRequest.addParam(key, val);
                }
            }
            return searchRequest;
        }
        catch (Exception e) {
            return this.getRequestByCqlQueryAlternative(cqlQuery);
        }
    }

    private GNSearchRequest getRequestByCqlQueryAlternative(String cqlQuery) {
        HashMap<String, String> fieldVal = new HashMap<String, String>();
        Pattern regexp = Pattern.compile("[(][a-zA-Z_]*\\s[=]\\s[a-zA-Z_]*[)]");
        Matcher matcher = regexp.matcher(cqlQuery);
        while (matcher.find()) {
            String pairs = matcher.group(0);
            pairs = pairs.substring(1, pairs.length() - 1);
            fieldVal.put(pairs.split(" = ")[0], pairs.split(" = ")[1]);
        }
        GNSearchRequest searchRequest = new GNSearchRequest();
        searchRequest.addConfig(GNSearchRequest.Config.remote, "off");
        String searchValue = (String)fieldVal.entrySet().iterator().next().getValue();
        if (fieldVal.keySet().size() > 1) {
            searchRequest.addParam(GNSearchRequest.Param.any, searchValue);
            return searchRequest;
        }
        if (fieldVal.get("title") != null) {
            searchRequest.addParam(GNSearchRequest.Param.title, searchValue);
        } else {
            searchRequest.addParam(GNSearchRequest.Param.any, searchValue);
        }
        return searchRequest;
    }

    public void writeToFile(String pFilename, StringBuffer pData) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(pFilename));
        out.write(pData.toString());
        out.flush();
        out.close();
    }

    public StringBuffer readFromFile(String pFilename) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(pFilename));
        StringBuffer data = new StringBuffer();
        int c = 0;
        while ((c = in.read()) != -1) {
            data.append((char)c);
        }
        in.close();
        return data;
    }
}

