/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.sru.geonetwork.service.responses;

import com.google.common.io.Resources;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.gcube.search.sru.geonetwork.service.exceptions.NotSupportedException;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchRetrieve {
    public static final Logger logger = LoggerFactory.getLogger(SearchRetrieve.class);
    public final String xmlnsSru = "http://www.loc.gov/zing/srw/";
    public final String xmlnsZr = "http://explain.z3950.org/dtd/2.1/";
    public final String dcContextIdentifier = "info:srw/cql-context-set/1/dc-v1.1";
    public final String dcSchemaIdentifier = "info:srw/schema/1/dc-v1.1";
    public final String recordSchema = "info:srw/schema/1/dc-v1.1";
    private Float version;
    private String recordPacking;
    private String totalNumRecords;
    private Transformer xsltTransformer;

    public SearchRetrieve(Float version, String recordPacking, String host, String port, String basePath, String sruName, String totalNumRecords) throws NotSupportedException, IOException {
        if ((double)version.floatValue() >= 1.2) {
            throw new NotSupportedException("Only version 1.1 is supported.");
        }
        this.version = version;
        if (recordPacking == null) {
            recordPacking = "xml";
        }
        if (!"xml".equals(recordPacking)) {
            throw new NotSupportedException("Record packing other than xml is not supported. Will output xml.");
        }
        this.recordPacking = recordPacking;
        this.totalNumRecords = totalNumRecords;
        try {
            this.xsltTransformer = TransformerFactory.newInstance().newTransformer(new StreamSource(Resources.getResource((String)"gmd2dc.xsl").openStream()));
        }
        catch (TransformerConfigurationException | TransformerFactoryConfigurationError e) {
            logger.debug("Could not instantiate the XSLT transformer", e);
        }
        this.xsltTransformer.setOutputProperty("indent", "yes");
        this.xsltTransformer.setOutputProperty("omit-xml-declaration", "yes");
    }

    public org.w3c.dom.Element transformRecord(Element geonetworkRecord, DocumentBuilder docBuilder) {
        try {
            StringReader reader = new StringReader(this.elemToString(geonetworkRecord));
            StringWriter writer = new StringWriter();
            this.xsltTransformer.transform(new StreamSource(reader), new StreamResult(writer));
            org.w3c.dom.Element transElem = docBuilder.parse(new ByteArrayInputStream(writer.toString().getBytes("UTF-8"))).getDocumentElement();
            return transElem;
        }
        catch (Exception e) {
            logger.debug("Could not transform the record into dc format, using the xslt");
            return null;
        }
    }

    private String elemToString(Element elem) {
        return new XMLOutputter(Format.getPrettyFormat()).outputString(elem);
    }

    public String getRecordPacking() {
        return this.recordPacking;
    }

    public Float getVersion() {
        return this.version;
    }
}

