/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.sru.geonetwork.commons.api;

import com.google.common.io.Resources;
import java.io.InputStream;
import java.util.Properties;
import java.util.UUID;
import org.gcube.rest.commons.resourceawareservice.resources.ResourceFactory;
import org.gcube.rest.commons.resourceawareservice.resources.exceptions.StatefulResourceException;
import org.gcube.search.sru.geonetwork.commons.resources.SruGeoNwResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SruGeoNwResourceFactory
extends ResourceFactory<SruGeoNwResource> {
    private static final Logger logger = LoggerFactory.getLogger(SruGeoNwResourceFactory.class);

    public String getScope() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SruGeoNwResource createResource(String resourceID, String resourceAsXML) throws StatefulResourceException {
        if (resourceAsXML != null && !resourceAsXML.isEmpty()) {
            logger.debug("Creating resource from XML: " + resourceAsXML);
            SruGeoNwResource resource = SruGeoNwResource.fromXML(resourceAsXML);
            if (resourceID == null || !resourceID.isEmpty()) {
                resource.setResourceID(UUID.randomUUID().toString());
            }
            if (resource != null) {
                return resource;
            }
        }
        SruGeoNwResource sruGeoNwResource2 = new SruGeoNwResource();
        Properties properties = new Properties();
        logger.debug("Trying to load default properties for a geonetwork from within war file: geonetwork.properties");
        try (InputStream is = Resources.getResource((String)"geonetwork.properties").openStream();){
            properties.load(is);
            sruGeoNwResource2.setUrl(properties.getProperty("url"));
            sruGeoNwResource2.setUsername(properties.getProperty("username"));
            sruGeoNwResource2.setPassword(properties.getProperty("password"));
            SruGeoNwResource sruGeoNwResource = sruGeoNwResource2;
            return sruGeoNwResource;
        }
        catch (Exception e) {
            logger.debug("Could not load property file  : geonetwork.properties");
            return new SruGeoNwResource();
        }
    }
}

