/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.sru.db.service.resources;

import com.google.common.io.Resources;
import com.google.gson.Gson;
import java.io.InputStream;
import java.util.Properties;
import org.gcube.rest.commons.resourceawareservice.resources.ResourceFactory;
import org.gcube.rest.commons.resourceawareservice.resources.exceptions.StatefulResourceException;
import org.gcube.search.sru.db.common.resources.SruDBResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SruDBResourceFactory
extends ResourceFactory<SruDBResource> {
    private static final Logger logger = LoggerFactory.getLogger(SruDBResourceFactory.class);
    private static final String SCOPE_PROP = "scope";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getScope() {
        Properties properties = new Properties();
        try (InputStream is = Resources.getResource((String)"deploy.properties").openStream();){
            properties.load(is);
            String string = properties.getProperty(SCOPE_PROP);
            return string;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not load property file  : deploy.properties");
        }
    }

    public SruDBResource createResource(String resourceID, String params) throws StatefulResourceException {
        SruDBResource resource = (SruDBResource)new Gson().fromJson(params, SruDBResource.class);
        if (resource.getScope() != null && !resource.getScope().equalsIgnoreCase(this.getScope())) {
            logger.error("scope set to : " + resource.getScope() + " but different to : " + this.getScope());
            throw new StatefulResourceException("scope set to : " + resource.getScope() + " but different to : " + this.getScope());
        }
        resource.setResourceID(resourceID);
        return resource;
    }
}

