/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.sru.db.service;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.URLDecoder;
import java.sql.SQLException;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.gcube.rest.commons.filter.IResourceFilter;
import org.gcube.rest.commons.resourceawareservice.resources.ResourceFactory;
import org.gcube.rest.commons.resourcefile.IResourceFileUtils;
import org.gcube.rest.resourceawareservice.ResourceAwareService;
import org.gcube.rest.resourceawareservice.exceptions.ResourceAwareServiceException;
import org.gcube.rest.resourceawareservice.exceptions.ResourceNotFoundException;
import org.gcube.rest.resourcemanager.publisher.ResourcePublisher;
import org.gcube.search.sru.db.DB;
import org.gcube.search.sru.db.common.apis.SruDBServiceAPI;
import org.gcube.search.sru.db.common.resources.SruDBResource;
import org.gcube.search.sru.db.service.ResponseObj;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/")
@Singleton
public class SruDBService
extends ResourceAwareService<SruDBResource>
implements SruDBServiceAPI {
    static final Logger logger = LoggerFactory.getLogger(SruDBService.class);
    boolean splitLists;
    private String scope;

    @Inject
    public SruDBService(ResourceFactory<SruDBResource> factory, ResourcePublisher<SruDBResource> publisher, IResourceFilter<SruDBResource> resourceFilter, IResourceFileUtils<SruDBResource> resourceFileUtils) throws ResourceAwareServiceException {
        super(factory, publisher, resourceFilter, resourceFileUtils);
        logger.info("SruDBService initialized");
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setSplitLists(boolean splitLists) {
        this.splitLists = splitLists;
    }

    public String getScope() {
        return this.scope;
    }

    public String getResourceClass() {
        return "SruDBAdapterResources";
    }

    public String getResourceNamePref() {
        return "SruDBAdapterResource";
    }

    public Response ping() {
        return Response.ok().entity((Object)"pong").build();
    }

    public Response get(String scope, String resourceID, String operation, Float version, String recordPacking, String query, Integer maximumRecords, String recordSchema) {
        logger.info("---------------------------------------");
        logger.info("operation       : " + operation);
        logger.info("version         : " + version);
        logger.info("recordPacking   : " + recordPacking);
        logger.info("query           : " + query);
        logger.info("maximumRecords  : " + maximumRecords);
        logger.info("recordSchema    : " + recordSchema);
        SruDBResource resource = null;
        try {
            resource = (SruDBResource)this.getResource(resourceID);
        }
        catch (ResourceNotFoundException e) {
            logger.warn("error while getting resource", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ResponseObj("Resource with ID : " + resourceID + " not found")).build();
        }
        if (operation == null || operation.equalsIgnoreCase("explain")) {
            DB db = new DB.Builder().serverHost(resource.getHostname()).serverPort(resource.getPort()).databaseName(resource.getDbName()).databaseType(resource.getDbType()).databaseUsername(resource.getUsername()).databasePassword(resource.getPassword()).databaseTitle(resource.getDbTitle()).databaseName(resource.getDbName()).schemaID(resource.getExplainInfo().getSchemaID()).schemaName(resource.getExplainInfo().getSchemaName()).recordSchema(resource.getExplainInfo().getRecordSchema()).recordPacking(resource.getExplainInfo().getRecordPacking()).indexSets(resource.getExplainInfo().getIndexSets()).indexInfo(resource.getExplainInfo().getIndexInfo()).defaultTable(resource.getExplainInfo().getDefaultTable()).build();
            db.initializeExplain();
            return Response.ok().entity((Object)db.getExplain()).build();
        }
        if (operation.equalsIgnoreCase("searchRetrieve")) {
            if (version != null && (double)version.floatValue() >= 1.2) {
                String msg = SruDBService.diagnostics((Integer)5, (String)"Unsupported version", (String)"1.1");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ResponseObj(msg)).build();
            }
            if (maximumRecords != null && maximumRecords < 0) {
                String msg = SruDBService.diagnostics((Integer)6, (String)"unsupported parameter value", (String)maximumRecords.toString());
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ResponseObj(msg)).build();
            }
            if (query == null) {
                String msg = SruDBService.diagnostics((Integer)7, (String)"Mandatory parameter not supplied", (String)"query");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ResponseObj(msg)).build();
            }
            try {
                query = URLDecoder.decode(query, "UTF-8");
                logger.info("Query = " + query);
                DB db = new DB.Builder().serverHost(resource.getHostname()).serverPort(resource.getPort()).databaseName(resource.getDbName()).databaseType(resource.getDbType()).databaseUsername(resource.getUsername()).databasePassword(resource.getPassword()).databaseTitle(resource.getDbTitle()).databaseName(resource.getDbName()).schemaID(resource.getExplainInfo().getSchemaID()).schemaName(resource.getExplainInfo().getSchemaName()).recordSchema(resource.getExplainInfo().getRecordSchema()).recordPacking(resource.getExplainInfo().getRecordPacking()).indexSets(resource.getExplainInfo().getIndexSets()).indexInfo(resource.getExplainInfo().getIndexInfo()).defaultTable(resource.getExplainInfo().getDefaultTable()).build();
                logger.info("connecting to db...");
                HashBiMap fieldsMapping = HashBiMap.create();
                fieldsMapping.putAll(resource.getFieldsMapping());
                String results = db.connectToAndQueryDatabase(query, (BiMap)fieldsMapping, this.splitLists);
                return Response.ok().entity((Object)results).build();
            }
            catch (ClassNotFoundException e) {
                logger.error("connection to the database problem", (Throwable)e);
                return Response.serverError().entity((Object)new ResponseObj("error connecting to the database")).build();
            }
            catch (SQLException e) {
                logger.error("Query syntax error", (Throwable)e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)SruDBService.diagnostics((Integer)10, (String)"Query syntax error", (String)query)).build();
            }
            catch (Exception e) {
                logger.error("error", (Throwable)e);
                return Response.serverError().entity((Object)SruDBService.diagnostics((Integer)10, (String)("error : " + e.getMessage()), (String)query)).build();
            }
        }
        if (operation.equalsIgnoreCase("scan")) {
            return Response.ok().entity((Object)SruDBService.scan()).build();
        }
        return Response.serverError().entity((Object)SruDBService.diagnostics((Integer)10, (String)("unsupported operation : " + operation), (String)query)).build();
    }

    static String diagnostics(Integer code, String message, String details) {
        String xml = "<?xml version=\"1.0\"?>\n\t<diagnostics>\n\t\t<diagnostic xmlns=\"http://www.loc.gov/zing/srw/diagnostic/\">\n\t\t\t<uri>info:srw/diagnostic/1/" + code + "</uri>\n\t\t\t<message>" + message + "</message>\n\t\t\t<details>" + details + "</details>\n\t\t</diagnostic>\n\t</diagnostics>\n";
        return xml;
    }

    static String scan() {
        String xml = "<?xml version=\"1.0\"?><zs:scanResponse xmlns:zs=\"http://www.loc.gov/zing/srw/\">\t<zs:version>1.1</zs:version>\t<zs:diagnostics xmlns=\"http://www.loc.gov/zing/srw/diagnostic/\">\t\t<diagnostic>\t\t\t<uri>info:srw/diagnostic/1/4</uri>\t\t\t<message>Unsupported operation</message>\t\t\t<details>scan</details>\t\t</diagnostic>\t</zs:diagnostics></zs:scanResponse>";
        return xml;
    }
}

