/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.sru.db;

import com.google.common.base.Splitter;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mysql.jdbc.Driver;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.search.sru.db.CqlToSql;
import org.gcube.search.sru.db.DB;
import org.gcube.search.sru.db.RecordConverter;
import org.gcube.search.sru.db.SruDBExplain;
import org.gcube.search.sru.db.common.resources.ExplainInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlite.JDBC;

/*
 * Exception performing whole class analysis ignored.
 */
public class DB {
    static String DB_TITLE_PROP = "title";
    static String DB_DESCRIPTION_PROP = "description";
    static String DB_LINK_PROP = "link";
    static String DB_LASTBUILDDATE_PROP = "lastBuildDate";
    static String DB_PUBDATE_PROP = "pubDate";
    static String DB_TTL_PROP = "ttl";
    static String DB_TITLE = "This is the title";
    static String DB_LINK = "http://example.com";
    static String DB_DESCRIPTION = "This is a dummy description";
    static String DB_PUBDATE = new Date().toString();
    static String DB_LASTBUILDDATE = new Date().toString();
    static String DB_TTL = "0";
    private String serverHost;
    private Integer serverPort;
    private String databaseName;
    private String databaseType;
    private String databaseUsername;
    private String databasePassword;
    private String defaultTable;
    private ExplainInfo explainInfo;
    private SruDBExplain explain;
    private String databaseTitle;
    private String databaseDescription;
    private RecordConverter recordConverter = new RecordConverter();
    private static Map<String, Class<?>> databaseTypes = ImmutableMap.builder().put((Object)"mysql", Driver.class).put((Object)"postrgres", org.postgresql.Driver.class).put((Object)"sqlite", JDBC.class).build();
    private static final Logger logger = LoggerFactory.getLogger(DB.class);

    private DB(Builder builder) {
        this.databaseName = Builder.access$100((Builder)builder);
        this.databaseType = Builder.access$200((Builder)builder);
        this.databaseUsername = Builder.access$300((Builder)builder);
        this.databasePassword = Builder.access$400((Builder)builder);
        this.databaseUsername = Builder.access$300((Builder)builder);
        this.databasePassword = Builder.access$400((Builder)builder);
        this.databaseTitle = Builder.access$500((Builder)builder);
        this.databaseDescription = Builder.access$600((Builder)builder);
        this.defaultTable = Builder.access$700((Builder)builder);
        this.serverHost = Builder.access$800((Builder)builder);
        this.serverPort = Builder.access$900((Builder)builder);
        this.explainInfo = new ExplainInfo();
        this.explainInfo.setIndexInfo(Builder.access$1000((Builder)builder));
        this.explainInfo.setIndexSets(Builder.access$1100((Builder)builder));
        this.explainInfo.setSchemaID(Builder.access$1200((Builder)builder));
        this.explainInfo.setSchemaName(Builder.access$1300((Builder)builder));
        this.explainInfo.setRecordPacking(Builder.access$1400((Builder)builder));
        this.explainInfo.setRecordSchema(Builder.access$1500((Builder)builder));
        logger.info("indexInfo : " + Builder.access$1000((Builder)builder));
        logger.info("indexSets : " + Builder.access$1100((Builder)builder));
    }

    public static void main(String[] args) throws Exception {
        HashBiMap map = HashBiMap.create();
        map.put((Object)"creator", (Object)"author");
        DB db = new DB("localhost", Integer.valueOf(3306), "test", "mysql", "root", "alexis87", "");
        String sql = db.connectToAndQueryDatabase("books.author = \"myauthor\"", (BiMap)map, false);
        System.out.println(sql);
    }

    public DB(String serverHost, Integer serverPort, String databaseName, String databaseType, String databaseUsername, String databasePassword, String defaultTable) {
        this.serverHost = serverHost;
        this.serverPort = serverPort;
        this.databaseName = databaseName;
        this.databaseType = databaseType;
        this.databaseUsername = databaseUsername;
        this.databasePassword = databasePassword;
        this.defaultTable = defaultTable;
    }

    public String getExplain() {
        return this.explain.getExplainXML();
    }

    public void initializeExplain() {
        this.explain = new SruDBExplain();
        this.explain.version = "1.1";
        this.explain.recordSchema = this.explainInfo.getRecordSchema();
        this.explain.recordPacking = this.explainInfo.getRecordPacking();
        this.explain.serverHost = this.serverHost;
        this.explain.serverPort = this.serverPort;
        this.explain.databaseName = this.databaseName;
        this.explain.databaseTitle = this.databaseTitle;
        this.explain.databaseDescription = this.databaseDescription;
        this.explain.indexSets = Maps.newHashMap((Map)this.explainInfo.getIndexSets());
        this.explain.indexInfo = Maps.newHashMap((Map)this.explainInfo.getIndexInfo());
        this.explain.schemaID = this.explainInfo.getSchemaID();
        this.explain.schemaName = this.explainInfo.getSchemaName();
    }

    public String connectToAndQueryDatabase(String cqlQuery, BiMap<String, String> fieldsMapping, boolean splitLists) throws Exception {
        return this.connectToAndQueryDatabase(cqlQuery, "SRU", fieldsMapping, splitLists);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String connectToAndQueryDatabase(String cqlQuery, String schema, BiMap<String, String> fieldsMapping, boolean splitLists) throws Exception {
        logger.info("Driver : " + databaseTypes.get(this.databaseType));
        try (Connection con = DriverManager.getConnection("jdbc:" + this.databaseType + "://" + this.serverHost + ":" + this.serverPort + "/" + this.databaseName, this.databaseUsername, this.databasePassword);){
            String sru;
            logger.info("got cql query : " + cqlQuery);
            String cqlQueryMapped = this.mapCqlQuery(cqlQuery, fieldsMapping);
            logger.info("replaced cql query : " + cqlQueryMapped);
            logger.info("defaultTable : " + this.defaultTable);
            CqlToSql cts = new CqlToSql(cqlQueryMapped, this.defaultTable);
            cts.parseQuery();
            String sqlQuery = cts.getSqlQuery();
            logger.info("sql query       : " + sqlQuery);
            String sqlCountQuery = cts.getSqlCountQuery();
            logger.info("sql count query : " + sqlCountQuery);
            ResultSet rsCount = this.executeQuery(con, sqlCountQuery);
            Long resultsCnt = null;
            if (rsCount.next()) {
                resultsCnt = rsCount.getLong(1);
            }
            logger.info("count : " + resultsCnt);
            ResultSet rs = this.executeQuery(con, sqlQuery);
            List records = this.dbResultSetToRecords(rs, (Map)fieldsMapping.inverse());
            logger.trace("record retrieved : " + records);
            String string = sru = this.recordConverter.convertRecordsToSru(resultsCnt, records, splitLists);
            return string;
        }
    }

    List<Map<String, String>> dbResultSetToRecords(ResultSet rs, Map<String, String> sqlToSchemaMapping) throws SQLException {
        ArrayList records = Lists.newArrayList();
        ResultSetMetaData rsmd = rs.getMetaData();
        int colCount = rsmd.getColumnCount();
        while (rs.next()) {
            HashMap rec = Maps.newHashMap();
            for (int i = 1; i <= colCount; ++i) {
                String sqlColumnName = rsmd.getColumnName(i);
                Object value = rs.getObject(i);
                String strVal = value.toString();
                String schemaFieldName = sqlToSchemaMapping.get(sqlColumnName);
                logger.trace("no mapping found for : " + schemaFieldName + ". will try last part if any");
                if (schemaFieldName != null) {
                    rec.put(schemaFieldName, strVal);
                    continue;
                }
                List sqlColumnParts = Splitter.on((String)".").omitEmptyStrings().splitToList((CharSequence)sqlColumnName);
                if (sqlColumnParts.size() <= 1) continue;
                String lastPart = (String)sqlColumnParts.get(sqlColumnParts.size() - 1);
                logger.trace("last part : " + lastPart);
                schemaFieldName = sqlToSchemaMapping.get(lastPart);
                if (schemaFieldName == null) continue;
                rec.put(schemaFieldName, strVal);
            }
            records.add(rec);
        }
        return records;
    }

    private String mapCqlQuery(String cqlQuery, Map<String, String> fieldsMapping) {
        String newQuery = cqlQuery;
        for (Map.Entry<String, String> entry : fieldsMapping.entrySet()) {
            String fieldID = entry.getKey();
            String fieldName = entry.getValue();
            newQuery = newQuery.replace(fieldID, fieldName);
        }
        newQuery = newQuery.replace("cql.", "");
        newQuery = newQuery.replace("oai_dc.", "");
        newQuery = newQuery.replace("dc.", "");
        return newQuery;
    }

    ResultSet executeQuery(Connection con, String query) throws SQLException {
        Statement stmt = con.createStatement();
        stmt.closeOnCompletion();
        ResultSet rs = stmt.executeQuery(query);
        return rs;
    }
}

