/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.sru.consumer.service;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.gcube.datatransformation.DataTransformationClient;
import org.gcube.datatransformation.client.library.exceptions.DTSClientException;
import org.gcube.rest.commons.filter.IResourceFilter;
import org.gcube.rest.commons.helpers.JSONConverter;
import org.gcube.rest.commons.resourceawareservice.resources.ResourceFactory;
import org.gcube.rest.commons.resourcefile.IResourceFileUtils;
import org.gcube.rest.resourceawareservice.ResourceAwareService;
import org.gcube.rest.resourceawareservice.exceptions.ResourceNotFoundException;
import org.gcube.rest.resourcemanager.publisher.ResourcePublisher;
import org.gcube.search.sru.consumer.common.apis.SruConsumerServiceAPI;
import org.gcube.search.sru.consumer.common.resources.SruConsumerResource;
import org.gcube.search.sru.consumer.parser.sruparser.SRUParser;
import org.gcube.search.sru.consumer.service.ResponseObj;
import org.gcube.search.sru.consumer.service.ServiceContext;
import org.gcube.search.sru.consumer.service.helpers.ParserHelper;
import org.gcube.search.sru.consumer.service.helpers.QueryParserHelper;
import org.gcube.search.sru.consumer.service.helpers.RRHelper;
import org.gcube.search.sru.consumer.service.helpers.ResultSetHelpers;
import org.gcube.search.sru.consumer.service.helpers.URLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/")
@Singleton
public class SruConsumerService
extends ResourceAwareService<SruConsumerResource>
implements SruConsumerServiceAPI {
    static final Logger logger = LoggerFactory.getLogger(SruConsumerService.class);
    QueryParserHelper queryParserHelper = new QueryParserHelper();
    SRUParser parser = new SRUParser();
    private String scope;

    @Inject
    public SruConsumerService(ResourceFactory<SruConsumerResource> factory, ResourcePublisher<SruConsumerResource> publisher, IResourceFilter<SruConsumerResource> resourceFilter, IResourceFileUtils<SruConsumerResource> resourceFileUtils) throws Exception {
        super(factory, publisher, resourceFilter, resourceFileUtils);
        logger.info("SruConsumerService initialized");
    }

    public void initialize() throws Exception {
        new ServiceContext().initialize();
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope;
    }

    public String getResourceClass() {
        return "SruConsumerResources";
    }

    public String getResourceNamePref() {
        return "SruConsumerResource";
    }

    public Response ping() {
        return Response.ok().entity((Object)"pong").build();
    }

    public Response query(String scope, String resourceID, String queryString, Long maxRecords, Boolean result, Boolean useRR) {
        SruConsumerResource resource = null;
        try {
            resource = (SruConsumerResource)this.getResource(resourceID);
        }
        catch (ResourceNotFoundException e) {
            logger.warn("error while getting resource", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ResponseObj("Resource with ID : " + resourceID + " not found")).build();
        }
        try {
            SruConsumerResource.DescriptionDocument dd = resource.getDescriptionDocument();
            logger.info("got description document");
            HashBiMap fieldsMapping = null;
            logger.info("received query : " + queryString);
            if (useRR.booleanValue()) {
                fieldsMapping = HashBiMap.create();
                fieldsMapping.putAll(RRHelper.getFieldsMapping((String)scope));
                queryString = this.queryParserHelper.replaceFields(queryString, (Map)fieldsMapping.inverse());
                logger.info("using rr. query changed to : " + queryString + " and fieldsMapping : " + fieldsMapping);
            }
            logger.info("fieldsMapping : " + fieldsMapping);
            String queryPart = this.queryParserHelper.getQueryPart(queryString);
            logger.info("query part : " + queryPart);
            List searchables = resource.getSearchables();
            List presentables = resource.getPresentables();
            logger.info("resource searchables  : " + searchables);
            logger.info("resource presentables : " + presentables);
            List projections = this.queryParserHelper.getProjectPart(queryString, presentables);
            if (projections.contains("S")) {
                logger.info("S field found in projections. will be replaced with : " + resource.getSnippetField());
                projections.remove("S");
                if (resource.getSnippetField() != null) {
                    projections.add(resource.getSnippetField());
                }
            }
            logger.info("query projections : " + projections);
            logger.info("query before parser : " + queryPart);
            queryPart = this.parser.parse(queryPart, null, searchables).toCQL();
            logger.info("query after parser : " + queryPart);
            String urlString = new URLHelper.SearchRetrieveRequest().descriptionDocument(dd).query(queryPart).maximumRecords(maxRecords).build();
            logger.info("query url for the description document : " + urlString);
            if (result.booleanValue()) {
                List records = ParserHelper.parseResponse((DataTransformationClient)SruConsumerService.getDTSClient((String)this.scope), (String)urlString, (SruConsumerResource)resource, (List)projections, (Map)fieldsMapping, (String)resource.getSnippetField());
                logger.info("records extracted : " + records);
                return Response.status((Response.Status)Response.Status.OK).entity((Object)records).build();
            }
            String grs2Locator = ResultSetHelpers.writeResponseFromUrlToGRS2((DataTransformationClient)SruConsumerService.getDTSClient((String)this.scope), (String)urlString, (SruConsumerResource)resource, (List)projections, (BiMap)fieldsMapping, (String)resource.getSnippetField());
            String msg = JSONConverter.convertToJSON((String)"grslocator", (Object)grs2Locator);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)msg).build();
        }
        catch (Exception e) {
            logger.error("error while querying the resource : " + resourceID + " for : " + queryString, (Throwable)e);
            return Response.serverError().entity((Object)new ResponseObj("error while querying the resource : " + resourceID + " for : " + queryString)).build();
        }
    }

    public Response explain(String scope, String resourceID) {
        SruConsumerResource resource = null;
        try {
            resource = (SruConsumerResource)this.getResource(resourceID);
        }
        catch (ResourceNotFoundException e) {
            logger.warn("error while getting resource", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ResponseObj("Resource with ID : " + resourceID + " not found")).build();
        }
        try {
            SruConsumerResource.DescriptionDocument dd = resource.getDescriptionDocument();
            logger.info("got description document");
            String urlString = new URLHelper.ExplainRequest().descriptionDocument(dd).build();
            logger.info("explain url for the description document : " + urlString);
            String xml = URLHelper.urlToString((String)urlString);
            logger.info("xml retrieved from url : " + xml);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)xml).build();
        }
        catch (Exception e) {
            logger.error("error while getting the explain for resource : " + resourceID, (Throwable)e);
            return Response.serverError().entity((Object)new ResponseObj("error while getting the explain for resource :" + resourceID)).build();
        }
    }

    static DataTransformationClient getDTSClient(String scope) throws DTSClientException {
        DataTransformationClient dtsclient = new DataTransformationClient();
        dtsclient.setScope(scope);
        dtsclient.randomClient();
        return dtsclient;
    }
}

