/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.searchsystem.searchsystemservice;

import gr.uoa.di.madgik.environment.hint.EnvHint;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.environment.hint.NamedEnvHint;
import java.util.ArrayList;
import java.util.Calendar;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.searchsystem.cache.PlanCache;
import org.gcube.searchsystem.cache.PlanCacheManager;
import org.gcube.searchsystem.environmentadaptor.EnvironmentAdaptor;
import org.gcube.searchsystem.environmentadaptor.ResourceRegistryAdapter;
import org.gcube.searchsystem.planning.Orchestrator;
import org.gcube.searchsystem.searchsystemservice.ServiceContext;
import org.gcube.searchsystem.searchsystemservice.stubs.SearchResponse;
import org.gcube.searchsystem.searchsystemservice.stubs.StringArray;
import org.gcube.searchsystem.workflow.PE2ngWorkflowAdaptor;
import org.gcube.searchsystem.workflow.WorkflowEngineAdaptor;

public class SearchSystemService
extends GCUBEPortType {
    private static GCUBELog logger = new GCUBELog(SearchSystemService.class);

    public SearchResponse search(String query) throws GCUBEFault {
        try {
            logger.info((Object)("received query: " + query));
            long start = Calendar.getInstance().getTimeInMillis();
            Orchestrator orchestrator = new Orchestrator();
            PlanCache pCache = PlanCacheManager.getCacheWithName((String)ServiceContext.getContext().getScope().toString());
            EnvHintCollection adaptorHints = ServiceContext.getContext().getHints();
            adaptorHints.AddHint(new NamedEnvHint("GCubeActionScope", new EnvHint(ServiceContext.getContext().getScope().toString())));
            String rsEpr = orchestrator.search(query, (EnvironmentAdaptor)new ResourceRegistryAdapter(adaptorHints), (WorkflowEngineAdaptor)new PE2ngWorkflowAdaptor(adaptorHints), pCache);
            ArrayList warnings = orchestrator.getWarnings();
            long end = Calendar.getInstance().getTimeInMillis();
            logger.info((Object)("finished after (millisecs): " + (end - start)));
            SearchResponse response = new SearchResponse(rsEpr, new StringArray(warnings.toArray(new String[warnings.size()])));
            return response;
        }
        catch (Exception e) {
            logger.error((Object)"Error while executing query:", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{e.getMessage()});
        }
    }

    protected GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }
}

