/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.searchsystem.environmentadaptor;

import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.bridge.RegistryBridge;
import gr.uoa.di.madgik.rr.element.query.QueryHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.searchsystem.environmentadaptor.EnvironmentAdaptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryAdapter
implements EnvironmentAdaptor {
    private String scope;
    private static Logger logger = LoggerFactory.getLogger((String)ResourceRegistryAdapter.class.getName());

    public static boolean initializeAdapter() throws Exception {
        try {
            ResourceRegistry.startBridging();
        }
        catch (Exception e) {
            logger.error("Could not start bridging", (Throwable)e);
            return false;
        }
        return true;
    }

    public ResourceRegistryAdapter(EnvHintCollection hints) {
        if (hints.HintExists("GCubeActionScope")) {
            this.scope = hints.GetHint((String)"GCubeActionScope").Hint.Payload;
        }
    }

    @Override
    public HashMap<String, HashSet<String>> getProjectionsPerSource(Set<String> sources, Set<String> projectionsNeeded, HashMap<String, HashSet<String>> colLangs) throws Exception {
        return QueryHelper.getProjectionsPerSource(sources, projectionsNeeded, colLangs, (String)this.scope);
    }

    @Override
    public Map<String, Set<String>> getCollectionLangsByFieldRelation(Map<String, List<String>> fieldRelationMap, List<String> projections) throws Exception {
        return QueryHelper.getCollectionLangsByFieldRelation(fieldRelationMap, projections, (String)this.scope);
    }

    @Override
    public Set<String> getCollectionByFieldRelationLang(Map<String, List<String>> fieldRelationMap, String language, List<String> projections) throws Exception {
        return QueryHelper.getCollectionByFieldRelationLang(fieldRelationMap, (String)language, projections, (String)this.scope);
    }

    @Override
    public Set<String> getLanguageByFieldRelationCol(Map<String, List<String>> fieldRelationMap, String collection, List<String> projections) throws Exception {
        return QueryHelper.getLanguageByFieldRelationCol(fieldRelationMap, (String)collection, projections, (String)this.scope);
    }

    @Override
    public Set<String> getSourceIdsForFieldRelationCollectionLanguage(String field, String relation, String collection, String language, String indication) throws Exception {
        return new HashSet<String>(QueryHelper.getSourceIdsForFieldRelationCollectionLanguage((String)field, (String)relation, (String)collection, (String)language, (String)this.scope));
    }

    @Override
    public long getLastUpdate() {
        return RegistryBridge.getLastUpdate();
    }
}

