/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.searchsystem.planning.maxsubtree;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.gcube.searchsystem.planning.exception.CQLUnsupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import search.library.util.cql.query.tree.GCQLAndNode;
import search.library.util.cql.query.tree.GCQLNode;
import search.library.util.cql.query.tree.GCQLNotNode;
import search.library.util.cql.query.tree.GCQLOrNode;
import search.library.util.cql.query.tree.GCQLRelation;
import search.library.util.cql.query.tree.GCQLTermNode;
import search.library.util.cql.query.tree.Modifier;

public class TreeTransformer {
    private static Logger logger = LoggerFactory.getLogger((String)TreeTransformer.class.getName());

    private TreeTransformer() {
    }

    public static ArrayList<Set<GCQLCondition>> pushNotDownOrUp(GCQLNode node, boolean revert) throws CQLUnsupportedException {
        if (node instanceof GCQLTermNode) {
            return TreeTransformer.pushNotDownOrUp((GCQLTermNode)node, revert);
        }
        if (node instanceof GCQLAndNode) {
            return TreeTransformer.pushNotDownOrUp((GCQLAndNode)node, revert);
        }
        if (node instanceof GCQLOrNode) {
            return TreeTransformer.pushNotDownOrUp((GCQLOrNode)node, revert);
        }
        if (node instanceof GCQLNotNode) {
            return TreeTransformer.pushNotDownOrUp((GCQLNotNode)node, revert);
        }
        throw new CQLUnsupportedException("reached a node of unsupported type: " + node.getClass().getName());
    }

    private static ArrayList<Set<GCQLCondition>> pushNotDownOrUp(GCQLTermNode node, boolean revert) throws CQLUnsupportedException {
        logger.trace("Not: " + revert + ", TermNode: " + node.toCQL());
        GCQLCondition condition = new GCQLCondition(node, revert);
        HashSet<GCQLCondition> array = new HashSet<GCQLCondition>();
        array.add(condition);
        ArrayList<Set<GCQLCondition>> result = new ArrayList<Set<GCQLCondition>>();
        result.add(array);
        return result;
    }

    private static ArrayList<Set<GCQLCondition>> pushNotDownOrUp(GCQLAndNode node, boolean revert) throws CQLUnsupportedException {
        ArrayList<Set<GCQLCondition>> left = TreeTransformer.pushNotDownOrUp(node.left, revert);
        ArrayList<Set<GCQLCondition>> right = TreeTransformer.pushNotDownOrUp(node.right, revert);
        if (revert) {
            logger.trace("AndNode becomes Or");
            return TreeTransformer.concatenate(left, right);
        }
        logger.trace("AndNode remains And");
        return TreeTransformer.match(left, right);
    }

    private static ArrayList<Set<GCQLCondition>> pushNotDownOrUp(GCQLOrNode node, boolean revert) throws CQLUnsupportedException {
        ArrayList<Set<GCQLCondition>> left = TreeTransformer.pushNotDownOrUp(node.left, revert);
        ArrayList<Set<GCQLCondition>> right = TreeTransformer.pushNotDownOrUp(node.right, revert);
        if (revert) {
            logger.trace("OrNode becomes And");
            return TreeTransformer.match(left, right);
        }
        logger.trace("AndNode becomes Or");
        return TreeTransformer.concatenate(left, right);
    }

    private static ArrayList<Set<GCQLCondition>> pushNotDownOrUp(GCQLNotNode node, boolean revert) throws CQLUnsupportedException {
        ArrayList<Set<GCQLCondition>> left = TreeTransformer.pushNotDownOrUp(node.left, revert);
        ArrayList<Set<GCQLCondition>> right = TreeTransformer.pushNotDownOrUp(node.right, !revert);
        if (revert) {
            logger.trace("AndNotNode becomes Or");
            return TreeTransformer.concatenate(left, right);
        }
        logger.trace("AndNotNode remains AndNot");
        return TreeTransformer.match(left, right);
    }

    private static ArrayList<Set<GCQLCondition>> match(ArrayList<Set<GCQLCondition>> left, ArrayList<Set<GCQLCondition>> right) {
        ArrayList<Set<GCQLCondition>> result = new ArrayList<Set<GCQLCondition>>();
        for (Set<GCQLCondition> outer : left) {
            for (Set<GCQLCondition> inner : right) {
                HashSet<GCQLCondition> resultInner = new HashSet<GCQLCondition>();
                resultInner.addAll(TreeTransformer.cloneSet(outer));
                resultInner.addAll(TreeTransformer.cloneSet(inner));
                result.add(resultInner);
            }
        }
        return result;
    }

    private static Set<GCQLCondition> cloneSet(Set<GCQLCondition> input) {
        HashSet<GCQLCondition> result = new HashSet<GCQLCondition>(input.size());
        for (GCQLCondition each : input) {
            result.add((GCQLCondition)each.clone());
        }
        return result;
    }

    private static ArrayList<Set<GCQLCondition>> concatenate(ArrayList<Set<GCQLCondition>> left, ArrayList<Set<GCQLCondition>> right) {
        left.addAll(right);
        return left;
    }

    public static class GCQLCondition
    implements Cloneable {
        boolean not;
        GCQLTermNode term;

        GCQLCondition(GCQLTermNode term, boolean not) {
            this.term = term;
            this.not = not;
        }

        public GCQLTermNode getTerm() {
            return this.term;
        }

        public void setTerm(GCQLTermNode term) {
            this.term = term;
        }

        public boolean isNot() {
            return this.not;
        }

        public void setNot(boolean not) {
            this.not = not;
        }

        public Object clone() {
            return new GCQLCondition(GCQLCondition.cloneTerm(this.term), this.not);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.not ? 1231 : 1237);
            int code = this.term.getIndex().hashCode() + this.term.getTerm().hashCode() + this.term.getRelation().getBase().hashCode();
            result = 31 * result + (this.term == null ? 0 : code);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GCQLCondition other = (GCQLCondition)obj;
            if (other.not != this.not) {
                return false;
            }
            if (!this.term.getIndex().equals(other.term.getIndex())) {
                return false;
            }
            if (!this.term.getRelation().getBase().equals(other.term.getRelation().getBase())) {
                return false;
            }
            if (this.term.getRelation().getModifiers().size() != other.term.getRelation().getModifiers().size()) {
                return false;
            }
            int size = this.term.getRelation().getModifiers().size();
            for (int i = 0; i < size; ++i) {
                Modifier mod1 = (Modifier)this.term.getRelation().getModifiers().get(i);
                Modifier mod2 = (Modifier)other.term.getRelation().getModifiers().get(i);
                if (!mod1.getType().equals(mod2.getType())) {
                    return false;
                }
                if (mod1.getValue().equals(mod2.getValue())) continue;
                return false;
            }
            return true;
        }

        public static GCQLTermNode cloneTerm(GCQLTermNode term) {
            GCQLTermNode termNode = new GCQLTermNode();
            termNode.setIndex(term.getIndex());
            termNode.setTerm(term.getTerm());
            GCQLRelation newRelation = new GCQLRelation();
            newRelation.setBase(term.getRelation().getBase());
            for (Modifier mod : term.getRelation().getModifiers()) {
                Modifier newModifier = new Modifier(mod.getType(), mod.getComparison(), mod.getValue());
                newRelation.getModifiers().add(newModifier);
            }
            termNode.setRelation(newRelation);
            return termNode;
        }
    }
}

