/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.searchsystem.planning;

import gr.uoa.di.madgik.workflow.adaptor.search.searchsystemplan.PlanNode;
import java.util.ArrayList;
import java.util.Calendar;
import org.gcube.searchsystem.cache.PlanCache;
import org.gcube.searchsystem.cache.PlanCacheManager;
import org.gcube.searchsystem.environmentadaptor.EnvironmentAdaptor;
import org.gcube.searchsystem.planning.maxsubtree.MaxSubtreePlanner;
import org.gcube.searchsystem.planning.preprocessing.Preprocessor;
import org.gcube.searchsystem.workflow.WorkflowEngineAdaptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import search.library.util.cql.query.tree.GCQLNode;
import search.library.util.cql.query.tree.GCQLQueryTreeManager;

public class Orchestrator {
    private Logger logger = LoggerFactory.getLogger((String)Orchestrator.class.getName());
    private ArrayList<Preprocessor> preprocessors = new ArrayList();
    private ArrayList<String> priorities = new ArrayList();
    private ArrayList<String> warnings = new ArrayList();

    public String search(String cqlQuery, EnvironmentAdaptor environmentAdaptor, WorkflowEngineAdaptor workflowAdaptor, PlanCache pCache) throws Exception {
        try {
            this.logger.info("Received query: " + cqlQuery);
            if (PlanCacheManager.checkInitializationError()) {
                this.logger.warn(PlanCacheManager.getInitializationError());
                throw new Exception("Search could not complete due to cache plan cache manager initialization error " + PlanCacheManager.getInitializationError());
            }
            long before = Calendar.getInstance().getTimeInMillis();
            GCQLNode head = GCQLQueryTreeManager.parseGCQLString((String)cqlQuery);
            long after = Calendar.getInstance().getTimeInMillis();
            this.logger.info("parseGCQLString returned after: " + (after - before) + " millis");
            before = Calendar.getInstance().getTimeInMillis();
            PlanNode cachedPlan = pCache.searchForCachedPlans(cqlQuery, head);
            after = Calendar.getInstance().getTimeInMillis();
            this.logger.info("searchForCachedPlans returned after: " + (after - before) + " millis");
            Exception exceptionFromCached = null;
            if (cachedPlan != null) {
                this.logger.info("Found cached plans for query: " + cqlQuery + " ---------> " + cachedPlan.toString());
                try {
                    String rsEpr = this.execute(cachedPlan, workflowAdaptor);
                    return rsEpr;
                }
                catch (Exception e) {
                    this.logger.warn("Exception while executing cached plan. We will create a new plan and try to execute it", (Throwable)e);
                    exceptionFromCached = e;
                }
            }
            PlanNode newPlan = this.preprocessAndPlan(head, environmentAdaptor);
            before = Calendar.getInstance().getTimeInMillis();
            if (cachedPlan != null && newPlan.equals(cachedPlan)) {
                this.logger.info("newplan: " + newPlan.toString() + "---- is equal to the cached one: " + cachedPlan.toString());
                throw exceptionFromCached;
            }
            after = Calendar.getInstance().getTimeInMillis();
            this.logger.info("checking for plan equality returned after: " + (after - before) + " millis");
            before = Calendar.getInstance().getTimeInMillis();
            pCache.addPlan(cqlQuery, head, newPlan);
            after = Calendar.getInstance().getTimeInMillis();
            this.logger.info("adding plan to cache returned after: " + (after - before) + " millis");
            return this.execute(newPlan, workflowAdaptor);
        }
        catch (Exception e) {
            this.logger.error("Could not answer query, exception: ", (Throwable)e);
            throw e;
        }
    }

    private PlanNode preprocessAndPlan(GCQLNode head, EnvironmentAdaptor environmentAdaptor) throws Exception {
        long before = Calendar.getInstance().getTimeInMillis();
        for (Preprocessor preprocessor : this.preprocessors) {
            head = preprocessor.preprocess(head);
        }
        long after = Calendar.getInstance().getTimeInMillis();
        this.logger.info("preprocessing returned after: " + (after - before) + " millis");
        this.logger.info("After preprocessing: " + head.toCQL());
        before = Calendar.getInstance().getTimeInMillis();
        MaxSubtreePlanner planner = new MaxSubtreePlanner(this.priorities, environmentAdaptor);
        planner.getPriorities().add("default");
        PlanNode plan = planner.plan(head);
        after = Calendar.getInstance().getTimeInMillis();
        this.logger.info("planning returned after: " + (after - before) + " millis");
        if (plan == null) {
            throw new Exception("The infrastructure resources are not enough for answering this query. A query plan could not be created. ");
        }
        this.logger.info("After planning: " + plan.toString());
        this.warnings = planner.getWarnings();
        if (this.warnings.size() > 0) {
            this.logger.info("Planner finished with warnings: ");
            for (String warning : this.warnings) {
                this.logger.info("*** " + warning);
            }
        }
        return plan;
    }

    private String execute(PlanNode plan, WorkflowEngineAdaptor workflowAdaptor) throws Exception {
        this.logger.info("Starting execution stage");
        long before = Calendar.getInstance().getTimeInMillis();
        String rsEpr = workflowAdaptor.getExecutionResult(plan);
        long after = Calendar.getInstance().getTimeInMillis();
        this.logger.info("execution returned after: " + (after - before) + " millis");
        this.logger.info("Execution finished. ResultSet EPR output: " + rsEpr);
        return rsEpr;
    }

    public void setPreprocessors(ArrayList<Preprocessor> preprocessors) {
        this.preprocessors = preprocessors;
    }

    public ArrayList<Preprocessor> getPreprocessors() {
        return this.preprocessors;
    }

    public ArrayList<String> getPriorities() {
        return this.priorities;
    }

    public void setPriorities(ArrayList<String> priorities) {
        this.priorities = priorities;
    }

    public ArrayList<String> getWarnings() {
        return this.warnings;
    }
}

