/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.gcube.search.SearchDiscoverer;
import org.gcube.search.SearchServiceClientAPI;
import org.gcube.search.exceptions.SearchClientException;
import org.gcube.search.exceptions.SearchException;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchClient {
    private static final Logger logger = LoggerFactory.getLogger(SearchClient.class);
    private Gson gson;
    private String scope;
    private String endpoint;
    private Boolean inGcube = Boolean.FALSE;

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public Boolean getInGcube() {
        return this.inGcube;
    }

    public void setInGcube(Boolean inGcube) {
        this.inGcube = inGcube;
    }

    public SearchClient() {
        this.gson = new Gson();
    }

    public SearchClient(Boolean inGcube) {
        this();
        this.inGcube = inGcube;
    }

    public void initializeClient(String endpoint) {
        this.endpoint = endpoint;
    }

    public void randomClient() throws SearchClientException {
        Random random = new Random();
        List<String> searchServices = SearchDiscoverer.discoverSearchServices(this.scope);
        if (searchServices == null || searchServices.size() == 0) {
            throw new SearchClientException("No search endopoints found");
        }
        this.endpoint = searchServices.get(random.nextInt(searchServices.size()));
    }

    public String query(String query, Set<String> sids, Boolean names) throws SearchException {
        ResteasyClient client = null;
        ResteasyWebTarget target = null;
        SearchServiceClientAPI simple = null;
        try {
            client = new ResteasyClientBuilder().build();
            target = client.target(this.endpoint);
            simple = (SearchServiceClientAPI)target.proxy(SearchServiceClientAPI.class);
        }
        catch (Exception e) {
            logger.error("Client could not connect to endpoint : " + this.endpoint, (Throwable)e);
            throw new SearchException("Client could not connect to endpoint : " + this.endpoint, e);
        }
        Response response = null;
        String scope = this.inGcube != false ? this.scope : null;
        response = sids != null ? simple.searchSec(scope, query, false, false, names, sids) : simple.search(scope, query, false, false, names);
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            String error = (String)response.readEntity(String.class);
            response.close();
            logger.error("query error : " + error);
            throw new SearchException("query error : " + error);
        }
        String json = (String)response.readEntity(String.class);
        response.close();
        Map resp = (Map)this.gson.fromJson(json, new TypeToken<Map<String, String>>(){}.getType());
        return (String)resp.get("grslocator");
    }

    public List<Map<String, String>> queryAndRead(String query, Set<String> sids, Boolean names) throws SearchException {
        ResteasyClient client = null;
        ResteasyWebTarget target = null;
        SearchServiceClientAPI simple = null;
        try {
            client = new ResteasyClientBuilder().build();
            target = client.target(this.endpoint);
            simple = (SearchServiceClientAPI)target.proxy(SearchServiceClientAPI.class);
        }
        catch (Exception e) {
            throw new SearchException("Client could not connect to endpoint : " + this.endpoint, e);
        }
        Response response = null;
        String scope = this.inGcube != false ? this.scope : null;
        response = sids != null ? simple.searchSec(scope, query, true, false, names, sids) : simple.search(scope, query, true, false, names);
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            String error = (String)response.readEntity(String.class);
            response.close();
            logger.error("query error : " + error);
            throw new SearchException("query error : " + error);
        }
        String json = (String)response.readEntity(String.class);
        response.close();
        List resp = null;
        try {
            resp = (List)this.gson.fromJson(json, new TypeToken<List<Map<String, String>>>(){}.getType());
        }
        catch (Exception e) {
            logger.error("could not convert response to map object", (Throwable)e);
            throw new SearchException("could not convert response to map object", e);
        }
        finally {
            response.close();
        }
        return resp;
    }
}

