package org.gcube.search;

import static org.gcube.resources.discovery.icclient.ICFactory.clientFor;
import static org.gcube.resources.discovery.icclient.ICFactory.queryFor;

import java.util.ArrayList;
import java.util.List;

import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.GCoreEndpoint.Profile.Endpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchDiscoverer {
	public static final String ENDPOINT_KEY = "resteasy-servlet";
	public static final String SERVICE_CLASS = "Search";
	public static final String SERVICE_NAME = "SearchSystemService";
	
	private static final Logger logger = LoggerFactory.getLogger(SearchDiscoverer.class);

	public static List<String> discoverSearchServices(String scope){
		return discoverRunningInstances(SERVICE_NAME, SERVICE_CLASS, scope);
	}
	public static List<String> discoverRunningInstances(String serviceName, String serviceClass, String scope) {
		logger.info("Discovering : serviceName " + serviceName + " serviceClass, " + serviceClass + " scope : " + scope);

		List<String> endpoints = new ArrayList<String>();

		ScopeProvider.instance.set(scope);

		SimpleQuery query = queryFor(GCoreEndpoint.class);
		query.addCondition("$resource/Profile/ServiceClass/text() eq '" + serviceClass + "'")
				.addCondition("$resource/Profile/ServiceName/text() eq '" + serviceName + "'");

		DiscoveryClient<GCoreEndpoint> client = clientFor(GCoreEndpoint.class);
		List<GCoreEndpoint> resources = client.submit(query);

		for (GCoreEndpoint se : resources) {
			
			if (se != null && se.profile() != null && se.profile().endpointMap() != null){
				Endpoint endpoint = se.profile().endpointMap().get(ENDPOINT_KEY);
				if (endpoint != null && endpoint.uri() != null){
					endpoints.add(endpoint.uri().toString());
				}
			}
			
		}
		
		logger.info("endpoints found in discovering : " + endpoints);
		
		return endpoints;
	}
}
