/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.resultsetservice;

import java.net.URL;
import java.rmi.RemoteException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.axis.MessageContext;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.log4j.Logger;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.searchservice.resultsetservice.ResultSetQNames;
import org.gcube.common.searchservice.resultsetservice.ResultSetResource;
import org.gcube.common.searchservice.resultsetservice.ServiceContext;
import org.gcube.common.searchservice.resultsetservice.StatefulContext;
import org.gcube.common.searchservice.resultsetservice.WSResultSetHome;
import org.gcube.common.searchservice.resultsetservice.stubs.AccessResourceRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.AccessResourceResponse;
import org.gcube.common.searchservice.resultsetservice.stubs.AddResultsRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.AddTextRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.CanStreamResponse;
import org.gcube.common.searchservice.resultsetservice.stubs.ClearResponse;
import org.gcube.common.searchservice.resultsetservice.stubs.CreateResourceExtendedRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.CreateResourceRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.CreateResourceResponse;
import org.gcube.common.searchservice.resultsetservice.stubs.CreateSerializedResourceRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.CreateSerializedResourceResponse;
import org.gcube.common.searchservice.resultsetservice.stubs.DestroySessionResponse;
import org.gcube.common.searchservice.resultsetservice.stubs.EndAuthoringResponse;
import org.gcube.common.searchservice.resultsetservice.stubs.ExecuteQueryOnDocumentRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.ExecuteQueryOnHeadRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.ExecuteQueryOnResultsRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.ExecuteQueryOnResultsResponse;
import org.gcube.common.searchservice.resultsetservice.stubs.ExtendAccessLeasingRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.ExtendAccessLeasingResponse;
import org.gcube.common.searchservice.resultsetservice.stubs.ExtendTimeLeasingRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.ExtendTimeLeasingResponse;
import org.gcube.common.searchservice.resultsetservice.stubs.FilterRSPropRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.FilterRSRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.GetAllResultsResponse;
import org.gcube.common.searchservice.resultsetservice.stubs.GetFileContentRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.GetNextPartRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.GetNumberOfResultsRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.GetPropertiesRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.GetPropertiesResponse;
import org.gcube.common.searchservice.resultsetservice.stubs.GetResultRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.GetResultsRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.GetResultsResponse;
import org.gcube.common.searchservice.resultsetservice.stubs.KeepTopPropRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.KeepTopRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.SetForwardRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.SplitClearResponse;
import org.gcube.common.searchservice.resultsetservice.stubs.SplitEncodedResponse;
import org.gcube.common.searchservice.resultsetservice.stubs.StartNewPartResponse;
import org.gcube.common.searchservice.resultsetservice.stubs.TransformByXSLTRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.TransformRSPropRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.WrapLocalFileRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.WrapLocalFileResponse;
import org.gcube.common.searchservice.resultsetservice.stubs.WrapResourceRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.WrapResourceResponse;
import org.gcube.common.searchservice.searchlibrary.GarbageCollector.GarbageCollect;
import org.gcube.common.searchservice.searchlibrary.resultset.ResultSet;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.CreationParams;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.StreamManager;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.WSRSSessionToken;
import org.gcube.common.searchservice.searchlibrary.resultset.helpers.RSConstants;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.Topic;
import org.globus.wsrf.container.ServiceHost;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.impl.SimpleTopic;
import org.globus.wsrf.utils.AddressingUtils;
import sun.misc.BASE64Decoder;

public class ResultSetService
extends GCUBEPortType {
    private static Logger log = Logger.getLogger(ResultSetService.class);
    StreamManager sm = null;
    private WSResultSetHome resourceHome = null;
    private int port = -1;
    private boolean SSLsupport = true;
    private static SimpleTopic reclaimingEprs;

    public ResultSetService() {
        try {
            log.info((Object)"Initializing");
            if (this.sm == null) {
                this.port = this.getPort();
                this.SSLsupport = this.getSSLsupport();
                if (this.port > 0) {
                    this.sm = new StreamManager(this.port, this.SSLsupport);
                    this.sm.start();
                }
            }
            if (this.resourceHome == null) {
                this.resourceHome = new WSResultSetHome();
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not initialize Streammanager. FATAL ERROR", (Throwable)e);
        }
    }

    private int getPort() throws Exception {
        return (Integer)StatefulContext.getPortTypeContext().getProperty(StatefulContext.STREAM_PORT, new boolean[]{true});
    }

    private boolean getSSLsupport() throws Exception {
        String SSL = (String)StatefulContext.getPortTypeContext().getProperty(StatefulContext.SSLSUPPORT, new boolean[]{true});
        return SSL.equalsIgnoreCase("enabled");
    }

    public static void ready() {
        try {
            log.info((Object)"Start garbage collector");
            GCUBEStatefulPortTypeContext ptctx = StatefulContext.getPortTypeContext();
            GCUBEWSResource resource = null;
            for (GCUBEScope scope : ServiceContext.getContext().getInstance().getScopes().values()) {
                try {
                    ServiceContext.getContext().setScope(scope);
                    if (resource == null) {
                        resource = ptctx.getWSHome().create(new Object[]{new Boolean(true)});
                        log.trace((Object)("created reclaimed-RS-topic resource in scope: " + scope));
                        continue;
                    }
                    ptctx.getWSHome().create((GCUBEWSResourceKey)resource.getID(), new Object[0]);
                    log.trace((Object)("associated reclaimed-RS-topic resource with scope: " + scope));
                }
                catch (Exception e) {
                    log.error((Object)"Could not create the global resource for Garbage Collector. Throwing RemoteException", (Throwable)e);
                    throw new RemoteException("Could not create the global resource for Garbage Collector");
                }
            }
            try {
                reclaimingEprs = new SimpleTopic(new QName("http://gcube.org/namespaces/searchservice/ResultSetService", "ReclaimingRSEprs"));
                ServiceContext.getContext().getStartScopes()[0].getInfrastructure();
                GCUBEScope[] scopes = new GCUBEScope[ServiceContext.getContext().getInstance().getScopes().values().size()];
                log.info((Object)("Registering a new topic: " + reclaimingEprs.toString() + " to IS"));
                ISNotifier notifier = (ISNotifier)GHNContext.getImplementation(ISNotifier.class);
                ArrayList<SimpleTopic> list = new ArrayList<SimpleTopic>();
                list.add(reclaimingEprs);
                resource.getTopicList().addTopic((Topic)reclaimingEprs);
                notifier.registerISNotification(resource.getEPR(), list, (GCUBESecurityManager)ServiceContext.getContext(), ServiceContext.getContext().getInstance().getScopes().values().toArray(scopes));
            }
            catch (Exception e) {
                log.error((Object)("Could not register Topic: " + reclaimingEprs.toString()), (Throwable)e);
            }
            GarbageCollect gc = new GarbageCollect(reclaimingEprs);
            new Thread((Runnable)gc).start();
            log.info((Object)"Start garbage collector started");
        }
        catch (Exception e) {
            log.error((Object)"Could not start garbage collector.", (Throwable)e);
        }
    }

    private ResultSetResource getResource() throws Exception {
        Resource resource = null;
        this.handleScope();
        try {
            resource = ResourceContext.getResourceContext().getResource();
        }
        catch (Exception e) {
            log.error((Object)"could not retrieve ResultSet resource. Throwing Exception", (Throwable)e);
            throw new Exception("could not retrieve ResultSet resource");
        }
        ResultSetResource resultsetResource = (ResultSetResource)resource;
        return resultsetResource;
    }

    private ResultSet getResultSet(String rsID) throws Exception {
        ResultSet rs = null;
        this.handleScope();
        if (rsID == null || rsID.trim().length() == 0) {
            rs = this.getResource().getResultSet();
        } else if (rsID != null && rsID.trim().length() != 0) {
            rs = this.resourceHome.getResultSet(rsID);
        } else {
            log.error((Object)("unrecoglinzed session token or resource identifier " + rsID + ".Throwing Exception"));
            throw new Exception("unrecoglinzed session token or resource identifier " + rsID);
        }
        return rs;
    }

    public CreateResourceResponse createResource(CreateResourceRequest request) throws RemoteException {
        if (request.getResourceType().equalsIgnoreCase(RSConstants.RESOURCETYPE.WSRF.toString())) {
            GCUBEStatefulPortTypeContext ptctx = StatefulContext.getPortTypeContext();
            EndpointReferenceType epr = null;
            GCUBEWSResource resource = null;
            URL baseURL = null;
            log.info((Object)"No Scope was set. Creating Resoure in all scopes.");
            for (GCUBEScope scope : ServiceContext.getContext().getInstance().getScopes().values()) {
                try {
                    ServiceContext.getContext().setScope(scope);
                    if (resource == null) {
                        resource = ptctx.getWSHome().create(new Object[]{request.getProperties(), request.isDataFlow()});
                        continue;
                    }
                    ptctx.getWSHome().create((GCUBEWSResourceKey)resource.getID(), new Object[0]);
                }
                catch (Exception e) {
                    log.error((Object)"Could not create new resource. Throwing RemoteException", (Throwable)e);
                    throw new RemoteException("Could not create new resource");
                }
            }
            try {
                baseURL = ServiceHost.getBaseURL();
                String instanceService = (String)MessageContext.getCurrentContext().getService().getOption("instance");
                String instanceURI = baseURL.toString() + instanceService;
                epr = AddressingUtils.createEndpointReference((String)instanceURI, (ResourceKey)((ResourceKey)resource.getID()));
            }
            catch (Exception e) {
                log.error((Object)"Could not create EPR to new resource. Throwing RemoteException", (Throwable)e);
                throw new RemoteException("Could not create EPR to new resource");
            }
            try {
                ((ResultSetResource)ptctx.getWSHome().find((ResourceKey)resource.getID())).getResultSet().addWSEPR(ObjectSerializer.toString((Object)epr, (QName)ResultSetQNames.RESOURCE_REFERENCE));
            }
            catch (Exception e) {
                log.error((Object)"Could not create serialization of EPR to new resource. Throwing RemoteException", (Throwable)e);
                throw new RemoteException("Could not create serialization of EPR to new resource");
            }
            CreateResourceResponse response = new CreateResourceResponse();
            response.setEndpointReference(epr);
            response.setSessionToken("");
            response.setPort(this.port);
            response.setSSLsupport(this.SSLsupport);
            return response;
        }
        if (request.getResourceType().equalsIgnoreCase(RSConstants.RESOURCETYPE.WS.toString())) {
            try {
                ResultSet rs = new ResultSet(request.getProperties(), request.isDataFlow());
                URL baseURL = ServiceHost.getBaseURL();
                String instanceService = (String)MessageContext.getCurrentContext().getService().getOption("instance");
                String instanceURI = baseURL.toString() + instanceService;
                String token = WSRSSessionToken.generateSessionToken();
                WSRSSessionToken qtoken = new WSRSSessionToken(instanceURI, token);
                rs.addWSEPR(WSRSSessionToken.serialize((WSRSSessionToken)qtoken));
                CreateResourceResponse response = new CreateResourceResponse();
                response.setEndpointReference(new EndpointReferenceType());
                response.setSessionToken(WSRSSessionToken.serialize((WSRSSessionToken)qtoken));
                response.setPort(this.port);
                response.setSSLsupport(this.SSLsupport);
                this.resourceHome.addResultSet(qtoken.getSessionToken(), rs);
                return response;
            }
            catch (Exception e) {
                log.error((Object)"could not create resource. throeing exception", (Throwable)e);
                throw new RemoteException("could not create resource");
            }
        }
        return null;
    }

    public CreateResourceResponse createResourceExtended(CreateResourceExtendedRequest request) throws RemoteException {
        if (request.getResourceType().equalsIgnoreCase(RSConstants.RESOURCETYPE.WSRF.toString())) {
            GCUBEStatefulPortTypeContext ptctx = StatefulContext.getPortTypeContext();
            EndpointReferenceType epr = null;
            GCUBEWSResource resource = null;
            URL baseURL = null;
            log.trace((Object)"No Scope was set. Creating Resoure in all scopes.");
            for (GCUBEScope scope : ServiceContext.getContext().getInstance().getScopes().values()) {
                try {
                    ServiceContext.getContext().setScope(scope);
                    if (resource == null) {
                        resource = ptctx.getWSHome().create(new Object[]{request.getProperties(), request.isDataFlow(), request.getAccessReads(), request.isForward(), request.getExpire_date(), request.getPKey()});
                        continue;
                    }
                    ptctx.getWSHome().create((GCUBEWSResourceKey)resource.getID(), new Object[0]);
                }
                catch (Exception e) {
                    log.error((Object)"Could not create new resource. Throwing RemoteException", (Throwable)e);
                    throw new RemoteException("Could not create new resource");
                }
            }
            try {
                baseURL = ServiceHost.getBaseURL();
                String instanceService = (String)MessageContext.getCurrentContext().getService().getOption("instance");
                String instanceURI = baseURL.toString() + instanceService;
                epr = AddressingUtils.createEndpointReference((String)instanceURI, (ResourceKey)((ResourceKey)resource.getID()));
            }
            catch (Exception e) {
                log.error((Object)"Could not create EPR to new resource. Throwing RemoteException", (Throwable)e);
                throw new RemoteException("Could not create EPR to new resource");
            }
            try {
                ((ResultSetResource)ptctx.getWSHome().find((ResourceKey)resource.getID())).getResultSet().addWSEPR(ObjectSerializer.toString((Object)epr, (QName)ResultSetQNames.RESOURCE_REFERENCE));
            }
            catch (Exception e) {
                log.error((Object)"Could not create serialization of EPR to new resource. Throwing RemoteException", (Throwable)e);
                throw new RemoteException("Could not create serialization of EPR to new resource");
            }
            CreateResourceResponse response = new CreateResourceResponse();
            response.setEndpointReference(epr);
            response.setSessionToken("");
            response.setPort(this.port);
            response.setSSLsupport(this.SSLsupport);
            return response;
        }
        if (request.getResourceType().equalsIgnoreCase(RSConstants.RESOURCETYPE.WS.toString())) {
            try {
                CreationParams createParams = new CreationParams();
                createParams.properties = new ArrayList<String>(Arrays.asList(request.getProperties()));
                createParams.setDataflow(request.isDataFlow());
                createParams.setAccessReads(request.getAccessReads());
                createParams.setForward(request.isForward());
                Date expire_date = new Date(0L);
                expire_date.setTime(request.getExpire_date());
                createParams.setExpire_date(expire_date);
                if (request.getPKey() != null) {
                    byte[] rawkey = new BASE64Decoder().decodeBuffer(new String(request.getPKey()));
                    X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(rawkey);
                    KeyFactory kf = KeyFactory.getInstance("RSA");
                    RSAPublicKey pk = (RSAPublicKey)kf.generatePublic(publicKeySpec);
                    createParams.setPKey((PublicKey)pk);
                }
                ResultSet rs = new ResultSet(createParams);
                URL baseURL = ServiceHost.getBaseURL();
                String instanceService = (String)MessageContext.getCurrentContext().getService().getOption("instance");
                String instanceURI = baseURL.toString() + instanceService;
                String token = WSRSSessionToken.generateSessionToken();
                WSRSSessionToken qtoken = new WSRSSessionToken(instanceURI, token);
                rs.addWSEPR(WSRSSessionToken.serialize((WSRSSessionToken)qtoken));
                CreateResourceResponse response = new CreateResourceResponse();
                response.setEndpointReference(new EndpointReferenceType());
                response.setSessionToken(WSRSSessionToken.serialize((WSRSSessionToken)qtoken));
                response.setPort(this.port);
                response.setSSLsupport(this.SSLsupport);
                this.resourceHome.addResultSet(qtoken.getSessionToken(), rs);
                return response;
            }
            catch (Exception e) {
                log.error((Object)"could not create resource. throeing exception", (Throwable)e);
                throw new RemoteException("could not create resource");
            }
        }
        return null;
    }

    public CreateSerializedResourceResponse createSerializedResource(CreateSerializedResourceRequest request) throws RemoteException {
        if (request.getResourceType().equalsIgnoreCase(RSConstants.RESOURCETYPE.WSRF.toString())) {
            GCUBEStatefulPortTypeContext ptctx = StatefulContext.getPortTypeContext();
            EndpointReferenceType epr = null;
            GCUBEWSResource resource = null;
            URL baseURL = null;
            log.trace((Object)"No Scope was set. Creating Resoure in all scopes.");
            for (GCUBEScope scope : ServiceContext.getContext().getInstance().getScopes().values()) {
                try {
                    ServiceContext.getContext().setScope(scope);
                    if (resource == null) {
                        resource = ptctx.getWSHome().create(new Object[]{request.getProperties(), request.isDataFlow()});
                        continue;
                    }
                    ptctx.getWSHome().create((GCUBEWSResourceKey)resource.getID(), new Object[0]);
                }
                catch (Exception e) {
                    log.error((Object)"Could not create new resource. Throwing RemoteException", (Throwable)e);
                    throw new RemoteException("Could not create new resource");
                }
            }
            try {
                baseURL = ServiceHost.getBaseURL();
                String instanceService = (String)MessageContext.getCurrentContext().getService().getOption("instance");
                String instanceURI = baseURL.toString() + instanceService;
                epr = AddressingUtils.createEndpointReference((String)instanceURI, (ResourceKey)((ResourceKey)resource.getID()));
            }
            catch (Exception e) {
                log.error((Object)"Could not create EPR to new resource. Throwing RemoteException", (Throwable)e);
                throw new RemoteException("Could not create EPR to new resource");
            }
            try {
                ((ResultSetResource)ptctx.getWSHome().find((ResourceKey)resource.getID())).getResultSet().addWSEPR(ObjectSerializer.toString((Object)epr, (QName)ResultSetQNames.RESOURCE_REFERENCE));
            }
            catch (Exception e) {
                log.error((Object)"Could not create serialization of EPR to new resource. Throwing RemoteException", (Throwable)e);
                throw new RemoteException("Could not create serialization of EPR to new resource");
            }
            CreateSerializedResourceResponse response = new CreateSerializedResourceResponse();
            response.setEndpointReference(epr);
            response.setSessionToken("");
            response.setPort(this.port);
            response.setSSLsupport(this.SSLsupport);
            return response;
        }
        if (request.getResourceType().equalsIgnoreCase(RSConstants.RESOURCETYPE.WS.toString())) {
            try {
                ResultSet rs = new ResultSet(request.getProperties(), request.isDataFlow());
                URL baseURL = ServiceHost.getBaseURL();
                String instanceService = (String)MessageContext.getCurrentContext().getService().getOption("instance");
                String instanceURI = baseURL.toString() + instanceService;
                String token = WSRSSessionToken.generateSessionToken();
                WSRSSessionToken qtoken = new WSRSSessionToken(instanceURI, token);
                rs.addWSEPR(WSRSSessionToken.serialize((WSRSSessionToken)qtoken));
                CreateSerializedResourceResponse response = new CreateSerializedResourceResponse();
                response.setEndpointReference(new EndpointReferenceType());
                response.setSessionToken(WSRSSessionToken.serialize((WSRSSessionToken)qtoken));
                response.setPort(this.port);
                response.setSSLsupport(this.SSLsupport);
                this.resourceHome.addResultSet(qtoken.getSessionToken(), rs);
                return response;
            }
            catch (Exception e) {
                log.error((Object)"could not create resource. throwing exception", (Throwable)e);
                throw new RemoteException("could not create resource");
            }
        }
        return null;
    }

    public WrapResourceResponse wrapResource(WrapResourceRequest request) throws RemoteException {
        if (request.getResourceType().equalsIgnoreCase(RSConstants.RESOURCETYPE.WSRF.toString())) {
            GCUBEStatefulPortTypeContext ptctx = StatefulContext.getPortTypeContext();
            if (ptctx == null) {
                log.error((Object)"StatefulContext is null.");
                throw new RemoteException("StatefulContext is null.");
            }
            if (ptctx.getWSHome() == null) {
                log.error((Object)"ptctx.getWSHome() is null.");
                throw new RemoteException("ptctx.getWSHome() is null.");
            }
            log.debug((Object)("Head filename: " + request.getHeadFileName()));
            log.trace((Object)("key type QName: " + ptctx.getWSHome().getKeyTypeName()));
            EndpointReferenceType epr = null;
            GCUBEWSResource resource = null;
            URL baseURL = null;
            for (GCUBEScope scope : ServiceContext.getContext().getInstance().getScopes().values()) {
                log.trace((Object)("No scope was set. Creating resource in scope : " + scope.getName()));
                try {
                    ServiceContext.getContext().setScope(scope);
                    if (resource == null) {
                        log.trace((Object)"Create new resource");
                        if (request.getPrivateKey() == null) {
                            resource = ptctx.getWSHome().create(new Object[]{request.getHeadFileName()});
                            continue;
                        }
                        resource = ptctx.getWSHome().create(new Object[]{request.getHeadFileName(), request.getPrivateKey()});
                        continue;
                    }
                    log.trace((Object)"Reuse resource");
                    ptctx.getWSHome().create((GCUBEWSResourceKey)resource.getID(), new Object[0]);
                }
                catch (Exception e) {
                    log.error((Object)"Could not create new resource. Throwing RemoteException", (Throwable)e);
                    throw new RemoteException("Could not create new resource");
                }
            }
            try {
                baseURL = ServiceHost.getBaseURL();
                String instanceService = (String)MessageContext.getCurrentContext().getService().getOption("instance");
                String instanceURI = baseURL.toString() + instanceService;
                epr = AddressingUtils.createEndpointReference((String)instanceURI, (ResourceKey)((ResourceKey)resource.getID()));
            }
            catch (Exception e) {
                log.error((Object)"Could not create EPR to new resource. Throwing RemoteException", (Throwable)e);
                throw new RemoteException("Could not create EPR to new resource");
            }
            try {
                ((ResultSetResource)ptctx.getWSHome().find((ResourceKey)resource.getID())).getResultSet().addWSEPR(ObjectSerializer.toString((Object)epr, (QName)ResultSetQNames.RESOURCE_REFERENCE));
            }
            catch (Exception e) {
                log.error((Object)"Could not create serialization of EPR to new resource. Throwing RemoteException", (Throwable)e);
                throw new RemoteException("Could not create serialization of EPR to new resource");
            }
            WrapResourceResponse response = new WrapResourceResponse();
            response.setEndpointReference(epr);
            response.setSessionToken("");
            response.setPort(this.port);
            response.setSSLsupport(this.SSLsupport);
            return response;
        }
        if (request.getResourceType().equalsIgnoreCase(RSConstants.RESOURCETYPE.WS.toString())) {
            try {
                ResultSet rs = null;
                if (request.getPrivateKey() == null) {
                    rs = new ResultSet(request.getHeadFileName());
                } else {
                    byte[] rawkey = new BASE64Decoder().decodeBuffer(new String(request.getPrivateKey()));
                    X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(rawkey);
                    KeyFactory kf = KeyFactory.getInstance("RSA");
                    RSAPrivateKey pk = (RSAPrivateKey)kf.generatePrivate(publicKeySpec);
                    rs = new ResultSet(request.getHeadFileName(), (PrivateKey)pk);
                }
                URL baseURL = ServiceHost.getBaseURL();
                String instanceService = (String)MessageContext.getCurrentContext().getService().getOption("instance");
                String instanceURI = baseURL.toString() + instanceService;
                String token = WSRSSessionToken.generateSessionToken();
                WSRSSessionToken qtoken = new WSRSSessionToken(instanceURI, token);
                rs.addWSEPR(WSRSSessionToken.serialize((WSRSSessionToken)qtoken));
                WrapResourceResponse response = new WrapResourceResponse();
                response.setEndpointReference(new EndpointReferenceType());
                response.setSessionToken(WSRSSessionToken.serialize((WSRSSessionToken)qtoken));
                response.setPort(this.port);
                response.setSSLsupport(this.SSLsupport);
                this.resourceHome.addResultSet(qtoken.getSessionToken(), rs);
                return response;
            }
            catch (Exception e) {
                log.error((Object)"could not create resource. throeing exception", (Throwable)e);
                throw new RemoteException("could not create resource");
            }
        }
        return null;
    }

    public AccessResourceResponse accessResource(AccessResourceRequest request) throws RemoteException {
        if (request.getResourceType().equalsIgnoreCase(RSConstants.RESOURCETYPE.WSRF.toString())) {
            GCUBEStatefulPortTypeContext ptctx = StatefulContext.getPortTypeContext();
            EndpointReferenceType epr = null;
            GCUBEWSResource resource = null;
            URL baseURL = null;
            log.info((Object)"No Scope was set.");
            for (GCUBEScope scope : ServiceContext.getContext().getInstance().getScopes().values()) {
                try {
                    ServiceContext.getContext().setScope(scope);
                    if (resource == null) {
                        if (request.getPrivateKey() == null) {
                            resource = ptctx.getWSHome().create(new Object[]{this.getResource().getResultSet().getHeadName()});
                            continue;
                        }
                        resource = ptctx.getWSHome().create(new Object[]{this.getResource().getResultSet().getHeadName(), request.getPrivateKey()});
                        continue;
                    }
                    ptctx.getWSHome().create((GCUBEWSResourceKey)resource.getID(), new Object[0]);
                }
                catch (Exception e) {
                    log.error((Object)"Could not create new resource. Throwing RemoteException", (Throwable)e);
                    throw new RemoteException("Could not create new resource");
                }
            }
            try {
                baseURL = ServiceHost.getBaseURL();
                String instanceService = (String)MessageContext.getCurrentContext().getService().getOption("instance");
                String instanceURI = baseURL.toString() + instanceService;
                epr = AddressingUtils.createEndpointReference((String)instanceURI, (ResourceKey)((ResourceKey)resource.getID()));
            }
            catch (Exception e) {
                log.error((Object)"Could not create EPR to new resource. Throwing RemoteException", (Throwable)e);
                throw new RemoteException("Could not create EPR to new resource");
            }
            try {
                ((ResultSetResource)ptctx.getWSHome().find((ResourceKey)resource.getID())).getResultSet().addWSEPR(ObjectSerializer.toString((Object)epr, (QName)ResultSetQNames.RESOURCE_REFERENCE));
            }
            catch (Exception e) {
                log.error((Object)"Could not create serialization of EPR to new resource. Throwing RemoteException", (Throwable)e);
                throw new RemoteException("Could not create serialization of EPR to new resource");
            }
            AccessResourceResponse response = new AccessResourceResponse();
            response.setEndpointReference(epr);
            response.setSessionToken("");
            response.setPort(this.port);
            response.setSSLsupport(this.SSLsupport);
            return response;
        }
        if (request.getResourceType().equalsIgnoreCase(RSConstants.RESOURCETYPE.WS.toString())) {
            try {
                String headFileName = this.getResultSet(request.getSessionToken()).getHeadName();
                ResultSet rs = null;
                if (request.getPrivateKey() == null) {
                    rs = new ResultSet(headFileName);
                } else {
                    byte[] rawkey = new BASE64Decoder().decodeBuffer(new String(request.getPrivateKey()));
                    X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(rawkey);
                    KeyFactory kf = KeyFactory.getInstance("RSA");
                    RSAPrivateKey pk = (RSAPrivateKey)kf.generatePrivate(publicKeySpec);
                    rs = new ResultSet(headFileName, (PrivateKey)pk);
                }
                URL baseURL = ServiceHost.getBaseURL();
                String instanceService = (String)MessageContext.getCurrentContext().getService().getOption("instance");
                String instanceURI = baseURL.toString() + instanceService;
                String token = WSRSSessionToken.generateSessionToken();
                WSRSSessionToken qtoken = new WSRSSessionToken(instanceURI, token);
                rs.addWSEPR(WSRSSessionToken.serialize((WSRSSessionToken)qtoken));
                AccessResourceResponse response = new AccessResourceResponse();
                response.setEndpointReference(new EndpointReferenceType());
                response.setSessionToken(WSRSSessionToken.serialize((WSRSSessionToken)qtoken));
                response.setPort(this.port);
                response.setSSLsupport(this.SSLsupport);
                this.resourceHome.addResultSet(qtoken.getSessionToken(), rs);
                return response;
            }
            catch (Exception e) {
                log.error((Object)"could not create resource. throeing exception", (Throwable)e);
                throw new RemoteException("could not create resource");
            }
        }
        return null;
    }

    public StartNewPartResponse startNewPart(String sessionToken) throws RemoteException {
        this.handleScope();
        try {
            this.getResultSet(sessionToken).startNewPart();
            return new StartNewPartResponse();
        }
        catch (Exception e) {
            log.error((Object)"Could not create new part. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not create new part");
        }
    }

    public ClearResponse clear(String sessionToken) throws RemoteException {
        this.handleScope();
        try {
            this.getResultSet(sessionToken).clear();
            return new ClearResponse();
        }
        catch (Exception e) {
            log.error((Object)"Could not clear underlying structures. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not clear underlying structures");
        }
    }

    public EndAuthoringResponse endAuthoring(String sessionToken) throws RemoteException {
        this.handleScope();
        try {
            this.getResultSet(sessionToken).endAuthoring();
            return new EndAuthoringResponse();
        }
        catch (Exception e) {
            log.error((Object)"Could not end authoring. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not end authoring");
        }
    }

    public boolean addResults(AddResultsRequest params) throws RemoteException {
        this.handleScope();
        try {
            if (params.getResults() == null) {
                return true;
            }
            if (params.getResults().length == 0) {
                return true;
            }
            return this.getResultSet(params.getSessionToken()).addResults(params.getResults());
        }
        catch (Exception e) {
            log.error((Object)"Could not add results. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not add results");
        }
    }

    public boolean addText(AddTextRequest params) throws RemoteException {
        this.handleScope();
        try {
            if (params.getResults() == null) {
                return true;
            }
            if (params.getResults().length == 0) {
                return true;
            }
            return this.getResultSet(params.getSessionToken()).addText(params.getResults());
        }
        catch (Exception e) {
            log.error((Object)"Could not add text. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not add text");
        }
    }

    public WrapLocalFileResponse wrapLocalFile(WrapLocalFileRequest params) throws RemoteException {
        this.handleScope();
        try {
            this.getResultSet(params.getSessionToken()).wrapFile(params.getFilename());
            return new WrapLocalFileResponse();
        }
        catch (Exception e) {
            log.error((Object)"Could not wrap local file. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not wrap local file");
        }
    }

    public String getHeadFileName(String sessionToken) throws RemoteException {
        this.handleScope();
        try {
            return this.getResultSet(sessionToken).getHeadName();
        }
        catch (Exception e) {
            log.error((Object)"Could not get head file name. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not get head file name");
        }
    }

    public String getCurrentContentPartName(String sessionToken) throws RemoteException {
        this.handleScope();
        try {
            return this.getResultSet(sessionToken).getCurrentContentPartName();
        }
        catch (Exception e) {
            log.error((Object)"Could not get current content part name. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not get current content part name");
        }
    }

    public String getCurrentContentPartPayload(String sessionToken) throws RemoteException {
        this.handleScope();
        try {
            return this.getResultSet(sessionToken).getCurrentContentPartPayload();
        }
        catch (Exception e) {
            log.error((Object)"Could not get current content part payload. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not get current content part payload");
        }
    }

    public GetPropertiesResponse getProperties(GetPropertiesRequest params) throws RemoteException {
        this.handleScope();
        try {
            String[] props = this.getResultSet(params.getSessionToken()).getProperties(params.getType());
            if (props == null) {
                return new GetPropertiesResponse(new String[0]);
            }
            return new GetPropertiesResponse(props);
        }
        catch (Exception e) {
            log.error((Object)("Could not get properties for type" + params.getType() + ". Throwing RemoteException"), (Throwable)e);
            throw new RemoteException("Could not get properties for type" + params.getType());
        }
    }

    public boolean getNextPart(GetNextPartRequest params) throws RemoteException {
        this.handleScope();
        try {
            return this.getResultSet(params.getSessionToken()).getNextPart(params.getMaxWaitTime());
        }
        catch (Exception e) {
            log.error((Object)"Could not get next part. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not get next part");
        }
    }

    public boolean nextAvailable(String sessionToken) throws RemoteException {
        this.handleScope();
        try {
            return this.getResultSet(sessionToken).nextAvailable();
        }
        catch (Exception e) {
            log.error((Object)"Could not check if next part is available. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not check if next part is available");
        }
    }

    public boolean getPreviousPart(String sessionToken) throws RemoteException {
        this.handleScope();
        try {
            return this.getResultSet(sessionToken).getPreviousPart();
        }
        catch (Exception e) {
            log.error((Object)"Could not get previous part. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not get previous part");
        }
    }

    public boolean getFirstPart(String sessionToken) throws RemoteException {
        this.handleScope();
        try {
            return this.getResultSet(sessionToken).getFirstPart();
        }
        catch (Exception e) {
            log.error((Object)"Could not get head part. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not get head part");
        }
    }

    public boolean isFirst(String sessionToken) throws RemoteException {
        this.handleScope();
        try {
            return this.getResultSet(sessionToken).isFirst();
        }
        catch (Exception e) {
            log.error((Object)"Could not check if is First. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not check if is First");
        }
    }

    public boolean isLast(String sessionToken) throws RemoteException {
        this.handleScope();
        try {
            return this.getResultSet(sessionToken).isLast();
        }
        catch (Exception e) {
            log.error((Object)"Could not check if is last. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not check if is last");
        }
    }

    public int getNumberOfResults(GetNumberOfResultsRequest params) throws RemoteException {
        this.handleScope();
        try {
            return this.getResultSet(params.getSessionToken()).getNumberOfResults(params.getType());
        }
        catch (Exception e) {
            log.error((Object)"Could not get number of results. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not get number of results");
        }
    }

    public String getResult(GetResultRequest params) throws RemoteException {
        this.handleScope();
        try {
            return this.getResultSet(params.getSessionToken()).getResult(params.getIndex());
        }
        catch (Exception e) {
            log.warn((Object)"Could not get result. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not get result");
        }
    }

    public GetAllResultsResponse getAllResults(String sessionToken) throws RemoteException {
        this.handleScope();
        try {
            String[] res = this.getResultSet(sessionToken).getResults();
            if (res == null) {
                return new GetAllResultsResponse(new String[0]);
            }
            return new GetAllResultsResponse(res);
        }
        catch (Exception e) {
            log.error((Object)"Could not get records. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not get records");
        }
    }

    public GetResultsResponse getResults(GetResultsRequest params) throws RemoteException {
        this.handleScope();
        try {
            String[] res = this.getResultSet(params.getSessionToken()).getResults(params.getFrom(), params.getTo());
            if (res == null) {
                return new GetResultsResponse(new String[0]);
            }
            return new GetResultsResponse(res);
        }
        catch (Exception e) {
            log.error((Object)"Could not get records. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not get records");
        }
    }

    public String getHostIP(String sessionToken) throws RemoteException {
        this.handleScope();
        try {
            return this.getResultSet(sessionToken).getHostIP();
        }
        catch (Exception e) {
            log.error((Object)"Could not get host IP. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not get host IP");
        }
    }

    public String getHostName(String sessionToken) throws RemoteException {
        this.handleScope();
        try {
            return this.getResultSet(sessionToken).getHostName();
        }
        catch (Exception e) {
            log.error((Object)"Could not get host Name. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not get host Name");
        }
    }

    public SplitEncodedResponse splitEncoded(String sessionToken) throws RemoteException {
        this.handleScope();
        try {
            return new SplitEncodedResponse(this.getResultSet(sessionToken).splitEncoded());
        }
        catch (Exception e) {
            log.error((Object)"Could not split encoded content. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not split encoded content");
        }
    }

    public SplitClearResponse splitClear(String sessionToken) throws RemoteException {
        this.handleScope();
        try {
            return new SplitClearResponse(this.getResultSet(sessionToken).splitClear());
        }
        catch (Exception e) {
            log.error((Object)"Could not split clear content. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not split clear content");
        }
    }

    public String getFileContent(GetFileContentRequest params) throws RemoteException {
        this.handleScope();
        try {
            return this.getResultSet(params.getSessionToken()).getFileContent(params.getFilename());
        }
        catch (Exception e) {
            log.error((Object)"Could not retrieve file content. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not retrieve file content");
        }
    }

    public String retrieveCustomProperties(String sessionToken) throws RemoteException {
        this.handleScope();
        try {
            return this.getResultSet(sessionToken).retrieveCustomProperties();
        }
        catch (Exception e) {
            log.error((Object)"Could not retrieve Custom Properties. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not retrieve Custom Properties");
        }
    }

    public String keepTop(KeepTopRequest params) throws RemoteException {
        this.handleScope();
        try {
            return this.getResultSet(params.getSessionToken()).keepTop(params.getCount(), params.getType());
        }
        catch (Exception e) {
            log.error((Object)"Could not perform keep top service side. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not perform keep top service side");
        }
    }

    public String keepTopProp(KeepTopPropRequest params) throws RemoteException {
        this.handleScope();
        try {
            return this.getResultSet(params.getSessionToken()).keepTop(params.getProperties(), params.getCount(), params.getType());
        }
        catch (Exception e) {
            log.error((Object)"Could not perform keep top service side. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not perform keep top service side");
        }
    }

    public String executeQueryOnHead(ExecuteQueryOnHeadRequest params) throws RemoteException {
        this.handleScope();
        try {
            return this.getResultSet(params.getSessionToken()).executeQueryOnHead(params.getXPath());
        }
        catch (Exception e) {
            log.error((Object)"Could not execute query on Head. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not execute query on Head");
        }
    }

    public String executeQueryOnDocument(ExecuteQueryOnDocumentRequest params) throws RemoteException {
        this.handleScope();
        try {
            return this.getResultSet(params.getSessionToken()).executeQueryOnDocument(params.getXPath());
        }
        catch (Exception e) {
            log.error((Object)"Could not execute query on document. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not execute query on document");
        }
    }

    public ExecuteQueryOnResultsResponse executeQueryOnResults(ExecuteQueryOnResultsRequest params) throws RemoteException {
        this.handleScope();
        try {
            String[] res = this.getResultSet(params.getSessionToken()).executeQueryOnResults(params.getXPath());
            if (res == null) {
                return new ExecuteQueryOnResultsResponse(new String[0]);
            }
            return new ExecuteQueryOnResultsResponse(res);
        }
        catch (Exception e) {
            log.error((Object)"Could not execute query on document. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not execute query on document");
        }
    }

    public String cloneRS(String sessionToken) throws RemoteException {
        this.handleScope();
        try {
            return this.getResultSet(sessionToken).cloneRS();
        }
        catch (Exception e) {
            log.error((Object)"Could not clone the rs service side. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not clone the rs service side");
        }
    }

    public String filterRS(FilterRSRequest params) throws RemoteException {
        this.handleScope();
        try {
            return this.getResultSet(params.getSessionToken()).filterRS(params.getXpath());
        }
        catch (Exception e) {
            log.error((Object)"Could not perform filter by xpath service side. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not perform filter by xpath service side");
        }
    }

    public String filterRSProp(FilterRSPropRequest params) throws RemoteException {
        this.handleScope();
        try {
            return this.getResultSet(params.getSessionToken()).filterRS(params.getXpath(), params.getProperties());
        }
        catch (Exception e) {
            log.error((Object)"Could not perform filter by xpath service side. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not perform filter by xpath service side");
        }
    }

    public String transformByXSLT(TransformByXSLTRequest params) throws RemoteException {
        this.handleScope();
        try {
            return this.getResultSet(params.getSessionToken()).transformByXSLT(params.getTransformation());
        }
        catch (Exception e) {
            log.error((Object)"Could not perfom transformation. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not perfom transformation");
        }
    }

    public String transformRS(TransformByXSLTRequest params) throws RemoteException {
        this.handleScope();
        try {
            return this.getResultSet(params.getSessionToken()).transformRS(params.getTransformation());
        }
        catch (Exception e) {
            log.error((Object)"Could not perform transform by xslt service side. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not perform transform by xslt service side");
        }
    }

    public String transformRSProp(TransformRSPropRequest params) throws RemoteException {
        this.handleScope();
        try {
            return this.getResultSet(params.getSessionToken()).transformRS(params.getXslt(), params.getProperties());
        }
        catch (Exception e) {
            log.error((Object)"Could not perform transform by xslt service side. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not perform transform by xslt service side");
        }
    }

    public boolean isFlowControled(String sessionToken) throws RemoteException {
        this.handleScope();
        try {
            return this.getResultSet(sessionToken).getRSRef().isDataFlow();
        }
        catch (Exception e) {
            log.error((Object)"Could check if RS is flow controled. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could check if RS is flow controled");
        }
    }

    public boolean canAttach(String sessionToken) throws RemoteException {
        this.handleScope();
        try {
            return false;
        }
        catch (Exception e) {
            log.error((Object)"could not attach. returning false", (Throwable)e);
            return false;
        }
    }

    public CanStreamResponse canStream(String sessionToken) throws RemoteException {
        this.handleScope();
        try {
            CanStreamResponse response = new CanStreamResponse();
            response.setPort(this.port);
            response.setSSLsupport(this.SSLsupport);
            return response;
        }
        catch (Exception e) {
            log.error((Object)"could not find port to connecto to. returning negative", (Throwable)e);
            return null;
        }
    }

    public DestroySessionResponse destroySession(String sessionToken) throws RemoteException {
        this.handleScope();
        try {
            this.resourceHome.remove(sessionToken);
            return new DestroySessionResponse();
        }
        catch (Exception e) {
            log.error((Object)("could not remove session " + sessionToken), (Throwable)e);
            throw new RemoteException("could not remove session " + sessionToken);
        }
    }

    public boolean removePreviousPart(String sessionToken) throws RemoteException {
        this.handleScope();
        try {
            return this.getResultSet(sessionToken).removePreviousPart();
        }
        catch (Exception e) {
            log.error((Object)"Could not remove previous part. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not remove previous part");
        }
    }

    public boolean disableAccessLeasing(String sessionToken) throws RemoteException {
        this.handleScope();
        try {
            this.getResultSet(sessionToken).disableAccessLeasing();
            return true;
        }
        catch (Exception e) {
            log.error((Object)"Could not disable access leasing. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not disable access leasing");
        }
    }

    public ExtendAccessLeasingResponse extendAccessLeasing(ExtendAccessLeasingRequest request) throws RemoteException {
        this.handleScope();
        try {
            this.getResultSet(request.getSessionToken()).extendAccessLeasing(request.getAccessExtend());
            return new ExtendAccessLeasingResponse();
        }
        catch (Exception e) {
            log.error((Object)"Could not extend access leasing. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not extend access leasing");
        }
    }

    public int getAccessLeasing(String sessionToken) throws RemoteException {
        this.handleScope();
        try {
            return this.getResultSet(sessionToken).getAccessLeasing();
        }
        catch (Exception e) {
            log.error((Object)"Could not get access leasing. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not get access leasing");
        }
    }

    public boolean isForward(String sessionToken) throws RemoteException {
        this.handleScope();
        try {
            return this.getResultSet(sessionToken).isForward();
        }
        catch (Exception e) {
            log.error((Object)"Could not check if is Forward. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not check if is Forward");
        }
    }

    public boolean setForward(SetForwardRequest request) throws RemoteException {
        this.handleScope();
        try {
            return this.getResultSet(request.getSessionToken()).setForward(request.isForward());
        }
        catch (Exception e) {
            log.error((Object)"Could not set Forward. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not set Forward");
        }
    }

    public boolean disableTimeLeasing(String sessionToken) throws RemoteException {
        this.handleScope();
        try {
            this.getResultSet(sessionToken).disableTimeLeasing();
            return true;
        }
        catch (Exception e) {
            log.error((Object)"Could not disable time leasing. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not disable time leasing");
        }
    }

    public ExtendTimeLeasingResponse extendTimeLeasing(ExtendTimeLeasingRequest request) throws RemoteException {
        this.handleScope();
        try {
            Date newDate = new Date();
            newDate.setTime(request.getTimeExtend());
            this.getResultSet(request.getSessionToken()).extendTimeLeasing(newDate);
            return new ExtendTimeLeasingResponse();
        }
        catch (Exception e) {
            log.error((Object)"Could not extend time leasing. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not extend time leasing");
        }
    }

    public long getTimeLeasing(String sessionToken) throws RemoteException {
        this.handleScope();
        try {
            return this.getResultSet(sessionToken).getTimeLeasing().getTime();
        }
        catch (Exception e) {
            log.error((Object)"Could not get access leasing. Throwing RemoteException", (Throwable)e);
            throw new RemoteException("Could not get access leasing");
        }
    }

    protected synchronized void handleScope() {
        if (ServiceContext.getContext().getScope() == null) {
            if (ServiceContext.getContext().getInstance().getScopes().get(0) == null) {
                log.info((Object)"Scope is null: (ServiceContext.getContext().getInstance().getScopes().get(0) == null). Probably, the service has not reached ready state.");
            } else {
                log.info((Object)("Scope set to: " + ((GCUBEScope)ServiceContext.getContext().getInstance().getScopes().get(0)).getName()));
                ServiceContext.getContext().setScope((GCUBEScope)ServiceContext.getContext().getInstance().getScopes().get(0));
            }
        }
    }

    protected GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }
}

