/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.GarbageCollector;

import java.io.File;
import java.util.Calendar;
import org.apache.log4j.Logger;
import org.gcube.common.searchservice.searchlibrary.GarbageCollector.GCProperties;

public class GCPolicy {
    private static Logger log = Logger.getLogger(GCPolicy.class);
    private static final short TRUE = 0;
    private static final short FALSE = 1;
    private static final short UNDEF = 2;
    private static final long defaultTime = 3600000L;

    public static boolean reclaim(GCProperties props) {
        long now = Calendar.getInstance().getTimeInMillis();
        short lsPolicy = GCPolicy.lifeSpanPolicy(now, props);
        short ssPolicy = GCPolicy.ssPolicy(props);
        short defPolicy = GCPolicy.defaultPolicy(now, props);
        log.debug((Object)("lsPolicy: " + lsPolicy + " ssPolicy: " + ssPolicy + " defPolicy: " + defPolicy));
        log.debug((Object)("last access : " + props.getLastAccessed()));
        return GCPolicy.prioritize(lsPolicy, ssPolicy, defPolicy) == 0;
    }

    private static short prioritize(short lifespanPolicy, short ssPolicy, short defaultPolicy) {
        if (ssPolicy != 2) {
            return ssPolicy;
        }
        if (lifespanPolicy != 2) {
            return lifespanPolicy;
        }
        return defaultPolicy;
    }

    public static boolean reclaim(File file) {
        return file.lastModified() + 3600000L < Calendar.getInstance().getTimeInMillis();
    }

    private static short lifeSpanPolicy(long now, GCProperties props) {
        long timeSinceAccess = now - props.getLastAccessed();
        long timeSinceAuthor = now - props.getLastAuthored();
        long lifeSpan = props.getMaxLifeSpan();
        if (lifeSpan == 0L) {
            return 2;
        }
        if (timeSinceAccess > lifeSpan && timeSinceAuthor > lifeSpan) {
            return 0;
        }
        return 1;
    }

    private static short ssPolicy(GCProperties props) {
        return 2;
    }

    private static short defaultPolicy(long now, GCProperties props) {
        long timeSinceAccess = now - props.getLastAccessed();
        long timeSinceAuthor = now - props.getLastAuthored();
        if (timeSinceAccess > 3600000L && timeSinceAuthor > 3600000L) {
            return 0;
        }
        return 1;
    }
}

