/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.rsreader;

import org.apache.log4j.Logger;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.KeepTopThreadGeneric;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementBase;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.InitReaderThread;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.MakeLocalThreadGeneric;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocationWrapper;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceLocalType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceWSRFType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceWSType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.ReaderInitParams;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSFullWriter;

public class RSReader {
    private static Logger log = Logger.getLogger(RSReader.class);
    private RSLocationWrapper rs = null;

    public static RSReader getRSReader(RSLocator locator) throws Exception {
        try {
            return new RSReader(new RSLocationWrapper(locator));
        }
        catch (Exception e) {
            log.error((Object)"Could not create RSReader Throwing Exception", (Throwable)e);
            throw new Exception("Could not create RSReader");
        }
    }

    public static RSReader[] getRSReader(ReaderInitParams[] params) {
        int i;
        InitReaderThread[] ts = new InitReaderThread[params.length];
        RSReader[] rs = new RSReader[params.length];
        for (i = 0; i < params.length; ++i) {
            ts[i] = new InitReaderThread(params[i], InitReaderThread.RSReaderEnum.Reader);
            ts[i].start();
        }
        for (i = 0; i < params.length; ++i) {
            try {
                ts[i].join();
                rs[i] = (RSReader)ts[i].getReader();
                continue;
            }
            catch (Exception e) {
                log.error((Object)"interrupted whil waiting for reader. setting to null");
                rs[i] = null;
            }
        }
        return rs;
    }

    protected RSReader(RSLocationWrapper rs) {
        this.rs = rs;
    }

    public RSLocator getRSLocator() throws Exception {
        RSLocator locator = this.rs.getRSLocator();
        if (locator == null) {
            log.error((Object)"loctor is null. THrowin Exception");
            throw new Exception("loctor is null. THrowin Exception");
        }
        return locator;
    }

    public boolean isFlowControled() throws Exception {
        return this.rs.isFlowContoled();
    }

    public RSLocator wrap(RSResourceType type) throws Exception {
        if (!(type instanceof RSResourceWSRFType) && !(type instanceof RSResourceWSType)) {
            log.error((Object)"Cannot wrap to a local Resource. Throwin Exception");
            throw new Exception("Cannot wrap to a local Resource");
        }
        try {
            return this.rs.wrap(type);
        }
        catch (Exception e) {
            log.error((Object)"Cannot wrap to a local Resource. Throwin Exception", (Throwable)e);
            throw new Exception("Cannot wrap to a local Resource");
        }
    }

    public PropertyElementBase[] getProperties(Class template, String type) throws Exception {
        String[] props = null;
        try {
            props = this.rs.getProperties(type);
            if (props == null) {
                return new PropertyElementBase[0];
            }
            PropertyElementBase[] ret = new PropertyElementBase[props.length];
            for (int i = 0; i < props.length; ++i) {
                try {
                    PropertyElementBase tmp = (PropertyElementBase)template.newInstance();
                    tmp.fromXML(props[i]);
                    ret[i] = tmp;
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)"Could not instnatiate property element from xml. Adding null and continuing", (Throwable)e);
                }
            }
            return ret;
        }
        catch (Exception e) {
            log.error((Object)"Could not retrieve properties.Throwing Exception", (Throwable)e);
            throw new Exception("Could not retrieve properties");
        }
    }

    public void clear() throws Exception {
        try {
            this.rs.clear();
        }
        catch (Exception e) {
            log.error((Object)"Could not clear underlying structures.Throwing Exception", (Throwable)e);
            throw new Exception("Could not clear underlying structures");
        }
    }

    public boolean getNextPart() throws Exception {
        try {
            return this.rs.getNextPart(-1);
        }
        catch (Exception e) {
            log.error((Object)"Could not move to next part.Throwing Exception", (Throwable)e);
            throw new Exception("Could not move to next part");
        }
    }

    public boolean nextAvailable() throws Exception {
        try {
            return this.rs.nextAvailable();
        }
        catch (Exception e) {
            log.error((Object)"Could not check if next part is available.Throwing Exception", (Throwable)e);
            throw new Exception("Could not check if next part is available");
        }
    }

    public boolean getNextPart(int waitMax) throws Exception {
        try {
            return this.rs.getNextPart(waitMax);
        }
        catch (Exception e) {
            log.error((Object)"Could not move to next part.Throwing Exception", (Throwable)e);
            throw new Exception("Could not move to next part");
        }
    }

    public boolean getPreviousPart() throws Exception {
        try {
            return this.rs.getPreviousPart();
        }
        catch (Exception e) {
            log.error((Object)"Could not move to previous part.Throwing Exception", (Throwable)e);
            throw new Exception("Could not move to previous part");
        }
    }

    public boolean getFirstPart() throws Exception {
        try {
            return this.rs.getFirstPart();
        }
        catch (Exception e) {
            log.error((Object)"Could not move to head part.Throwing Exception", (Throwable)e);
            throw new Exception("Could not move to head part");
        }
    }

    public boolean isFirst() throws Exception {
        try {
            return this.rs.isFirst();
        }
        catch (Exception e) {
            log.error((Object)"Could not check if is First.Throwing Exception", (Throwable)e);
            throw new Exception("Could not check if is First");
        }
    }

    public boolean isLast() throws Exception {
        try {
            return this.rs.isLast();
        }
        catch (Exception e) {
            log.error((Object)"Could not check if is last.Throwing Exception", (Throwable)e);
            throw new Exception("Could not check if is last");
        }
    }

    public boolean isLocal() throws Exception {
        try {
            return this.rs.isLocal();
        }
        catch (Exception e) {
            log.error((Object)"Could not check if is local. Throwing Exception", (Throwable)e);
            throw new Exception("Could not check if is local");
        }
    }

    public String retrieveCustomProperties() throws Exception {
        try {
            return this.rs.retrieveCustomProperties();
        }
        catch (Exception e) {
            log.error((Object)"Could not retrieve Custom Properties. Throwing Exception", (Throwable)e);
            throw new Exception("Could not retrieve Custom Properties");
        }
    }

    public RSLocationWrapper getLocationIndependent() {
        return this.rs;
    }

    public RSReader makeLocal(RSResourceType type) throws Exception {
        try {
            if (!(!this.isLocal() || this.rs.isForward() || this.rs.hasAccessLeasing() || this.rs.hasTimeLeasing() || this.rs.isSecure())) {
                log.trace((Object)"RS to make local is an oldstyle actualy local RS.");
                if (this.rs.getRSLocator().getRSResourceType() instanceof RSResourceLocalType) {
                    log.trace((Object)"RS to make local with local request.");
                    return RSReader.getRSReader(this.rs.getRSLocator());
                }
                if (this.rs.getRSLocator().getRSResourceType() instanceof RSResourceWSRFType) {
                    log.trace((Object)"RS to make local with remote request.");
                    return RSReader.getRSReader(new RSLocator(new RSResourceLocalType(), this.rs.getHeadFileName()));
                }
                log.error((Object)"RSResource type not recognized. Throwing Exception");
                throw new Exception("RSResource type not recognized");
            }
            log.trace((Object)"Makelocal called for a rely remote RS");
            RSReader thisReader = RSReader.getRSReader(this.getRSLocator());
            if (this.getRSLocator().getPrivKey() != null) {
                log.info((Object)"Reader locator har private key");
            }
            String properties = thisReader.retrieveCustomProperties();
            RSFullWriter writer = RSFullWriter.getRSFullWriter(properties);
            if (!(type instanceof RSResourceLocalType) && !(type instanceof RSResourceWSRFType)) {
                log.error((Object)"not regognized resource type.Throwing Exception");
                throw new Exception("not regognized resource type.Throwing Exception");
            }
            MakeLocalThreadGeneric worker = new MakeLocalThreadGeneric(writer, thisReader, MakeLocalThreadGeneric.ENCODED, this.rs.getStaticPort(), this.rs.getSSLsupport());
            worker.start();
            return RSReader.getRSReader(writer.getRSLocator(type));
        }
        catch (Exception e) {
            log.error((Object)"Could not make local. Throwing Exception", (Throwable)e);
            throw new Exception("Could not make local");
        }
    }

    public RSReader makeLocal(RSResourceType type, int count) throws Exception {
        if (count < 0) {
            log.error((Object)"invalid topCount argument. Throwing Exception");
            throw new Exception("invalid topCount argument");
        }
        try {
            return this.keepTop(count).makeLocal(type);
        }
        catch (Exception e) {
            log.error((Object)"could not perform partial localization. Throwing Exception", (Throwable)e);
            throw new Exception("could not perform partial localization");
        }
    }

    public RSReader keepTop(int count, PropertyElementBase[] properties) throws Exception {
        try {
            if (properties == null || properties.length == 0) {
                log.error((Object)"Cannot initialize Result Set with empty property list. Throwing Exception");
                throw new Exception("Cannot initialize Result Set with empty property list");
            }
            String[] props = new String[properties.length];
            for (int i = 0; i < properties.length; ++i) {
                props[i] = properties[i].RS_toXML();
            }
            String headName = this.rs.keepTop(count, props, KeepTopThreadGeneric.PERPART);
            RSLocator newLocator = null;
            newLocator = this.getRSLocator().getRSResourceType() instanceof RSResourceLocalType ? new RSLocator(new RSResourceLocalType(), headName) : this.rs.wrap(new RSResourceWSRFType(), headName, this.getRSLocator().getURI().toString());
            return RSReader.getRSReader(newLocator);
        }
        catch (Exception e) {
            log.error((Object)"Could not keep top. Throwing Exception", (Throwable)e);
            throw new Exception("Could not keep top");
        }
    }

    public RSReader keepTop(int count) throws Exception {
        try {
            String headName = this.rs.keepTop(count, KeepTopThreadGeneric.PERPART);
            RSLocator newLocator = null;
            newLocator = this.getRSLocator().getRSResourceType() instanceof RSResourceLocalType ? new RSLocator(new RSResourceLocalType(), headName) : this.rs.wrap(new RSResourceWSRFType(), headName, this.getRSLocator().getURI().toString());
            return RSReader.getRSReader(newLocator);
        }
        catch (Exception e) {
            log.error((Object)"Could not keep top. Throwing Exception", (Throwable)e);
            throw new Exception("Could not keep top");
        }
    }

    public RSReader cloneRS() throws Exception {
        try {
            String headName = this.rs.cloneRS();
            RSLocator newLocator = null;
            if (this.getRSLocator().getRSResourceType() instanceof RSResourceLocalType) {
                newLocator = new RSLocator(new RSResourceLocalType(), headName);
                newLocator.setPrivKey(this.getRSLocator().getPrivKey());
            } else {
                newLocator = this.rs.wrap(new RSResourceWSRFType(), headName, this.getRSLocator().getURI().toString());
                newLocator.setPrivKey(this.getRSLocator().getPrivKey());
                newLocator.setScope(this.getRSLocator().getScope());
            }
            return RSReader.getRSReader(newLocator);
        }
        catch (Exception e) {
            log.error((Object)"Could not keep top. Throwing Exception", (Throwable)e);
            throw new Exception("Could not keep top");
        }
    }

    public String executeQueryOnHead(String xPath) throws Exception {
        try {
            return this.rs.executeQueryOnHead(xPath);
        }
        catch (Exception e) {
            log.error((Object)"Could not execute query. Throwing Exception", (Throwable)e);
            throw new Exception("Could not execute query");
        }
    }

    public String getCurrentContentPart() throws Exception {
        try {
            return this.rs.getCurrentContentPart();
        }
        catch (Exception e) {
            log.error((Object)"Could not retrieve current content part. Throwing Exception", (Throwable)e);
            throw new Exception("Could not retrieve current content part");
        }
    }

    public boolean isSecure() throws Exception {
        return this.rs.isSecure();
    }
}

