/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.rsclient.elements;

import java.net.InetAddress;
import java.security.PrivateKey;
import java.util.Date;
import org.apache.log4j.Logger;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.searchservice.resultsetservice.stubs.CanStreamResponse;
import org.gcube.common.searchservice.searchlibrary.resultset.ResultSet;
import org.gcube.common.searchservice.searchlibrary.resultset.helpers.RSFileHelper;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceLocalType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceWSRFType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceWSType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSTypeWrapper;

public class RSLocationWrapper {
    private static Logger log = Logger.getLogger(RSLocationWrapper.class);
    private RSLocator locator = null;
    private ResultSet lrs = null;
    private RSTypeWrapper rrs = null;

    public static RSLocator retrieveLocator(RSResourceType type, String headFileName, GCUBEScope scope) throws Exception {
        return RSLocationWrapper.retrieveLocator(type, headFileName, scope, null);
    }

    public static RSLocator retrieveLocator(RSResourceType type, String headFileName, PrivateKey pKey) throws Exception {
        return RSLocationWrapper.retrieveLocator(type, headFileName, null, pKey);
    }

    public static RSLocator retrieveLocator(RSResourceType type, String headFileName) throws Exception {
        return RSLocationWrapper.retrieveLocator(type, headFileName, null, null);
    }

    public static RSLocator retrieveLocator(RSResourceType type, String headFileName, GCUBEScope scope, PrivateKey pkey) throws Exception {
        if (type instanceof RSResourceWSRFType) {
            return RSTypeWrapper.retrieveWSRFLocator(((RSResourceWSRFType)type).getServiceEndPoint().toString(), headFileName, scope, pkey);
        }
        if (type instanceof RSResourceWSType) {
            return RSTypeWrapper.retrieveWSLocator(((RSResourceWSType)type).getServiceEndPoint().toString(), headFileName, scope, pkey);
        }
        log.error((Object)"Unrecognized RSResourceType. Throwing Exception");
        throw new Exception("Unrecognized RSResourceType");
    }

    public int getStaticPort() {
        if (this.rrs == null) {
            return -1;
        }
        return this.rrs.getPort();
    }

    public boolean getSSLsupport() {
        if (this.rrs == null) {
            return true;
        }
        return this.rrs.getSSLsupport();
    }

    public RSLocationWrapper(RSLocator locator) throws Exception {
        if (locator.getRSResourceType() instanceof RSResourceLocalType) {
            try {
                this.lrs = locator.getPrivKey() == null ? new ResultSet(locator.getLocator()) : new ResultSet(locator.getLocator(), locator.getPrivKey());
                this.locator = locator;
            }
            catch (Exception e) {
                log.error((Object)"Could not created RSLocationWrapper. Throwsing Exception", (Throwable)e);
                throw new Exception("Could not created RSLocationWrapper");
            }
        }
        try {
            this.rrs = new RSTypeWrapper(locator);
            this.locator = this.rrs.getLocator();
        }
        catch (Exception e) {
            log.error((Object)"Could not created RSLocationWrapper. Throwsing Exception", (Throwable)e);
            throw new Exception("Could not created RSLocationWrapper");
        }
    }

    public RSLocator getRSLocator() {
        return this.locator;
    }

    public RSLocator wrap(RSResourceType type) throws Exception {
        return new RSTypeWrapper(type, this.getHeadFileName()).getLocator();
    }

    public RSLocator wrap(RSResourceType type, String headName, String serviceEndPoint) throws Exception {
        return new RSTypeWrapper(type, headName, serviceEndPoint).getLocator();
    }

    public String getHeadFileName() throws Exception {
        if (this.lrs != null) {
            try {
                return this.lrs.getHeadName();
            }
            catch (Exception e) {
                log.error((Object)"Could not retrieve head file name. Throwing Exception", (Throwable)e);
                throw new Exception("Could not retrieve head file name");
            }
        }
        if (this.rrs != null) {
            try {
                return this.rrs.getHeadFileName(this.locator.getSessionToken());
            }
            catch (Exception e) {
                log.error((Object)"Could not retrieve properties. Throwing Exception", (Throwable)e);
                throw new Exception("Could not retrieve properties");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public CanStreamResponse getStreamPort() throws Exception {
        if (this.lrs != null) {
            log.error((Object)"requested stream port for local RS. Thropwing Exception");
            throw new Exception("requested stream port for local RS");
        }
        if (this.rrs != null) {
            try {
                CanStreamResponse streamInfo = this.rrs.canStream(this.locator.getSessionToken());
                log.trace((Object)("Can Stream from port: " + streamInfo.getPort()));
                return streamInfo;
            }
            catch (Exception e) {
                log.error((Object)"Could not retrieve stream port. Throwing Exception", (Throwable)e);
                throw new Exception("Could not retrieve stream port");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public void clear() throws Exception {
        if (this.lrs != null) {
            try {
                this.lrs.clear();
            }
            catch (Exception e) {
                log.error((Object)"Could not clear underlying structures. Throwing Exception", (Throwable)e);
                throw new Exception("Could not clear underlying structures");
            }
        } else if (this.rrs != null) {
            try {
                this.rrs.clear(this.locator.getSessionToken());
            }
            catch (Exception e) {
                log.error((Object)"Could not clear underlying structures. Throwing Exception", (Throwable)e);
                throw new Exception("Could not clear underlying structures");
            }
        } else {
            log.error((Object)"Initialization not complete. Throwing Exception");
            throw new Exception("Initialization not complete");
        }
    }

    public String[] getProperties(String type) throws Exception {
        if (this.lrs != null) {
            try {
                return this.lrs.getProperties(type);
            }
            catch (Exception e) {
                log.error((Object)"Could not retrieve properties. Throwing Exception", (Throwable)e);
                throw new Exception("Could not retrieve properties");
            }
        }
        if (this.rrs != null) {
            try {
                return this.rrs.getProperties(type, this.locator.getSessionToken());
            }
            catch (Exception e) {
                log.error((Object)"Could not retrieve properties. Throwing Exception", (Throwable)e);
                throw new Exception("Could not retrieve properties");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public boolean isFlowContoled() throws Exception {
        if (this.lrs != null) {
            try {
                return this.lrs.getRSRef().isDataFlow();
            }
            catch (Exception e) {
                log.error((Object)"Could not check if RS is flow controled. Throwing Exception", (Throwable)e);
                throw new Exception("Could not check if RS is flow controled");
            }
        }
        if (this.rrs != null) {
            try {
                return this.rrs.isFlowControled(this.locator.getSessionToken());
            }
            catch (Exception e) {
                log.error((Object)"Could not check if RS is flow controled. Throwing Exception", (Throwable)e);
                throw new Exception("Could not check if RS is flow controled");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public boolean getNextPart(int times) throws Exception {
        if (this.lrs != null) {
            try {
                return this.lrs.getNextPart(times);
            }
            catch (Exception e) {
                log.error((Object)"Could not move to next part. Throwing Exception", (Throwable)e);
                throw new Exception("Could not move to next part");
            }
        }
        if (this.rrs != null) {
            try {
                return this.rrs.getNextPart(times, this.locator.getSessionToken());
            }
            catch (Exception e) {
                log.error((Object)"Could not move to next part. Throwing Exception", (Throwable)e);
                throw new Exception("Could not move to next part");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public boolean nextAvailable() throws Exception {
        if (this.lrs != null) {
            try {
                return this.lrs.nextAvailable();
            }
            catch (Exception e) {
                log.error((Object)"Could not check if next part is available. Throwing Exception", (Throwable)e);
                throw new Exception("Could not check if next part is available");
            }
        }
        if (this.rrs != null) {
            try {
                return this.rrs.nextAvailable(this.locator.getSessionToken());
            }
            catch (Exception e) {
                log.error((Object)"Could not check if next part is available. Throwing Exception", (Throwable)e);
                throw new Exception("Could not check if next part is available");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public boolean getPreviousPart() throws Exception {
        if (this.lrs != null) {
            try {
                return this.lrs.getPreviousPart();
            }
            catch (Exception e) {
                log.error((Object)"Could not move to previous part. Throwing Exception", (Throwable)e);
                throw new Exception("Could not move to previous part");
            }
        }
        if (this.rrs != null) {
            try {
                return this.rrs.getPreviousPart(this.locator.getSessionToken());
            }
            catch (Exception e) {
                log.error((Object)"Could not move to previous part. Throwing Exception", (Throwable)e);
                throw new Exception("Could not move to previous part");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public boolean getFirstPart() throws Exception {
        if (this.lrs != null) {
            try {
                return this.lrs.getFirstPart();
            }
            catch (Exception e) {
                log.error((Object)"Could not move to Head part. Throwing Exception", (Throwable)e);
                throw new Exception("Could not move to Head part");
            }
        }
        if (this.rrs != null) {
            try {
                return this.rrs.getFirstPart(this.locator.getSessionToken());
            }
            catch (Exception e) {
                log.error((Object)"Could not move to Head part. Throwing Exception", (Throwable)e);
                throw new Exception("Could not move to Head part");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public String retrieveCustomProperties() throws Exception {
        if (this.lrs != null) {
            try {
                return this.lrs.retrieveCustomProperties();
            }
            catch (Exception e) {
                log.error((Object)"Could not retrieve Custom Properties. Throwing Exception", (Throwable)e);
                throw new Exception("Could not retrieve Custom Properties");
            }
        }
        if (this.rrs != null) {
            try {
                return this.rrs.retrieveCustomProperties(this.locator.getSessionToken());
            }
            catch (Exception e) {
                log.error((Object)"Could not retrieve Custom Properties. Throwing Exception", (Throwable)e);
                throw new Exception("Could not retrieve Custom Properties");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public boolean isFirst() throws Exception {
        if (this.lrs != null) {
            try {
                return this.lrs.isFirst();
            }
            catch (Exception e) {
                log.error((Object)"Could not check if is First. Throwing Exception", (Throwable)e);
                throw new Exception("Could not check if is First");
            }
        }
        if (this.rrs != null) {
            try {
                return this.rrs.isFirst(this.locator.getSessionToken());
            }
            catch (Exception e) {
                log.error((Object)"Could not check if is First. Throwing Exception", (Throwable)e);
                throw new Exception("Could not check if is First");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public boolean isLast() throws Exception {
        if (this.lrs != null) {
            try {
                return this.lrs.isLast();
            }
            catch (Exception e) {
                log.error((Object)"Could not check if is Last. Throwing Exception", (Throwable)e);
                throw new Exception("Could not check if is Last");
            }
        }
        if (this.rrs != null) {
            try {
                return this.rrs.isLast(this.locator.getSessionToken());
            }
            catch (Exception e) {
                log.error((Object)"Could not check if is Last. Throwing Exception", (Throwable)e);
                throw new Exception("Could not check if is Last");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public int getNumberOfResults(String type) throws Exception {
        if (this.lrs != null) {
            try {
                return this.lrs.getNumberOfResults(type);
            }
            catch (Exception e) {
                log.error((Object)"Could not get number of results. Throwing Exception", (Throwable)e);
                throw new Exception("Could not get number of results");
            }
        }
        if (this.rrs != null) {
            try {
                return this.rrs.getNumberOfResults(type, this.locator.getSessionToken());
            }
            catch (Exception e) {
                log.error((Object)"Could not get number of results. Throwing Exception", (Throwable)e);
                throw new Exception("Could not get number of results");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public String getResults(int index) throws Exception {
        if (this.lrs != null) {
            try {
                return this.lrs.getResult(index);
            }
            catch (Exception e) {
                log.warn((Object)("Could not get result with index" + index + ". In case of a BLOB rs this is not alarming :-). Throwing Exception"), (Throwable)e);
                throw new Exception("Could not get result with index" + index + ". In case of a BLOB rs this is not alarming :-)");
            }
        }
        if (this.rrs != null) {
            try {
                return this.rrs.getResult(index, this.locator.getSessionToken());
            }
            catch (Exception e) {
                log.error((Object)("Could not get result with index" + index + ". Throwing Exception"), (Throwable)e);
                throw new Exception("Could not get result with index" + index);
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public String[] getResults() throws Exception {
        if (this.lrs != null) {
            try {
                String[] res = this.lrs.getResults();
                if (res == null) {
                    return new String[0];
                }
                return res;
            }
            catch (Exception e) {
                log.error((Object)"Could not get results. Throwing Exception", (Throwable)e);
                throw new Exception("Could not get results");
            }
        }
        if (this.rrs != null) {
            try {
                String[] res = this.rrs.getAllResults(this.locator.getSessionToken());
                if (res == null) {
                    return new String[0];
                }
                return res;
            }
            catch (Exception e) {
                log.error((Object)"Could not get results. Throwing Exception", (Throwable)e);
                throw new Exception("Could not get results");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public String[] getResults(int from, int to) throws Exception {
        if (this.lrs != null) {
            try {
                String[] res = this.lrs.getResults(from, to);
                if (res == null) {
                    return new String[0];
                }
                return res;
            }
            catch (Exception e) {
                log.error((Object)"Could not get results. Throwing Exception", (Throwable)e);
                throw new Exception("Could not get results");
            }
        }
        if (this.rrs != null) {
            try {
                return this.rrs.getResults(from, to, this.locator.getSessionToken());
            }
            catch (Exception e) {
                log.error((Object)"Could not get results. Throwing Exception", (Throwable)e);
                throw new Exception("Could not get results");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public String canAttach() throws Exception {
        if (this.lrs != null) {
            try {
                String localName = RSFileHelper.generateName((short)0, null);
                RSFileHelper.copy((String)this.lrs.getCurrentContentPartName(), (String)localName);
                return localName;
            }
            catch (Exception e) {
                log.error((Object)"Could not get attached content. Throwing Exception", (Throwable)e);
                throw new Exception("Could not get attached content");
            }
        }
        if (this.rrs != null) {
            try {
                return this.rrs.canAttach(this.locator.getSessionToken());
            }
            catch (Exception e) {
                log.error((Object)"Could not get attached content. Throwing Exception", (Throwable)e);
                throw new Exception("Could not get attached content");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public String[] splitEncoded() throws Exception {
        if (this.lrs != null) {
            try {
                String[] res = this.lrs.splitEncoded();
                if (res == null) {
                    return new String[0];
                }
                return res;
            }
            catch (Exception e) {
                log.error((Object)"Could not split content encoded. Throwing Exception", (Throwable)e);
                throw new Exception("Could not split content encoded");
            }
        }
        if (this.rrs != null) {
            try {
                String[] res = this.rrs.splitEncoded(this.locator.getSessionToken());
                if (res == null) {
                    return new String[0];
                }
                return res;
            }
            catch (Exception e) {
                log.error((Object)"Could not split content encoded. Throwing Exception", (Throwable)e);
                throw new Exception("Could not split content encoded");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public String[] splitClear() throws Exception {
        if (this.lrs != null) {
            try {
                String[] res = this.lrs.splitClear();
                if (res == null) {
                    return new String[0];
                }
                return res;
            }
            catch (Exception e) {
                log.error((Object)"Could not split content encoded. Throwing Exception", (Throwable)e);
                throw new Exception("Could not split content encoded");
            }
        }
        if (this.rrs != null) {
            try {
                String[] res = this.rrs.splitClear(this.locator.getSessionToken());
                if (res == null) {
                    return new String[0];
                }
                return res;
            }
            catch (Exception e) {
                log.error((Object)"Could not split content clear. Throwing Exception", (Throwable)e);
                throw new Exception("Could not split content clear");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public String executeQueryOnDocument(String xPath) throws Exception {
        if (this.lrs != null) {
            try {
                return this.lrs.executeQueryOnDocument(xPath);
            }
            catch (Exception e) {
                log.error((Object)"Could not execute query on document. Throwing Exception", (Throwable)e);
                throw new Exception("Could not execute query on document");
            }
        }
        if (this.rrs != null) {
            try {
                return this.rrs.executeQueryOnDocument(xPath, this.locator.getSessionToken());
            }
            catch (Exception e) {
                log.error((Object)"Could not execute query on document. Throwing Exception", (Throwable)e);
                throw new Exception("Could not execute query on document");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public String executeQueryOnHead(String xPath) throws Exception {
        if (this.lrs != null) {
            try {
                return this.lrs.executeQueryOnHead(xPath);
            }
            catch (Exception e) {
                log.error((Object)"Could not execute query on head. Throwing Exception", (Throwable)e);
                throw new Exception("Could not execute head on document");
            }
        }
        if (this.rrs != null) {
            try {
                return this.rrs.executeQueryOnHead(xPath, this.locator.getSessionToken());
            }
            catch (Exception e) {
                log.error((Object)"Could not execute query on head. Throwing Exception", (Throwable)e);
                throw new Exception("Could not execute head on document");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public String[] executeQueryOnResults(String xPath) throws Exception {
        if (this.lrs != null) {
            try {
                String[] ret = this.lrs.executeQueryOnResults(xPath);
                if (ret == null) {
                    return new String[0];
                }
                return ret;
            }
            catch (Exception e) {
                log.error((Object)"Could not execute query on results. Throwing Exception", (Throwable)e);
                throw new Exception("Could not execute query on results");
            }
        }
        if (this.rrs != null) {
            try {
                return this.rrs.executeQueryOnResults(xPath, this.locator.getSessionToken());
            }
            catch (Exception e) {
                log.error((Object)"Could not execute query on results. Throwing Exception", (Throwable)e);
                throw new Exception("Could not execute query on results");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public boolean isLocal() throws Exception {
        if (this.lrs != null) {
            return true;
        }
        if (this.rrs != null) {
            try {
                String ip = this.rrs.getHostIP(this.locator.getSessionToken());
                return InetAddress.getLocalHost().getHostAddress().compareTo(ip) == 0;
            }
            catch (Exception e) {
                log.error((Object)"Could not check if is local. Throwing Exception", (Throwable)e);
                throw new Exception("Could not check if is local");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public String getHostIP() throws Exception {
        if (this.lrs != null) {
            try {
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                log.error((Object)"Could not retrieve local host ip. Throwing Exception", (Throwable)e);
                throw new Exception("Could not retrieve local host ip");
            }
        }
        if (this.rrs != null) {
            try {
                return this.rrs.getHostIP(this.locator.getSessionToken());
            }
            catch (Exception e) {
                log.error((Object)"Could not retrieve remote host ip. Throwing Exception", (Throwable)e);
                throw new Exception("Could not retrieve remote host ip");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public String getHostName() throws Exception {
        if (this.lrs != null) {
            try {
                return InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                log.error((Object)"Could not retrieve local host name. Throwing Exception", (Throwable)e);
                throw new Exception("Could not retrieve local host name");
            }
        }
        if (this.rrs != null) {
            try {
                return this.rrs.getHostName(this.locator.getSessionToken());
            }
            catch (Exception e) {
                log.error((Object)"Could not retrieve remote host name. Throwing Exception", (Throwable)e);
                throw new Exception("Could not retrieve remote host name");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public String getFileContent(String filename) throws Exception {
        if (this.lrs != null) {
            try {
                return this.lrs.getFileContent(filename);
            }
            catch (Exception e) {
                log.error((Object)"Could not retrieve file content. Throwing Exception", (Throwable)e);
                throw new Exception("Could not retrieve file content");
            }
        }
        if (this.rrs != null) {
            try {
                return this.rrs.getFileContent(filename, this.locator.getSessionToken());
            }
            catch (Exception e) {
                log.error((Object)"Could not retrieve file content. Throwing Exception", (Throwable)e);
                throw new Exception("Could not retrieve file content");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public String getCurrentContentPartPayload() throws Exception {
        if (this.lrs != null) {
            try {
                return this.lrs.getCurrentContentPartPayload();
            }
            catch (Exception e) {
                log.error((Object)"Could not retrieve file content. Throwing Exception", (Throwable)e);
                throw new Exception("Could not retrieve file content");
            }
        }
        if (this.rrs != null) {
            try {
                return this.rrs.getCurrentContentPartPayload(this.locator.getSessionToken());
            }
            catch (Exception e) {
                log.error((Object)"Could not retrieve file content. Throwing Exception", (Throwable)e);
                throw new Exception("Could not retrieve file content");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public String transformByXSLT(String transformation) throws Exception {
        if (this.lrs != null) {
            try {
                return this.lrs.transformByXSLT(transformation);
            }
            catch (Exception e) {
                log.error((Object)"Could not transform and retrieve content. Throwing Exception", (Throwable)e);
                throw new Exception("Could not transform and retrieve content");
            }
        }
        if (this.rrs != null) {
            try {
                return this.rrs.transformByXSLT(transformation, this.locator.getSessionToken());
            }
            catch (Exception e) {
                log.error((Object)"Could not transform and retrieve content. Throwing Exception", (Throwable)e);
                throw new Exception("Could not transform and retrieve content");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public String filterRS(String xPath, String[] properties) throws Exception {
        if (this.lrs != null) {
            try {
                return this.lrs.filterRS(xPath, properties);
            }
            catch (Exception e) {
                log.error((Object)"Could not filter By xPath Service Side. Throwing Exception", (Throwable)e);
                throw new Exception("Could not filter By xPath Service Side");
            }
        }
        if (this.rrs != null) {
            try {
                return this.rrs.filterRSProp(xPath, properties, this.locator.getSessionToken());
            }
            catch (Exception e) {
                log.error((Object)"Could not filter By xPath Service Side. Throwing Exception", (Throwable)e);
                throw new Exception("Could not filter By xPath Service Side");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public String filterRS(String xPath) throws Exception {
        if (this.lrs != null) {
            try {
                return this.lrs.filterRS(xPath);
            }
            catch (Exception e) {
                log.error((Object)"Could not filter By xPath Service Side. Throwing Exception", (Throwable)e);
                throw new Exception("Could not filter By xPath Service Side");
            }
        }
        if (this.rrs != null) {
            try {
                return this.rrs.filterRS(xPath, this.locator.getSessionToken());
            }
            catch (Exception e) {
                log.error((Object)"Could not filter By xPath Service Side. Throwing Exception", (Throwable)e);
                throw new Exception("Could not filter By xPath Service Side");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public String transformRS(String xslt, String[] properties) throws Exception {
        if (this.lrs != null) {
            try {
                return this.lrs.transformRS(xslt, properties);
            }
            catch (Exception e) {
                log.error((Object)"Could not transform By XSLT Service Side. Throwing Exception", (Throwable)e);
                throw new Exception("Could not transform By XSLT Service Side");
            }
        }
        if (this.rrs != null) {
            try {
                return this.rrs.transformRSProp(xslt, properties, this.locator.getSessionToken());
            }
            catch (Exception e) {
                log.error((Object)"Could not filter By xPath Service Side. Throwing Exception", (Throwable)e);
                throw new Exception("Could not filter By xPath Service Side");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public String transformRS(String xslt) throws Exception {
        if (this.lrs != null) {
            try {
                return this.lrs.transformRS(xslt);
            }
            catch (Exception e) {
                log.error((Object)"Could not filter By xPath Service Side. Throwing Exception", (Throwable)e);
                throw new Exception("Could not filter By xPath Service Side");
            }
        }
        if (this.rrs != null) {
            try {
                return this.rrs.transformRS(xslt, this.locator.getSessionToken());
            }
            catch (Exception e) {
                log.error((Object)"Could not filter By xPath Service Side. Throwing Exception", (Throwable)e);
                throw new Exception("Could not filter By xPath Service Side");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public String keepTop(int count, String[] properties, short type) throws Exception {
        if (this.lrs != null) {
            try {
                return this.lrs.keepTop(properties, count, type);
            }
            catch (Exception e) {
                log.error((Object)"Could not transform By XSLT Service Side. Throwing Exception", (Throwable)e);
                throw new Exception("Could not transform By XSLT Service Side");
            }
        }
        if (this.rrs != null) {
            try {
                return this.rrs.keepTopProp(count, properties, type, this.locator.getSessionToken());
            }
            catch (Exception e) {
                log.error((Object)"Could not keep Top Service Side. Throwing Exception", (Throwable)e);
                throw new Exception("Could not keep Top Service Side");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public String keepTop(int count, short type) throws Exception {
        if (this.lrs != null) {
            try {
                return this.lrs.keepTop(count, type);
            }
            catch (Exception e) {
                log.error((Object)"Could not keep Top Service Side. Throwing Exception", (Throwable)e);
                throw new Exception("Could not keep Top Service Side");
            }
        }
        if (this.rrs != null) {
            try {
                return this.rrs.keepTop(count, type, this.locator.getSessionToken());
            }
            catch (Exception e) {
                log.error((Object)"Could not keep Top Service Side. Throwing Exception", (Throwable)e);
                throw new Exception("Could not keep Top Service Side");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public String cloneRS() throws Exception {
        if (this.lrs != null) {
            try {
                return this.lrs.cloneRS();
            }
            catch (Exception e) {
                log.error((Object)"Could not clone rs Service Side. Throwing Exception", (Throwable)e);
                throw new Exception("Could not clone rs Service Side");
            }
        }
        if (this.rrs != null) {
            try {
                return this.rrs.cloneRS(this.locator.getSessionToken());
            }
            catch (Exception e) {
                log.error((Object)"Could not clone rs Service Side. Throwing Exception", (Throwable)e);
                throw new Exception("Could not clone rs Service Side");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public String getCurrentContentPart() throws Exception {
        if (this.lrs != null) {
            try {
                return this.lrs.getCurrentContentPartName();
            }
            catch (Exception e) {
                log.error((Object)"Could not retrieve current content part. Throwing Exception", (Throwable)e);
                throw new Exception("Could not retrieve current content part");
            }
        }
        if (this.rrs != null) {
            try {
                return this.rrs.getCurrentContentPartName(this.locator.getSessionToken());
            }
            catch (Exception e) {
                log.error((Object)"Could not retrieve current content part. Throwing Exception", (Throwable)e);
                throw new Exception("Could not retrieve current content part");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public boolean isForward() throws Exception {
        if (this.lrs != null) {
            try {
                return this.lrs.isForward();
            }
            catch (Exception e) {
                log.error((Object)"Could not retrieve current content part. Throwing Exception", (Throwable)e);
                throw new Exception("Could not retrieve current content part");
            }
        }
        if (this.rrs != null) {
            try {
                return this.rrs.isForward(this.locator.getSessionToken());
            }
            catch (Exception e) {
                log.error((Object)"Could not retrieve current content part. Throwing Exception", (Throwable)e);
                throw new Exception("Could not retrieve current content part");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public boolean hasAccessLeasing() throws Exception {
        if (this.lrs != null) {
            try {
                return this.lrs.getAccessLeasing() >= 0;
            }
            catch (Exception e) {
                log.error((Object)"Could not retrieve current content part. Throwing Exception", (Throwable)e);
                throw new Exception("Could not retrieve current content part");
            }
        }
        if (this.rrs != null) {
            try {
                return this.rrs.getAccessLeasing(this.locator.getSessionToken()) >= 0;
            }
            catch (Exception e) {
                log.error((Object)"Could not retrieve current content part. Throwing Exception", (Throwable)e);
                throw new Exception("Could not retrieve current content part");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public boolean hasTimeLeasing() throws Exception {
        if (this.lrs != null) {
            try {
                Date rsdate = this.lrs.getTimeLeasing();
                if (rsdate != null) {
                    Date zerodate = new Date(0L);
                    return rsdate.getTime() != zerodate.getTime();
                }
                return false;
            }
            catch (Exception e) {
                log.error((Object)"Could not retrieve current content part. Throwing Exception", (Throwable)e);
                throw new Exception("Could not retrieve current content part");
            }
        }
        if (this.rrs != null) {
            try {
                Date rsdate = this.rrs.getTimeLeasing(this.locator.getSessionToken());
                if (rsdate != null) {
                    Date zerodate = new Date(0L);
                    return rsdate.getTime() != zerodate.getTime();
                }
                return false;
            }
            catch (Exception e) {
                log.error((Object)"Could not retrieve current content part. Throwing Exception", (Throwable)e);
                throw new Exception("Could not retrieve current content part");
            }
        }
        log.error((Object)"Initialization not complete. Throwing Exception");
        throw new Exception("Initialization not complete");
    }

    public boolean isSecure() {
        return this.locator.getPrivKey() != null;
    }

    public boolean isScoped() {
        return this.locator.getScope() != null;
    }
}

