/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.rsclient.elements.pool;

import java.util.Calendar;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.pool.PoolConfig;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.pool.PoolObjectConfig;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.pool.PoolPopulateThread;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.pool.RSPoolObject;

public class RSPool {
    private static Logger log = Logger.getLogger(RSPool.class);
    private Hashtable<RSPoolObject.PoolObjectType, ConcurrentLinkedQueue<RSPoolObject>> pool;
    private PoolConfig poolConfig = null;
    private PoolPopulateThread worker = null;
    private Object synchMe = new Object();

    public RSPool(PoolConfig poolConfig) {
        this.pool = new Hashtable();
        this.poolConfig = poolConfig;
        this.worker = new PoolPopulateThread(this, this.synchMe);
        for (RSPoolObject.PoolObjectType poolType : RSPoolObject.PoolObjectType.values()) {
            if (this.poolConfig.get(poolType) == null) continue;
            this.pool.put(poolType, new ConcurrentLinkedQueue());
            this.worker.addType(poolType);
            log.info((Object)("initializing pool updater for type " + poolType.toString()));
        }
        this.worker.start();
    }

    public RSPoolObject GetObject(RSPoolObject.PoolObjectType type) throws Exception {
        long start = Calendar.getInstance().getTimeInMillis();
        if (this.poolConfig.get(type) != null) {
            log.debug((Object)("availalbe pool of type " + type.toString() + " not initialized. Populating"));
            this.populateTypeQueue(type);
        }
        RSPoolObject obj = null;
        ConcurrentLinkedQueue<RSPoolObject> objs = this.pool.get((Object)type);
        if (objs == null) {
            log.debug((Object)("type " + type.toString() + " not included in pool. Initializing single object"));
            obj = this.instantiateObject(type);
            log.debug((Object)("returning newly created writer in " + (Calendar.getInstance().getTimeInMillis() - start)));
            return obj;
        }
        obj = objs.poll();
        if (obj == null) {
            log.debug((Object)("pool of objects " + type.toString() + " empty. Initializing single object"));
            obj = this.instantiateObject(type);
        } else {
            log.debug((Object)"object found in pool");
        }
        log.debug((Object)("returning cached writer in " + (Calendar.getInstance().getTimeInMillis() - start)));
        return obj;
    }

    public RSPoolObject instantiateObject(RSPoolObject.PoolObjectType type) throws Exception {
        long start = Calendar.getInstance().getTimeInMillis();
        PoolObjectConfig conf = this.poolConfig.get(type);
        if (conf == null) {
            log.debug((Object)"creating default config for single instantiation");
            conf = new PoolObjectConfig();
            conf.FlowControl = false;
            conf.MaxSize = 0;
            conf.MinSize = 0;
            conf.ObjectType = type;
            conf.ResourceType = RSPoolObject.PoolObjectResourceType.WSRFType;
            conf.WellFormed = false;
        }
        log.debug((Object)"instantiating object");
        RSPoolObject obj = RSPoolObject.getPoolObjectInstance(type, conf);
        log.debug((Object)("writer instantiation took " + (Calendar.getInstance().getTimeInMillis() - start)));
        return obj;
    }

    public PoolConfig getConfig() {
        return this.poolConfig;
    }

    public int poolSizeOfType(RSPoolObject.PoolObjectType type) {
        return this.pool.get((Object)type).size();
    }

    public void addToPool(int number, RSPoolObject.PoolObjectType type) throws Exception {
        for (int i = 0; i < number; ++i) {
            this.pool.get((Object)type).add(this.instantiateObject(type));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateTypeQueue(RSPoolObject.PoolObjectType type) {
        long start = Calendar.getInstance().getTimeInMillis();
        ConcurrentLinkedQueue<RSPoolObject> objs = this.pool.get((Object)type);
        PoolObjectConfig conf = this.poolConfig.get(type);
        if (objs == null || conf == null) {
            log.error((Object)("could not find  config or initialized pool for type " + type.toString()));
            return;
        }
        if (objs.size() < conf.MinSize) {
            log.debug((Object)("marking type " + type.toString() + " for repopulation"));
            Object object = this.synchMe;
            synchronized (object) {
                this.worker.addType(type);
                this.synchMe.notify();
            }
        }
        log.debug((Object)("Type queue population notifivation took " + (Calendar.getInstance().getTimeInMillis() - start)));
    }
}

