/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementBase;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementGC;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBLOBBase;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBLOBGeneric;
import org.gcube.common.searchservice.searchlibrary.resultset.security.KeyGenerator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceLocalType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceWSRFType;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSBLOBIterator;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSBLOBReader;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSBLOBWriter;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSWriterCreationParams;

public class RSBLOBTester {
    String inFile = null;
    String outFile = null;
    RSResourceType RSType = null;
    RSResourceType MKlocalType = null;
    int recsperpart = 20;
    int bytesperpart = 102400;
    boolean verbose = false;
    boolean makelocal = false;

    public static void main(String[] args) {
        RSBLOBTester tester = new RSBLOBTester();
        try {
            tester.PerformTest(args);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    private void printUsage() {
        System.err.println("Usage: java RSBLOBTester [Options] \nOptions:\n-of <output Filename>\n-verbose \t\t Console output\n-type #id \t\t 0 for RSLocalType (default) or 1 for RSWSRFType\n-makelocal #id \t\t 0 for RSLocalType (default) or 1 for RSWSRFType \n \t\t\t try make local along with the test selected\n-endpoint <service URL> \t\t in case of RSWSRFType\n-test #id \t\t Test to perform \n\t\t\t 0 for no extra functionality (default) \n\t\t\t 1 for new style RS creation \n\t\t\t 2 for access leasing test \n\t\t\t 3 for encryption test \n\t\t\t 4 for encoding test \n");
    }

    private void PerformTest(String[] args) {
        try {
            String RStypeID = null;
            String MKlocaltypeID = null;
            String WSRFEndPoint = null;
            String testID = "0";
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("--help")) {
                    this.printUsage();
                    System.exit(1);
                }
                this.Print("Test ID" + testID);
                if (args[i].equalsIgnoreCase("-of")) {
                    this.outFile = args[i + 1];
                }
                if (args[i].equalsIgnoreCase("-type")) {
                    RStypeID = args[i + 1];
                }
                if (args[i].equalsIgnoreCase("-endpoint")) {
                    WSRFEndPoint = args[i + 1];
                }
                if (args[i].equalsIgnoreCase("-test")) {
                    testID = args[i + 1];
                    this.Print("Test ID" + testID);
                }
                if (args[i].equalsIgnoreCase("-verbose")) {
                    this.verbose = true;
                }
                if (!args[i].equalsIgnoreCase("-makelocal")) continue;
                MKlocaltypeID = args[i + 1];
                this.makelocal = true;
            }
            this.RSType = this.CreateRSResourceType(RStypeID, WSRFEndPoint);
            this.MKlocalType = this.CreateMakeLocalRSResourceType(MKlocaltypeID, WSRFEndPoint);
            if (testID.equalsIgnoreCase("0")) {
                this.PlainTest();
            }
            if (testID.equalsIgnoreCase("1")) {
                this.NewCreationTest();
            }
            if (testID.equalsIgnoreCase("2")) {
                this.AccessTest();
            }
            if (testID.equalsIgnoreCase("3")) {
                this.EncryptionTest();
            }
            if (testID.equalsIgnoreCase("4")) {
                this.EncodingTest();
            }
            System.out.println("Test Passed");
        }
        catch (Exception x) {
            System.out.println("Run with --help paametre to see the commandline options\n");
            x.printStackTrace();
        }
    }

    private void EncodingTest() throws Exception {
        this.Print("Starting rs writer");
        RSWriterCreationParams initParams = new RSWriterCreationParams();
        initParams.setAccessReads(100);
        RSBLOBWriter writer = RSBLOBWriter.getRSBLOBWriter(initParams);
        this.fillRS(writer);
        String epr = writer.getRSLocator(this.RSType).getLocator();
        this.Print(epr);
        this.Print("Starting rs re-reader ");
        RSLocator l = new RSLocator(epr);
        RSBLOBReader reader = RSBLOBReader.getRSBLOBReader(l);
        this.Print("Making local");
        this.persistRS(reader.makeLocal(this.MKlocalType));
    }

    private void EncryptionTest() throws Exception {
        this.Print("Starting rs writer");
        RSWriterCreationParams initParams = new RSWriterCreationParams();
        KeyGenerator kg = new KeyGenerator();
        KeyPair pair = kg.GenKeyPair();
        initParams.setPrivKey(pair.getPrivate());
        initParams.setPubKey(pair.getPublic());
        RSBLOBWriter writer = RSBLOBWriter.getRSBLOBWriter(initParams);
        this.fillRS(writer);
        String epr = writer.getRSLocator(this.RSType).getLocator();
        this.Print("Starting rs re-reader (2)");
        RSLocator l = new RSLocator(epr);
        l.setPrivKey(pair.getPrivate());
        RSBLOBReader reader = RSBLOBReader.getRSBLOBReader(l);
        this.Print("Making local");
        this.persistRS(reader.makeLocal(this.MKlocalType));
    }

    private void AccessTest() throws Exception {
        this.Print("Starting rs writer");
        RSWriterCreationParams initParams = new RSWriterCreationParams();
        initParams.setAccessReads(3);
        RSBLOBWriter writer = RSBLOBWriter.getRSBLOBWriter(initParams);
        this.Print("Writer access : " + writer.getAccessLeasing());
        this.fillRS(writer);
        String epr = writer.getRSLocator(this.RSType).getLocator();
        this.Print(epr);
        this.Print("Starting rs reader");
        RSLocator l = new RSLocator(epr);
        RSBLOBReader reader = RSBLOBReader.getRSBLOBReader(l);
        this.persistRS(reader.makeLocal(this.MKlocalType));
        try {
            this.Print("Starting rs reader");
            l = new RSLocator(epr);
            reader = RSBLOBReader.getRSBLOBReader(l);
            this.persistRS(reader.makeLocal(this.MKlocalType));
        }
        catch (Exception e) {
            this.Print("Read failed. This is correct!");
        }
    }

    private void NewCreationTest() throws Exception {
        this.Print("Starting rs writer");
        RSWriterCreationParams initParams = new RSWriterCreationParams();
        RSBLOBWriter writer = RSBLOBWriter.getRSBLOBWriter(initParams);
        this.fillRS(writer);
        String epr = writer.getRSLocator(this.RSType).getLocator();
        this.Print("Starting rs reader");
        RSLocator l = new RSLocator(epr);
        RSBLOBReader reader = RSBLOBReader.getRSBLOBReader(l);
        this.persistRS(reader.makeLocal(this.MKlocalType));
    }

    private void PlainTest() throws Exception {
        this.Print("Starting rs writer");
        RSBLOBWriter writer = RSBLOBWriter.getRSBLOBWriter(new PropertyElementBase[]{new PropertyElementGC("foo")});
        this.fillRS(writer);
        String epr = writer.getRSLocator(this.RSType).getLocator();
        this.Print("Starting rs reader");
        RSLocator l = new RSLocator(epr);
        RSBLOBReader reader = RSBLOBReader.getRSBLOBReader(l);
        this.persistRS(reader.makeLocal(this.MKlocalType));
    }

    public void persistRS(RSBLOBReader reader) throws Exception {
        FileOutputStream out = null;
        out = new FileOutputStream(new File(this.outFile));
        RSBLOBIterator iterator = reader.getRSIterator();
        int cnt = 0;
        while (iterator.hasNext()) {
            ResultElementBLOBGeneric blob = (ResultElementBLOBGeneric)iterator.next(ResultElementBLOBGeneric.class);
            if (blob != null) {
                this.Print("ID: " + blob.getRecordAttributes("DocID")[0].getAttrValue());
                this.Print("FromID: " + blob.getRecordAttributes("CollID")[0].getAttrValue());
                InputStream istream = blob.getContentOfBLOB();
                this.streamToFile(istream, out);
                istream.close();
                istream = null;
            } else {
                this.Print("To " + cnt + " blob pou epistrefei o iterator einai null. PROSEKSE kai auto...");
            }
            ++cnt;
        }
        ((OutputStream)out).close();
        out = null;
    }

    public void streamToFile(InputStream instream, OutputStream out) throws Exception {
        try {
            int len;
            byte[] buf = new byte[8096];
            int sum = 0;
            while ((len = instream.read(buf)) >= 0) {
                sum += len;
                out.write(buf, 0, len);
            }
        }
        catch (Exception e) {
            if (instream != null) {
                instream.close();
            }
            if (out != null) {
                out.close();
            }
            this.Print("Could not persist stream. Throwing Exception");
            throw e;
        }
    }

    public void fillRS(RSBLOBWriter writer) throws Exception {
        byte[] barray = new byte[1024];
        for (int j = 0; j < 1024; ++j) {
            barray[j] = 97;
        }
        for (int i = 0; i < 1; ++i) {
            ByteArrayInputStream instream = new ByteArrayInputStream(barray);
            ResultElementBLOBGeneric blob = new ResultElementBLOBGeneric(String.valueOf(i), "colid", null, (InputStream)instream);
            writer.addResults((ResultElementBLOBBase)blob);
        }
        writer.close();
    }

    private RSResourceType CreateMakeLocalRSResourceType(String stypeID, String endPoint) throws Exception {
        if (stypeID == null) {
            return new RSResourceLocalType();
        }
        if (stypeID.equalsIgnoreCase("0")) {
            return new RSResourceLocalType();
        }
        if (stypeID.equalsIgnoreCase("1")) {
            return new RSResourceWSRFType(endPoint);
        }
        return new RSResourceLocalType();
    }

    private RSResourceType CreateRSResourceType(String stypeID, String endPoint) throws Exception {
        if (stypeID == null) {
            return new RSResourceLocalType();
        }
        if (stypeID.equalsIgnoreCase("0")) {
            return new RSResourceLocalType();
        }
        if (stypeID.equalsIgnoreCase("1")) {
            return new RSResourceWSRFType(endPoint);
        }
        return new RSResourceLocalType();
    }

    private void Print(String string) {
        if (this.verbose) {
            System.out.println(string);
        }
    }
}

