/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.rsclient.elements;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.security.PrivateKey;
import java.util.Calendar;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.log4j.Logger;
import org.gcube.common.searchservice.resultsetservice.stubs.CanStreamResponse;
import org.gcube.common.searchservice.searchlibrary.resultset.helpers.RSFileHelper;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSReader;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSFullWriter;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class Transporter {
    private static Logger log = Logger.getLogger(Transporter.class);

    public static String transportEncoded(RSReader reader) throws Exception {
        OutputStreamWriter fw = null;
        BufferedWriter bw = null;
        InputStreamReader fr = null;
        BufferedReader br = null;
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            String[] pages = reader.getLocationIndependent().splitEncoded();
            String[] localPages = new String[pages.length];
            String decodedFile = null;
            for (int i = 0; i < pages.length; ++i) {
                String pageFile;
                localPages[i] = pageFile = RSFileHelper.generateName((short)2, null);
                fw = new FileWriter(new File(pageFile));
                bw = new BufferedWriter(fw);
                bw.write(reader.getLocationIndependent().getFileContent(pages[i]));
                bw.flush();
                bw.close();
                bw = null;
                fw.close();
                fw = null;
            }
            String encodedFile = RSFileHelper.generateName((short)2, null);
            log.trace((Object)("Transcoded file: " + encodedFile));
            fw = new FileWriter(encodedFile);
            bw = new BufferedWriter(fw);
            for (int i = 0; i < localPages.length; ++i) {
                fr = new FileReader(localPages[i]);
                br = new BufferedReader(fr);
                String line = br.readLine();
                while (line != null) {
                    bw.write(line);
                    line = br.readLine();
                }
                bw.flush();
                br.close();
                br = null;
                fr.close();
                fr = null;
            }
            bw.close();
            bw = null;
            fw.close();
            fw = null;
            decodedFile = RSFileHelper.generateName((short)0, null);
            BASE64Decoder decoder = new BASE64Decoder();
            in = new FileInputStream(new File(encodedFile));
            out = new FileOutputStream(new File(decodedFile));
            decoder.decodeBuffer((InputStream)in, (OutputStream)out);
            out.flush();
            in.close();
            in = null;
            out.close();
            out = null;
            for (int i = 0; i < localPages.length; ++i) {
                try {
                    new File(localPages[i]).delete();
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)("Could not remove file " + localPages[i] + ". Continuing"), (Throwable)e);
                }
            }
            try {
                new File(encodedFile).delete();
            }
            catch (Exception e) {
                log.error((Object)("Could not remove file " + encodedFile + ". Continuing"), (Throwable)e);
            }
            return decodedFile;
        }
        catch (Exception e) {
            if (fw != null) {
                fw.close();
            }
            if (bw != null) {
                bw.close();
            }
            if (fr != null) {
                fr.close();
            }
            if (br != null) {
                br.close();
            }
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
            log.error((Object)"Could not transport encoded. Throwing Exception", (Throwable)e);
            throw new Exception("Could not transport encoded. Throwing Exception");
        }
    }

    public static String transportClear(RSReader reader) throws Exception {
        OutputStreamWriter fw = null;
        BufferedWriter bw = null;
        InputStreamReader fr = null;
        BufferedReader br = null;
        try {
            int i;
            String[] pages = reader.getLocationIndependent().splitClear();
            String[] localPages = new String[pages.length];
            for (int i2 = 0; i2 < pages.length; ++i2) {
                String pageFile;
                localPages[i2] = pageFile = RSFileHelper.generateName((short)2, null);
                fw = new FileWriter(new File(pageFile));
                bw = new BufferedWriter(fw);
                bw.write(reader.getLocationIndependent().getFileContent(pages[i2]));
                bw.flush();
                bw.close();
                bw = null;
                fw.close();
                fw = null;
            }
            String encodedFile = RSFileHelper.generateName((short)2, null);
            fw = new FileWriter(encodedFile);
            bw = new BufferedWriter(fw);
            for (i = 0; i < localPages.length; ++i) {
                fr = new FileReader(localPages[i]);
                br = new BufferedReader(fr);
                String line = br.readLine();
                while (line != null) {
                    bw.write(line);
                    line = br.readLine();
                }
                bw.flush();
                br.close();
                br = null;
                fr.close();
                fr = null;
            }
            bw.close();
            bw = null;
            fw.close();
            fw = null;
            for (i = 0; i < localPages.length; ++i) {
                try {
                    new File(localPages[i]).delete();
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)("Could not remove file " + localPages[i] + ". Continuing"), (Throwable)e);
                }
            }
            return encodedFile;
        }
        catch (Exception e) {
            if (fw != null) {
                fw.close();
            }
            if (bw != null) {
                bw.close();
            }
            if (fr != null) {
                fr.close();
            }
            if (br != null) {
                br.close();
            }
            log.error((Object)"Could not transport clear. Throwing Exception", (Throwable)e);
            throw new Exception("Could not transport clear. Throwing Exception");
        }
    }

    public static String transportAttached(RSReader reader) throws Exception {
        try {
            return reader.getLocationIndependent().canAttach();
        }
        catch (Exception e) {
            log.error((Object)"Could not transport attached. Throwing Exception", (Throwable)e);
            throw new Exception("Could not transport attached. Throwing Exception");
        }
    }

    public static void transportStream(RSReader reader, RSFullWriter writer, int portStatic, boolean SSLsupport) throws Exception {
        long startLocal = Calendar.getInstance().getTimeInMillis();
        InputStream in = null;
        OutputStream out = null;
        DataOutputStream dout = null;
        DataInputStream din = null;
        Socket skt = null;
        try {
            block29: {
                long startPort = Calendar.getInstance().getTimeInMillis();
                int port = portStatic;
                boolean SSL = SSLsupport;
                if (port == 0) {
                    CanStreamResponse streamInfo = reader.getLocationIndependent().getStreamPort();
                    port = streamInfo.getPort();
                    SSL = streamInfo.isSSLsupport();
                }
                log.debug((Object)("port definition took " + (Calendar.getInstance().getTimeInMillis() - startPort)));
                String ip = null;
                try {
                    ip = reader.getLocationIndependent().getHostName();
                }
                catch (Throwable e) {
                    log.debug((Object)"could not retrieve host name. trying ip", e);
                    ip = reader.getLocationIndependent().getHostIP();
                }
                log.debug((Object)("transporting stream from ip:port " + ip + ":" + port + " using SSL: " + SSL));
                if (SSL) {
                    SSLSocketFactory sslsocketfactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                    SSLSocket SSLskt = null;
                    SSLskt = (SSLSocket)sslsocketfactory.createSocket(ip, port);
                    String[] enable = new String[]{"TLS_DH_anon_WITH_AES_128_CBC_SHA"};
                    SSLskt.setEnabledCipherSuites(enable);
                    log.debug((Object)"SSL protocols setup");
                    skt = SSLskt;
                } else {
                    skt = new Socket(ip, port);
                }
                in = skt.getInputStream();
                out = skt.getOutputStream();
                dout = new DataOutputStream(out);
                din = new DataInputStream(in);
                String head = reader.getLocationIndependent().getHeadFileName();
                dout.writeInt(head.getBytes().length);
                dout.write(head.getBytes());
                dout.flush();
                PrivateKey pKey = reader.getRSLocator().getPrivKey();
                if (pKey != null) {
                    byte[] pk = new BASE64Encoder().encode(pKey.getEncoded()).getBytes();
                    dout.writeInt(pk.length);
                    dout.write(pk);
                } else {
                    dout.writeInt(0);
                }
                int token = din.readInt();
                if (token != -1) {
                    writer.endAuthoring();
                    log.error((Object)("unexpected token " + token + "."));
                    throw new Exception("unexpected token " + token + ". protocol error.");
                }
                int count = 0;
                do {
                    ++count;
                    try {
                        String targetFile = RSFileHelper.generateName((short)0, null);
                        token = Transporter.readPart(din, targetFile);
                        writer.wrapFile(targetFile);
                        writer.startNewPart();
                    }
                    catch (Exception e) {
                        writer.endAuthoring();
                        log.error((Object)"error while reading part content. throwing exception", (Throwable)e);
                        throw new Exception("error while reading part content");
                    }
                    if (count == 1) {
                        log.info((Object)("first chunk available in " + (Calendar.getInstance().getTimeInMillis() - startLocal) + " millis"));
                    }
                    if (token == -2) break block29;
                } while (token == -1);
                writer.endAuthoring();
                log.error((Object)("unexpected token " + token + "."));
                throw new Exception("unexpected token " + token + ". protocol error.");
            }
            writer.endAuthoring();
        }
        catch (Exception e) {
            log.error((Object)"Cannot transport streamed. throwing exception", (Throwable)e);
            throw new Exception("Cannot transport streamed");
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not close input stream.continuing", (Throwable)e);
        }
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not close output stream.continuing", (Throwable)e);
        }
        try {
            if (dout != null) {
                dout.close();
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not close data output stream.continuing", (Throwable)e);
        }
        try {
            if (din != null) {
                din.close();
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not close data input stream.continuing", (Throwable)e);
        }
        try {
            if (skt != null) {
                skt.close();
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not close socket.continuing", (Throwable)e);
        }
    }

    private static int readPart(DataInputStream din, String outFile) throws Exception {
        FileOutputStream fout = new FileOutputStream(new File(outFile));
        int chunkSize = -2;
        try {
            while ((chunkSize = din.readInt()) >= 0) {
                byte[] chunk = new byte[chunkSize];
                din.readFully(chunk, 0, chunkSize);
                fout.write(chunk);
            }
            fout.close();
            return chunkSize;
        }
        catch (Exception e) {
            log.error((Object)"Could not complete stream reading of part. closing and throwoinfg exception", (Throwable)e);
            fout.close();
            throw new Exception("Could not complete stram reading of part.");
        }
    }
}

