/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.rsclient.elements;

import org.apache.log4j.Logger;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.ReaderInitParams;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSBLOBReader;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSReader;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSTEXTReader;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSXMLReader;

public class InitReaderThread
extends Thread {
    private static Logger log = Logger.getLogger(InitReaderThread.class);
    private ReaderInitParams params = null;
    private RSReaderEnum readerType;
    private Object reader = null;

    public InitReaderThread(ReaderInitParams params, RSReaderEnum readerType) {
        this.params = params;
        this.readerType = readerType;
    }

    public Object getReader() {
        return this.reader;
    }

    @Override
    public void run() {
        try {
            switch (this.readerType) {
                case Reader: {
                    RSReader r = RSReader.getRSReader(this.params.Locator);
                    if (this.params.Localize && this.params.KeepTop) {
                        r = r.makeLocal(this.params.ResourceType, this.params.Count);
                    } else if (this.params.Localize) {
                        r = r.makeLocal(this.params.ResourceType);
                    } else if (this.params.KeepTop) {
                        r = r.keepTop(this.params.Count);
                    }
                    this.reader = r;
                    return;
                }
                case BLOBReader: {
                    RSBLOBReader rb = RSBLOBReader.getRSBLOBReader(this.params.Locator);
                    if (this.params.Localize && this.params.KeepTop) {
                        rb = rb.makeLocal(this.params.ResourceType, this.params.Count);
                    } else if (this.params.Localize) {
                        rb = rb.makeLocal(this.params.ResourceType);
                    } else if (this.params.KeepTop) {
                        rb = rb.keepTop(this.params.Count);
                    }
                    this.reader = rb;
                    return;
                }
                case TEXTReader: {
                    RSTEXTReader rt = RSTEXTReader.getRSTEXTReader(this.params.Locator);
                    if (this.params.Localize && this.params.KeepTop) {
                        rt = rt.makeLocal(this.params.ResourceType, this.params.Count);
                    } else if (this.params.Localize) {
                        rt = rt.makeLocal(this.params.ResourceType);
                    } else if (this.params.KeepTop) {
                        rt = rt.keepTop(this.params.Count);
                    }
                    this.reader = rt;
                    return;
                }
                case XMLReader: {
                    RSXMLReader rx = RSXMLReader.getRSXMLReader(this.params.Locator);
                    if (this.params.Localize && this.params.KeepTop) {
                        rx = rx.makeLocal(this.params.ResourceType, this.params.Count);
                    } else if (this.params.Localize) {
                        rx = rx.makeLocal(this.params.ResourceType);
                    } else if (this.params.KeepTop) {
                        rx = rx.keepTop(this.params.Count);
                    }
                    this.reader = rx;
                    return;
                }
            }
            throw new Exception("non recognizable type " + (Object)((Object)this.readerType));
        }
        catch (Exception e) {
            this.reader = null;
            log.error((Object)("could not perform reader initialization on locator " + this.params.Locator.getLocator() + " . setting null"), (Throwable)e);
            return;
        }
    }

    public static enum RSReaderEnum {
        Reader,
        XMLReader,
        BLOBReader,
        TEXTReader;

    }
}

