/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.rswriter;

import org.apache.log4j.Logger;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementBase;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementGC;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementType;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementWellFormed;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.pool.PoolConfig;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.pool.PoolObjectConfig;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.pool.RSPool;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.pool.RSPoolObject;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSBLOBWriter;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSFullWriter;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSTEXTWriter;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSXMLWriter;

public class RSWriterFactory {
    private static Logger log = Logger.getLogger(RSWriterFactory.class);
    private RSPool pool = null;

    public RSWriterFactory(PoolConfig poolConfig) {
        this.pool = new RSPool(poolConfig);
    }

    public RSFullWriter getRSFullWriter(PropertyElementBase[] properties) throws Exception {
        try {
            RSFullWriter writer = (RSFullWriter)this.pool.GetObject(RSPoolObject.PoolObjectType.WriterFull);
            writer.overrideProperties(properties);
            return writer;
        }
        catch (Exception e) {
            log.error((Object)"Could not create full writer. Throwing Exception", (Throwable)e);
            throw new Exception("Could not create full writer");
        }
    }

    public RSFullWriter getRSFullWriter(String properties) throws Exception {
        try {
            RSFullWriter writer = (RSFullWriter)this.pool.GetObject(RSPoolObject.PoolObjectType.WriterFull);
            writer.overrideProperties(properties);
            return writer;
        }
        catch (Exception e) {
            log.error((Object)"Could not create full writer. Throwing Exception", (Throwable)e);
            throw new Exception("Could not create full writer");
        }
    }

    public RSTEXTWriter getRSTEXTWriter() throws Exception {
        try {
            RSTEXTWriter writer = (RSTEXTWriter)this.pool.GetObject(RSPoolObject.PoolObjectType.WriterFull);
            PropertyElementWellFormed wf = null;
            PoolObjectConfig conf = this.pool.getConfig().get(RSPoolObject.PoolObjectType.WriterText);
            boolean wellformed = false;
            if (conf != null) {
                wellformed = conf.WellFormed;
            }
            wf = wellformed ? new PropertyElementWellFormed(PropertyElementWellFormed.YES) : new PropertyElementWellFormed(PropertyElementWellFormed.NO);
            writer.overrideProperties(new PropertyElementBase[]{new PropertyElementGC(PropertyElementGC.unspecified), new PropertyElementType(PropertyElementType.TEXT), wf});
            return writer;
        }
        catch (Exception e) {
            log.error((Object)"could not create RSTEXTWriter. Throwing Exception", (Throwable)e);
            throw new Exception("could not create RSTEXTWriter");
        }
    }

    public RSTEXTWriter getRSTEXTWriter(PropertyElementBase[] properties) throws Exception {
        try {
            RSTEXTWriter writer = (RSTEXTWriter)this.pool.GetObject(RSPoolObject.PoolObjectType.WriterFull);
            PropertyElementWellFormed wf = null;
            PoolObjectConfig conf = this.pool.getConfig().get(RSPoolObject.PoolObjectType.WriterText);
            boolean wellformed = false;
            if (conf != null) {
                wellformed = conf.WellFormed;
            }
            PropertyElementBase[] props = new PropertyElementBase[properties.length + 2];
            wf = wellformed ? new PropertyElementWellFormed(PropertyElementWellFormed.YES) : new PropertyElementWellFormed(PropertyElementWellFormed.NO);
            System.arraycopy(properties, 0, props, 0, properties.length);
            props[properties.length] = new PropertyElementType(PropertyElementType.TEXT);
            props[properties.length + 1] = wf;
            writer.overrideProperties(props);
            return writer;
        }
        catch (Exception e) {
            log.error((Object)"could not create RSTEXTWriter. Throwing Exception", (Throwable)e);
            throw new Exception("could not create RSTEXTWriter");
        }
    }

    public RSXMLWriter getRSXMLWriter() throws Exception {
        try {
            RSXMLWriter writer = (RSXMLWriter)this.pool.GetObject(RSPoolObject.PoolObjectType.WriterXML);
            writer.overrideProperties(new PropertyElementBase[]{new PropertyElementGC(PropertyElementGC.unspecified), new PropertyElementType(PropertyElementType.XML)});
            return writer;
        }
        catch (Exception e) {
            log.error((Object)"could not create RSSimpelWriter. Throwing Exception", (Throwable)e);
            throw new Exception("could not create RSSimpelWriter");
        }
    }

    public RSXMLWriter getRSXMLWriter(PropertyElementBase[] properties) throws Exception {
        try {
            RSXMLWriter writer = (RSXMLWriter)this.pool.GetObject(RSPoolObject.PoolObjectType.WriterXML);
            PropertyElementBase[] props = new PropertyElementBase[properties.length + 1];
            System.arraycopy(properties, 0, props, 0, properties.length);
            props[properties.length] = new PropertyElementType(PropertyElementType.XML);
            writer.overrideProperties(props);
            return writer;
        }
        catch (Exception e) {
            log.error((Object)"could not create RSSimpelWriter. Throwing Exception", (Throwable)e);
            throw new Exception("could not create RSSimpelWriter");
        }
    }

    public RSBLOBWriter getRSBLOBWriter() throws Exception {
        try {
            RSBLOBWriter writer = (RSBLOBWriter)this.pool.GetObject(RSPoolObject.PoolObjectType.WriterBLOB);
            writer.overrideProperties(new PropertyElementBase[]{new PropertyElementGC(PropertyElementGC.unspecified), new PropertyElementType(PropertyElementType.BLOB)});
            return writer;
        }
        catch (Exception e) {
            log.error((Object)"could not create RSBLOBWriter. Throwing Exception", (Throwable)e);
            throw new Exception("could not create RSBLOBWriter");
        }
    }

    public RSBLOBWriter getRSBLOBWriter(PropertyElementBase[] properties) throws Exception {
        try {
            RSBLOBWriter writer = (RSBLOBWriter)this.pool.GetObject(RSPoolObject.PoolObjectType.WriterBLOB);
            PropertyElementBase[] props = new PropertyElementBase[properties.length + 1];
            System.arraycopy(properties, 0, props, 0, properties.length);
            props[properties.length] = new PropertyElementType(PropertyElementType.BLOB);
            writer.overrideProperties(props);
            return writer;
        }
        catch (Exception e) {
            log.error((Object)"could not create RSBLOBWriter. Throwing Exception", (Throwable)e);
            throw new Exception("could not create RSBLOBWriter");
        }
    }
}

