/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.sort;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.reader.RandomReader;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.writer.IRecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.comparator.CompareTokens;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.comparator.ComparisonMode;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.sort.SortArrayElement;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.sort.SortAscendingComparator;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.sort.SortDescendingComparator;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.sort.SortWorker;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.utils.ComparisonMethod;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfflineSortWorker<T extends Record>
implements SortWorker {
    private static Logger logger = LoggerFactory.getLogger((String)OfflineSortWorker.class.getName());
    private IRecordWriter<Record> writer = null;
    URI outLocator = null;
    private RandomReader<T> reader = null;
    private String keyFieldName = null;
    private short order = 0;
    private StatsContainer stats;
    private ComparisonMethod method = null;
    private long timeout;
    private TimeUnit timeUnit;

    public OfflineSortWorker(RandomReader<T> reader, IRecordWriter<Record> writer, String key, short order, ComparisonMethod method, ComparisonMode mode, long timeout, TimeUnit timeUnit, StatsContainer stats) throws Exception {
        this.reader = reader;
        reader.setWindowSize(1);
        this.writer = writer;
        this.keyFieldName = key;
        this.order = order;
        this.stats = stats;
        this.method = method;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        logger.info("Comparison method: " + (Object)((Object)this.method));
        if (method == ComparisonMethod.PROVIDED_MODE) {
            if (mode == null) {
                mode = ComparisonMode.COMPARE_STRINGS;
                CompareTokens.setMode(ComparisonMode.COMPARE_STRINGS);
                logger.warn("Missing mode. Assuming string comparison.");
            } else {
                CompareTokens.setMode(mode);
            }
            logger.info("Comparison mode: " + (Object)((Object)CompareTokens.getMode()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long start = Calendar.getInstance().getTimeInMillis();
        int count = 0;
        try {
            Record rec;
            ArrayList<SortArrayElement> sortVector = new ArrayList<SortArrayElement>(1000);
            ArrayList<SortArrayElement> appendVector = new ArrayList<SortArrayElement>();
            long now = Calendar.getInstance().getTimeInMillis();
            int rc = 0;
            while (this.reader.getStatus() != IBuffer.Status.Dispose && (this.reader.getStatus() != IBuffer.Status.Close || this.reader.availableRecords() != 0)) {
                Record record = this.reader.get(this.timeout, this.timeUnit);
                if (record == null) {
                    if (this.reader.getStatus() != IBuffer.Status.Open) break;
                    logger.warn("Producer has timed out");
                    break;
                }
                ++rc;
                String value = null;
                try {
                    if (rc == 1) {
                        logger.info("Time to first input: " + (Calendar.getInstance().getTimeInMillis() - now));
                        this.stats.timeToFirstInput(Calendar.getInstance().getTimeInMillis() - now);
                    }
                    try {
                        Field key = record.getField(this.keyFieldName);
                        if (key instanceof StringField) {
                            value = ((StringField)key).getPayload();
                        }
                    }
                    catch (Exception e) {
                        logger.warn("Could not extract sort key from record #" + rc + ". Continuing");
                    }
                    if (value == null) {
                        appendVector.add(new SortArrayElement(this.reader.currentRecord(), null));
                    } else {
                        sortVector.add(new SortArrayElement(this.reader.currentRecord(), value));
                        if (this.method == ComparisonMethod.DETECT_MODE) {
                            CompareTokens.updateMode(value);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("Could not retrieve the record. Continuing", (Throwable)e);
                }
                if (this.writer.getStatus() != IBuffer.Status.Close && this.writer.getStatus() != IBuffer.Status.Dispose) continue;
                logger.info("Consumer side stopped consumption. Stopping.");
                break;
            }
            logger.info("retrieving of results took " + (Calendar.getInstance().getTimeInMillis() - now));
            now = Calendar.getInstance().getTimeInMillis();
            if (this.writer.getStatus() == IBuffer.Status.Open) {
                if (this.method == ComparisonMethod.DETECT_MODE || this.method == ComparisonMethod.PROVIDED_MODE) {
                    if (this.order == 0) {
                        Collections.sort(sortVector, new SortAscendingComparator(CompareTokens.getMode()));
                    } else {
                        Collections.sort(sortVector, new SortDescendingComparator(CompareTokens.getMode()));
                    }
                } else if (this.order == 0) {
                    Collections.sort(sortVector, new SortAscendingComparator());
                } else {
                    Collections.sort(sortVector, new SortDescendingComparator());
                }
            }
            logger.info("SORT: sorting vector of " + sortVector.size() + " elements took " + (Calendar.getInstance().getTimeInMillis() - now));
            now = Calendar.getInstance().getTimeInMillis();
            long firststop = 0L;
            rc = 0;
            Iterator it = sortVector.iterator();
            while (it.hasNext()) {
                try {
                    ++count;
                    this.reader.seek(-this.reader.currentRecord() + ((SortArrayElement)it.next()).index - 1L);
                    rec = this.reader.get();
                    if (rec == null) {
                        throw new Exception("Could not retrieve stored record");
                    }
                    if (this.writer.getStatus() == IBuffer.Status.Close || this.writer.getStatus() == IBuffer.Status.Dispose) {
                        logger.info("Consumer side stopped consumption. Stopping.");
                        break;
                    }
                    if (!this.writer.put(rec, this.timeout, this.timeUnit)) {
                        if (this.writer.getStatus() != IBuffer.Status.Open) break;
                        logger.warn("Consumer has timed out");
                        break;
                    }
                    if (++rc != 1) continue;
                    firststop = Calendar.getInstance().getTimeInMillis();
                }
                catch (Exception e) {
                    logger.warn("Could not write record " + count, (Throwable)e);
                }
            }
            it = appendVector.iterator();
            while (it.hasNext()) {
                try {
                    ++count;
                    this.reader.seek(((SortArrayElement)it.next()).index);
                    rec = this.reader.get();
                    if (this.writer.getStatus() == IBuffer.Status.Close || this.writer.getStatus() == IBuffer.Status.Dispose) {
                        logger.info("Consumer side stopped consumption. Stopping.");
                        break;
                    }
                    if (!this.writer.put(rec, this.timeout, this.timeUnit)) {
                        if (this.writer.getStatus() != IBuffer.Status.Open) break;
                        logger.warn("Consumer has timed out");
                        break;
                    }
                    if (++rc != 1) continue;
                    firststop = Calendar.getInstance().getTimeInMillis();
                }
                catch (Exception e) {
                    logger.warn("Could not write record" + count, (Throwable)e);
                }
            }
            logger.info("SORT: writing results took " + (Calendar.getInstance().getTimeInMillis() - now));
            long closestop = Calendar.getInstance().getTimeInMillis();
            this.stats.timeToComplete(closestop - start);
            this.stats.timeToFirst(firststop - start);
            this.stats.producedResults(rc);
            this.stats.productionRate((float)rc / (float)(closestop - start) * 1000.0f);
            logger.info("SORT OPERATOR:Produced first result in " + (firststop - start) + " milliseconds\n" + "Produced last result in " + (closestop - start) + " milliseconds\n" + "Produced " + rc + " results\n" + "Production rate was " + (float)rc / (float)(closestop - start) * 1000.0f + " records per second");
        }
        catch (Exception e) {
            logger.error("Error while background sorting. Closing", (Throwable)e);
        }
        finally {
            try {
                try {
                    this.reader.close();
                    this.writer.close();
                }
                catch (Exception e) {}
            }
            catch (Exception ee) {
                logger.error("Error while closing. ", (Throwable)ee);
            }
        }
    }
}

