/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.google;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.writer.IRecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.google.GoogleResultElement;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.google.GoogleResultsRetriever;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryGoogleWorker
extends Thread {
    private static Logger logger = LoggerFactory.getLogger((String)QueryGoogleWorker.class.getName());
    private IRecordWriter<Record> writer = null;
    private StatsContainer stats = null;
    private String searchString = null;
    private int resNo;
    private long timeout;
    private TimeUnit timeUnit;

    public QueryGoogleWorker(String searchString, int resNo, IRecordWriter<Record> writer, long timeout, TimeUnit timeUnit, StatsContainer stats) {
        this.searchString = searchString;
        this.resNo = resNo;
        this.writer = writer;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.stats = stats;
    }

    private GoogleResultElement[] executeSearch(String query, int resNo) throws Exception {
        return GoogleResultsRetriever.getResults(query, resNo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long startTime = Calendar.getInstance().getTimeInMillis();
        long firstOutput = 0L;
        try {
            GoogleResultElement[] results = this.executeSearch(this.searchString, this.resNo);
            int i = 0;
            for (i = 0; i < results.length; ++i) {
                if (this.writer.getStatus() == IBuffer.Status.Close || this.writer.getStatus() == IBuffer.Status.Dispose) {
                    logger.info("Consumer side stopped consumption. Stopping.");
                    break;
                }
                GenericRecord rec = new GenericRecord();
                Field[] fields = new Field[]{new StringField(results[i].getKey()), new StringField(results[i].getPayload())};
                rec.setFields(fields);
                if (!this.writer.put((Record)rec, this.timeout, this.timeUnit)) {
                    if (this.writer.getStatus() != IBuffer.Status.Open) break;
                    logger.warn("Consumer has timed out");
                    break;
                }
                if (i != 1) continue;
                firstOutput = Calendar.getInstance().getTimeInMillis();
            }
            long closeStop = Calendar.getInstance().getTimeInMillis();
            this.stats.timeToFirstInput(0L);
            this.stats.timeToFirst(firstOutput - startTime);
            this.stats.timeToComplete(closeStop - startTime);
            this.stats.productionRate((float)i / ((float)(closeStop - startTime) * 1000.0f));
            logger.info("GOOGLE OPERATOR:Produced first result in " + (firstOutput - startTime) + " milliseconds\n" + "Produced last result in " + (closeStop - startTime) + " milliseconds\n" + "Produced " + i + " results\n" + "Production rate was " + (float)i / (float)(closeStop - startTime) * 1000.0f + " records per second");
        }
        catch (Exception e) {
            logger.error("Error while background searching google. Closing", (Throwable)e);
        }
        finally {
            try {
                this.writer.close();
            }
            catch (Exception exception) {}
        }
    }
}

