/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.booleancompare;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.reader.IRecordReader;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.booleancompare.Compute;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.comparator.CompareTokens;
import java.io.StringReader;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ComputeMin
implements Compute {
    private static Logger logger = LoggerFactory.getLogger((String)ComputeMin.class.getName());
    private String xpath;
    private String fieldName;
    private IRecordReader<Record> reader;
    private long timeout;
    private TimeUnit timeUnit;

    public ComputeMin(String xpath, String fieldName, IRecordReader<Record> reader, long timeout, TimeUnit timeUnit) {
        this.xpath = xpath;
        this.fieldName = fieldName;
        this.reader = reader;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object compute() throws Exception {
        String MIN = Integer.toString(Integer.MIN_VALUE);
        XPathExpression xpe = null;
        if (this.xpath != null) {
            XPathFactory xpf = XPathFactory.newInstance();
            XPath xp = xpf.newXPath();
            xpe = xp.compile("//" + this.xpath + " | //@" + this.xpath);
        }
        try {
            boolean firstRecord = true;
            block11: while (true) {
                Record rec;
                if ((rec = this.reader.get(this.timeout, this.timeUnit)) == null) {
                    if (this.reader.getStatus() == IBuffer.Status.Open) {
                        logger.warn("Producer has timed out");
                    }
                    break;
                }
                StringField field = (StringField)rec.getField(this.fieldName);
                if (this.xpath != null) {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    factory.setNamespaceAware(false);
                    factory.setIgnoringElementContentWhitespace(true);
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document document = builder.parse(new InputSource(new StringReader(field.getPayload())));
                    NodeList myNodeList = (NodeList)xpe.evaluate(document.getDocumentElement(), XPathConstants.NODESET);
                    if (myNodeList.getLength() <= 0) continue;
                    int i = 0;
                    while (true) {
                        if (i >= myNodeList.getLength()) continue block11;
                        if (myNodeList.item(i).getChildNodes() != null && myNodeList.item(i).getChildNodes().getLength() != 0) {
                            if (firstRecord) {
                                MIN = myNodeList.item(i).getFirstChild().getNodeValue();
                                firstRecord = false;
                            } else {
                                String cand = myNodeList.item(i).getFirstChild().getNodeValue();
                                int res = CompareTokens.compare(MIN, cand);
                                if (res > 0) {
                                    MIN = cand;
                                }
                            }
                        }
                        ++i;
                    }
                }
                if (firstRecord) {
                    MIN = field.getPayload();
                    firstRecord = false;
                    continue;
                }
                if (CompareTokens.compare(MIN, field.getPayload()) <= 0) continue;
                MIN = field.getPayload();
            }
        }
        catch (Exception e) {
            logger.error("could not complete compute", (Throwable)e);
            Object var4_7 = null;
            return var4_7;
        }
        finally {
            try {
                this.reader.close();
            }
            catch (Exception exception) {}
        }
        return MIN;
    }
}

