/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.booleancompare;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.IRecordReader;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.booleancompare.ComputeAverage;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.booleancompare.ComputeMax;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.booleancompare.ComputeMin;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.booleancompare.ComputeSize;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.booleancompare.ComputeSum;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.comparator.CompareTokens;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BooleanOperator {
    private Logger logger = LoggerFactory.getLogger((String)BooleanOperator.class.getName());
    protected static String RSRecordName = "RSRecord";
    private StatsContainer stats = null;
    private IRecordReader<Record>[] readers;
    private Document doc;
    private static final long TimeoutDef = 60L;
    private static final TimeUnit TimeUnitDef = TimeUnit.SECONDS;
    private long timeout = 60L;
    private TimeUnit timeUnit = TimeUnitDef;

    public URI compareMe(URI[] locators, String expression, StatsContainer stats) throws Exception {
        return this.compareMe(locators, expression, stats, 60L, TimeUnitDef);
    }

    public URI compareMe(URI[] locators, String expression, StatsContainer stats, long timeout, TimeUnit timeUnit) throws Exception {
        long start = Calendar.getInstance().getTimeInMillis();
        System.out.println("Expression: " + expression);
        for (int i = 0; i < locators.length; ++i) {
            System.out.println("locator(" + i + "): " + locators[i]);
        }
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.readers = new IRecordReader[locators.length];
        long startInit = Calendar.getInstance().getTimeInMillis();
        for (int i = 0; i < locators.length; ++i) {
            try {
                this.readers[i] = new ForwardReader(locators[i]);
                continue;
            }
            catch (Exception e) {
                this.logger.error("could not complete comparison. throwing Exception", (Throwable)e);
                throw new Exception(e.getMessage());
            }
        }
        stats.timeToInitialize(Calendar.getInstance().getTimeInMillis() - startInit);
        stats.timeToFirstInput(Calendar.getInstance().getTimeInMillis() - startInit);
        boolean compResult = false;
        RecordWriter writer = null;
        try {
            this.getDocFromString(expression);
            compResult = this.evaluateDocument(this.doc.getDocumentElement());
            writer = new RecordWriter((IWriterProxy)new LocalWriterProxy(), new RecordDefinition[]{new GenericRecordDefinition(new FieldDefinition[]{new StringFieldDefinition()})}, 100, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor);
            GenericRecord rec = new GenericRecord();
            StringField field = new StringField(compResult ? "true" : "false");
            rec.setFields(new Field[]{field});
            if (writer.getStatus() == IBuffer.Status.Close || writer.getStatus() == IBuffer.Status.Dispose) {
                this.logger.info("Consumer side stopped consumption. Stopping.");
            }
            if (!writer.put((Record)rec, timeout, timeUnit) && writer.getStatus() == IBuffer.Status.Open) {
                this.logger.warn("Consumer has timed out");
            }
            stats.timeToFirst(Calendar.getInstance().getTimeInMillis() - start);
            stats.timeToComplete(Calendar.getInstance().getTimeInMillis() - start);
            stats.producedResults(1L);
            stats.productionRate(0.0f);
            URI uRI = writer.getLocator();
            return uRI;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    private boolean evaluateDocument(Node curNode) throws Exception {
        System.out.println("Evaluate Document.");
        if (!(this.isGreaterEqual(curNode.getNodeName()) || this.isGreaterThan(curNode.getNodeName()) || this.isLowerEqual(curNode.getNodeName()) || this.isLowerThan(curNode.getNodeName()) || this.isEqual(curNode.getNodeName()) || this.isNotEqual(curNode.getNodeName()) || this.isLike(curNode.getNodeName()))) {
            throw new Exception("Root Operation should be one of the following:\nGreaterEq GreaterThan LowerEq LowerThan Eq NotEq Like");
        }
        NodeList elemChildren = curNode.getChildNodes();
        int elemCount = 0;
        for (int i = 0; i < elemChildren.getLength(); ++i) {
            if (elemChildren.item(i).getNodeType() != 1) continue;
            ++elemCount;
        }
        if (elemCount != 2) {
            throw new Exception("Equal operation should have two compare expressions");
        }
        if (this.isEqual(curNode.getNodeName())) {
            System.out.println("EQUAL");
            String[] tok = new String[2];
            int id = 0;
            for (int i = 0; i < elemChildren.getLength(); ++i) {
                if (elemChildren.item(i).getNodeType() != 1) continue;
                System.out.println("I: " + id);
                tok[id] = this.evaluateExpression(elemChildren.item(i)).toString();
                System.out.println("Finished I: " + id);
                ++id;
            }
            System.out.println("Checking equality between " + tok[0] + " and " + tok[1]);
            return CompareTokens.compare(tok[0], tok[1]) == 0;
        }
        if (this.isNotEqual(curNode.getNodeName())) {
            System.out.println("NOT EQUAL");
            String[] tok = new String[2];
            int id = 0;
            for (int i = 0; i < elemChildren.getLength(); ++i) {
                if (elemChildren.item(i).getNodeType() != 1) continue;
                System.out.println("I: " + id);
                tok[id] = this.evaluateExpression(elemChildren.item(i));
                ++id;
            }
            System.out.println("Checking inequality between " + tok[0] + " and " + tok[1]);
            return CompareTokens.compare(tok[0], tok[1]) != 0;
        }
        if (this.isGreaterThan(curNode.getNodeName())) {
            System.out.println("GREATER THAN");
            String[] tok = new String[2];
            int id = 0;
            for (int i = 0; i < elemChildren.getLength(); ++i) {
                if (elemChildren.item(i).getNodeType() != 1) continue;
                tok[id] = this.evaluateExpression(elemChildren.item(i));
                ++id;
            }
            System.out.println("Checking inequality between " + tok[0] + " and " + tok[1]);
            return CompareTokens.compare(tok[0], tok[1]) > 0;
        }
        if (this.isGreaterEqual(curNode.getNodeName())) {
            System.out.println("GREATER EQUAL");
            String[] tok = new String[2];
            int id = 0;
            for (int i = 0; i < elemChildren.getLength(); ++i) {
                if (elemChildren.item(i).getNodeType() != 1) continue;
                tok[id] = this.evaluateExpression(elemChildren.item(i));
                ++id;
            }
            System.out.println("Checking inequality between " + tok[0] + " and " + tok[1]);
            return CompareTokens.compare(tok[0], tok[1]) >= 0;
        }
        if (this.isLowerThan(curNode.getNodeName())) {
            System.out.println("LOWER THAN");
            String[] tok = new String[2];
            int id = 0;
            for (int i = 0; i < elemChildren.getLength(); ++i) {
                if (elemChildren.item(i).getNodeType() != 1) continue;
                tok[id] = this.evaluateExpression(elemChildren.item(i));
                ++id;
            }
            System.out.println("Checking inequality between " + tok[0] + " and " + tok[1]);
            return CompareTokens.compare(tok[0], tok[1]) < 0;
        }
        if (this.isLowerEqual(curNode.getNodeName())) {
            System.out.println("LOWER EQUAL");
            String[] tok = new String[2];
            int id = 0;
            for (int i = 0; i < elemChildren.getLength(); ++i) {
                if (elemChildren.item(i).getNodeType() != 1) continue;
                tok[id] = this.evaluateExpression(elemChildren.item(i));
                ++id;
            }
            System.out.println("Checking inequality between " + tok[0] + " and " + tok[1]);
            return CompareTokens.compare(tok[0], tok[1]) <= 0;
        }
        if (this.isLike(curNode.getNodeName())) {
            System.out.println("LIKE");
            String[] tok = new String[2];
            int id = 0;
            for (int i = 0; i < elemChildren.getLength(); ++i) {
                if (elemChildren.item(i).getNodeType() != 1) continue;
                tok[id] = this.evaluateExpression(elemChildren.item(i));
                ++id;
            }
            System.out.println("Checking pattern matching between " + tok[0] + " and " + tok[1]);
            Pattern myPattern = Pattern.compile(tok[1]);
            Matcher myMatcher = myPattern.matcher(tok[0]);
            return myMatcher.find();
        }
        throw new Exception("This Exception should NEVER be thrown.");
    }

    private String evaluateExpression(Node curNode) throws Exception {
        if (!(this.isMax(curNode.getNodeName()) || this.isMin(curNode.getNodeName()) || this.isSum(curNode.getNodeName()) || this.isAverage(curNode.getNodeName()) || this.isSize(curNode.getNodeName()) || this.isToken(curNode.getNodeName()))) {
            throw new Exception("Non-root operation should be one of the following:\nMax Min Avg Sum Size Token");
        }
        System.out.println("Inside evaluateExpression method.");
        StringWriter sw = new StringWriter();
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer tr = tf.newTransformer();
        tr.transform(new DOMSource((Element)curNode), new StreamResult(sw));
        System.out.println("Current node is: " + sw.toString());
        NodeList children = null;
        try {
            if (this.isMax(curNode.getNodeName())) {
                System.out.println("MAX");
                int id = -1;
                String xpath = null;
                String fieldName = null;
                children = curNode.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    if (children.item(i).getNodeType() != 1) continue;
                    if (this.isFieldName(children.item(i).getNodeName())) {
                        fieldName = children.item(i).getFirstChild().getNodeValue();
                    }
                    if (this.isID(children.item(i).getNodeName())) {
                        if (id >= this.readers.length) {
                            throw new Exception("Given id is greater than the reader array size.");
                        }
                        id = new Integer(children.item(i).getFirstChild().getNodeValue());
                    }
                    if (!this.isXPath(children.item(i).getNodeName())) continue;
                    xpath = children.item(i).getFirstChild().getNodeValue();
                }
                System.out.println("CALLING MAX");
                System.out.println("xpath: " + xpath);
                ComputeMax comp = new ComputeMax(xpath, fieldName, this.readers[id], this.timeout, this.timeUnit);
                String res = (String)comp.compute();
                System.out.println("RES: " + res);
                return res;
            }
            if (this.isMin(curNode.getNodeName())) {
                System.out.println("MIN");
                int id = -1;
                String xpath = null;
                String fieldName = null;
                children = curNode.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    if (children.item(i).getNodeType() != 1) continue;
                    if (this.isFieldName(children.item(i).getNodeName())) {
                        fieldName = children.item(i).getFirstChild().getNodeValue();
                    }
                    if (this.isID(children.item(i).getNodeName())) {
                        if (id >= this.readers.length) {
                            throw new Exception("Given id is greater than the reader array size.");
                        }
                        id = new Integer(children.item(i).getFirstChild().getNodeValue());
                    }
                    if (!this.isXPath(children.item(i).getNodeName())) continue;
                    xpath = children.item(i).getFirstChild().getNodeValue();
                }
                System.out.println("CALLING MIN");
                ComputeMin comp = new ComputeMin(xpath, fieldName, this.readers[id], this.timeout, this.timeUnit);
                String res = (String)comp.compute();
                System.out.println("RES: " + res);
                return res;
            }
            if (this.isSum(curNode.getNodeName())) {
                System.out.println("SUM");
                int id = -1;
                String xpath = null;
                String fieldName = null;
                children = curNode.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    if (children.item(i).getNodeType() != 1) continue;
                    if (this.isFieldName(children.item(i).getNodeName())) {
                        fieldName = children.item(i).getFirstChild().getNodeValue();
                    }
                    if (this.isID(children.item(i).getNodeName())) {
                        if (id >= this.readers.length) {
                            throw new Exception("Given id is greater than the reader array size.");
                        }
                        id = new Integer(children.item(i).getFirstChild().getNodeValue());
                    }
                    if (!this.isXPath(children.item(i).getNodeName())) continue;
                    xpath = children.item(i).getFirstChild().getNodeValue();
                }
                System.out.println("CALLING SUM");
                ComputeSum comp = new ComputeSum(xpath, fieldName, this.readers[id], this.timeout, this.timeUnit);
                String res = (String)comp.compute();
                System.out.println("RES: " + res);
                return res;
            }
            if (this.isSize(curNode.getNodeName())) {
                System.out.println("Size");
                int id = -1;
                String xpath = null;
                String fieldName = null;
                children = curNode.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    if (children.item(i).getNodeType() != 1) continue;
                    if (this.isFieldName(children.item(i).getNodeName())) {
                        fieldName = children.item(i).getFirstChild().getNodeValue();
                    }
                    if (this.isID(children.item(i).getNodeName())) {
                        if (id >= this.readers.length) {
                            throw new Exception("Given id is greater than the reader array size.");
                        }
                        id = new Integer(children.item(i).getFirstChild().getNodeValue());
                    }
                    if (!this.isXPath(children.item(i).getNodeName())) continue;
                    xpath = children.item(i).getFirstChild().getNodeValue();
                }
                System.out.println("CALLING SIZE");
                ComputeSize comp = new ComputeSize(xpath, fieldName, this.readers[id], this.timeout, this.timeUnit);
                String res = (String)comp.compute();
                System.out.println("RES: " + res);
                return res;
            }
            if (this.isAverage(curNode.getNodeName())) {
                System.out.println("AVERAGE");
                int id = -1;
                String xpath = null;
                String fieldName = null;
                children = curNode.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    if (children.item(i).getNodeType() != 1) continue;
                    if (this.isFieldName(children.item(i).getNodeName())) {
                        fieldName = children.item(i).getFirstChild().getNodeValue();
                    }
                    if (this.isID(children.item(i).getNodeName())) {
                        if (id >= this.readers.length) {
                            throw new Exception("Given id is greater than the reader array size.");
                        }
                        id = new Integer(children.item(i).getFirstChild().getNodeValue());
                    }
                    if (!this.isXPath(children.item(i).getNodeName())) continue;
                    xpath = children.item(i).getFirstChild().getNodeValue();
                }
                System.out.println("id = " + id);
                System.out.println("CALLING AVERAGE with xpath = " + xpath + " and reader = " + this.readers[id]);
                ComputeAverage comp = new ComputeAverage(xpath, fieldName, this.readers[id], this.timeout, this.timeUnit);
                String res = (String)comp.compute();
                System.out.println("RES: " + res);
                return res;
            }
            if (this.isToken(curNode.getNodeName())) {
                System.out.println("TOKEN");
                String res = curNode.getFirstChild().getNodeValue();
                System.out.println("RES: " + res);
                return res;
            }
        }
        catch (Exception e) {
            this.logger.error("could not evaluate expression. throwing Exception", (Throwable)e);
            throw new Exception(e.getMessage());
        }
        throw new Exception("This Exception should NEVER be thrown.");
    }

    private void getDocFromString(String XMLString) throws Exception {
        DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
        dbfactory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder db = null;
        try {
            db = dbfactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ParserConfigurationException("ProfileLoaderDOMImpl constructor caught ParserConfigurationException:\n" + e.getMessage());
        }
        try {
            this.doc = db.parse(new InputSource(new StringReader(XMLString)));
        }
        catch (SAXException e) {
            throw new SAXException("ProfileLoaderDOMImpl constructor caught SAXException:\n" + e.getMessage());
        }
        catch (IOException e) {
            throw new IOException("ProfileLoaderDOMImpl constructor caught IOException:\n" + e.getMessage());
        }
    }

    private boolean isGreaterThan(String tok) {
        if (tok == null) {
            return false;
        }
        return tok.compareTo("GreaterThan") == 0;
    }

    private boolean isLowerThan(String tok) {
        if (tok == null) {
            return false;
        }
        return tok.compareTo("LowerThan") == 0;
    }

    private boolean isGreaterEqual(String tok) {
        if (tok == null) {
            return false;
        }
        return tok.compareTo("GreaterEq") == 0;
    }

    private boolean isLowerEqual(String tok) {
        if (tok == null) {
            return false;
        }
        return tok.compareTo("LowerEq") == 0;
    }

    private boolean isEqual(String tok) {
        if (tok == null) {
            return false;
        }
        return tok.compareTo("Eq") == 0;
    }

    private boolean isNotEqual(String tok) {
        if (tok == null) {
            return false;
        }
        return tok.compareTo("NotEq") == 0;
    }

    private boolean isMax(String tok) {
        if (tok == null) {
            return false;
        }
        return tok.compareTo("Max") == 0;
    }

    private boolean isMin(String tok) {
        if (tok == null) {
            return false;
        }
        return tok.compareTo("Min") == 0;
    }

    private boolean isSize(String tok) {
        if (tok == null) {
            return false;
        }
        return tok.compareTo("Size") == 0;
    }

    private boolean isAverage(String tok) {
        if (tok == null) {
            return false;
        }
        return tok.compareTo("Avg") == 0;
    }

    private boolean isSum(String tok) {
        if (tok == null) {
            return false;
        }
        return tok.compareTo("Sum") == 0;
    }

    private boolean isID(String tok) {
        if (tok == null) {
            return false;
        }
        return tok.compareTo("ID") == 0;
    }

    private boolean isFieldName(String tok) {
        if (tok == null) {
            return false;
        }
        return tok.compareTo("FieldName") == 0;
    }

    private boolean isXPath(String tok) {
        if (tok == null) {
            return false;
        }
        return tok.compareTo("XPath") == 0;
    }

    private boolean isPlus(String tok) {
        if (tok == null) {
            return false;
        }
        return tok.compareTo("Plus") == 0;
    }

    private boolean isMinus(String tok) {
        if (tok == null) {
            return false;
        }
        return tok.compareTo("Minus") == 0;
    }

    private boolean isTimes(String tok) {
        if (tok == null) {
            return false;
        }
        return tok.compareTo("Times") == 0;
    }

    private boolean isDiv(String tok) {
        if (tok == null) {
            return false;
        }
        return tok.compareTo("Div") == 0;
    }

    private boolean isLike(String tok) {
        if (tok == null) {
            return false;
        }
        return tok.compareTo("Like") == 0;
    }

    private boolean isToken(String tok) {
        if (tok == null) {
            return false;
        }
        return tok.compareTo("Token") == 0;
    }
}

