/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.partition;

import gr.uoa.di.madgik.grs.GRS2Exception;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.IRecordWriter;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Partitioner {
    private static Logger logger = LoggerFactory.getLogger((String)Partitioner.class.getName());
    private long timeout;
    private TimeUnit timeUnit;
    IRecordWriter<Record> output;
    private RecordDefinition[] defs;
    private HashMap<Integer, IRecordWriter<Record>> writers;
    private int cnt = 0;

    public Partitioner(IRecordWriter<Record> output, RecordDefinition[] defs, long timeout, TimeUnit timeUnit) {
        this.output = output;
        this.defs = defs;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.writers = new HashMap();
    }

    public IRecordWriter<Record> getWriter(String field) throws GRS2Exception {
        if (this.writers.containsKey(field.hashCode())) {
            return this.writers.get(field.hashCode());
        }
        RecordWriter writer = new RecordWriter((IWriterProxy)new LocalWriterProxy(), this.defs, RecordWriter.DefaultBufferCapacity, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor, this.timeout, this.timeUnit);
        this.writers.put(field.hashCode(), (IRecordWriter<Record>)writer);
        logger.debug("Created (" + ++this.cnt + ") result set: " + writer.getLocator());
        GenericRecord rec = new GenericRecord();
        rec.setFields(new Field[]{new StringField(writer.getLocator().toASCIIString())});
        if (!this.output.importRecord((Record)rec, 60L, TimeUnit.SECONDS) && this.output.getStatus() == IBuffer.Status.Open) {
            logger.warn("Consumer has timed out");
        }
        return writer;
    }

    public void closeAll() {
        for (IRecordWriter<Record> w : this.writers.values()) {
            try {
                w.close();
            }
            catch (GRS2WriterException e) {
                try {
                    logger.warn("Could not close locator " + w.getLocator() + ". Continuing to next");
                }
                catch (GRS2WriterException e1) {
                    logger.warn("Could not close locator. Continuing to next");
                }
            }
        }
    }
}

