/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.join;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.reader.RandomReader;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.join.BooleanHolder;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.join.EventEntry;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.join.HashKey;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.join.JoinElement;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.join.ScanElement;
import java.security.MessageDigest;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderScan
extends Thread {
    private static Logger logger = LoggerFactory.getLogger((String)ReaderScan.class.getName());
    ScanElement scan = null;
    private String uid = null;

    public ReaderScan(ScanElement scan, String uid) {
        this.scan = scan;
        this.uid = uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block34: {
            int rc = 0;
            try {
                Object stopNotifier = null;
                long timeout = 0L;
                TimeUnit timeUnit = null;
                Object object = this.scan.getSynchThis();
                synchronized (object) {
                    this.scan.setActive(true);
                    timeout = this.scan.getTimeout();
                    timeUnit = this.scan.getTimeUnit();
                    this.scan.getSynchThis().notify();
                    stopNotifier = this.scan.getStopNotifier();
                }
                RandomReader<Record> reader = this.scan.getReader();
                MessageDigest algorithm = MessageDigest.getInstance("SHA-1");
                long currentRecordIndex = 0L;
                while (true) {
                    try {
                        while (true) {
                            if (((BooleanHolder)stopNotifier).get()) {
                                logger.info(this.uid + ": Reader stopping after being notified");
                                break block34;
                            }
                            Record record = null;
                            Object object2 = this.scan.getSynchThis();
                            synchronized (object2) {
                                if (reader.getStatus() == IBuffer.Status.Dispose || reader.getStatus() == IBuffer.Status.Close && reader.availableRecords() == 0) {
                                    break block34;
                                }
                                record = reader.get(timeout, timeUnit);
                                if (record == null) {
                                    if (reader.getStatus() == IBuffer.Status.Open) {
                                        logger.warn(this.uid + ": Producer has timed out");
                                    }
                                    break block34;
                                }
                                ++rc;
                                currentRecordIndex = reader.currentRecord();
                                this.scan.getEventHandler().increaseReadRecordCount(this.scan.getInputID());
                                BufferEvent ev = reader.receive();
                                if (ev != null) {
                                    this.scan.getEventQueue().add(new EventEntry(ev, this.scan.getInputID()));
                                }
                            }
                            String value = null;
                            try {
                                value = ((StringField)record.getField(this.scan.getKey())).getPayload();
                            }
                            catch (Exception e) {
                                logger.warn(this.uid + ": Could not extract value from record ", (Throwable)e);
                            }
                            if (value == null) continue;
                            algorithm.reset();
                            algorithm.update(new String(value).getBytes());
                            byte[] digest = algorithm.digest();
                            Vector<Long> vec = new Vector<Long>();
                            Object object3 = this.scan.getSynchThis();
                            synchronized (object3) {
                                vec.add(currentRecordIndex);
                                this.scan.setCounter(this.scan.getCounter() + 1L);
                                this.scan.getSynchThis().notifyAll();
                            }
                            this.scan.getQueue().put(new JoinElement(vec, new HashKey(digest), this.scan.getInputID()));
                        }
                    }
                    catch (Exception e) {
                        logger.error(this.uid + ": Could not retrieve the record. Continuing", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                logger.error(this.uid + ": Could not scan entire reader. Closing", (Throwable)e);
            }
            finally {
                logger.trace(this.uid + " read " + rc + " records");
                Object object = this.scan.getSynchThis();
                synchronized (object) {
                    this.scan.setActive(false);
                    this.scan.setFinished(true);
                }
            }
        }
    }
}

