/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.extjdbc;

import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.writer.IRecordWriter;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.extjdbc.QueryBridge;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.extjdbc.QueryJdbcWorker;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.extjdbc.QueryParser;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import java.net.URI;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcOp {
    private static Logger logger = LoggerFactory.getLogger((String)JdbcOp.class.getName());
    private StatsContainer stats;
    public static String ObjectIdFieldNameDef = "objectId";
    public static String PayloadFieldNameDef = "payload";
    private String objectIdFieldName = ObjectIdFieldNameDef;
    private String payloadFieldName = PayloadFieldNameDef;
    private static final long TimeoutDef = 60L;
    private static final TimeUnit TimeUnitDef = TimeUnit.SECONDS;
    private long timeout = 60L;
    private TimeUnit timeUnit = TimeUnitDef;

    public JdbcOp(StatsContainer stats) {
        this.stats = stats;
    }

    public JdbcOp(long timeout, TimeUnit timeUnit, StatsContainer stats) {
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.stats = stats;
    }

    public JdbcOp(String objectIdFieldName, String payloadFieldName, long timeout, TimeUnit timeUnit, StatsContainer stats) {
        this.objectIdFieldName = objectIdFieldName;
        this.payloadFieldName = payloadFieldName;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.stats = stats;
    }

    public URI compute(String query) throws Exception {
        try {
            QueryParser parser = new QueryParser(query);
            QueryBridge qb = new QueryBridge(parser.getDriverName(), parser.getConnectionString(), 20);
            ResultSet rs = qb.executeQuery(parser.getQuery());
            String[] columnNames = qb.getColumnNames();
            FieldDefinition[] fieldDefs = new FieldDefinition[]{new StringFieldDefinition(this.objectIdFieldName), new StringFieldDefinition(this.payloadFieldName)};
            RecordWriter writer = new RecordWriter((IWriterProxy)new LocalWriterProxy(), new RecordDefinition[]{new GenericRecordDefinition(fieldDefs)}, 100, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor);
            long writestart = Calendar.getInstance().getTimeInMillis();
            String UniqueDocId = parser.getQuery() + parser.getConnectionString() + parser.getDriverName();
            QueryJdbcWorker worker = new QueryJdbcWorker(rs, columnNames, UniqueDocId, (IRecordWriter<Record>)writer, this.timeout, this.timeUnit, this.stats);
            worker.start();
            long writestop = Calendar.getInstance().getTimeInMillis();
            this.stats.timeToInitialize(writestop - writestart);
            return writer.getLocator();
        }
        catch (Exception e) {
            logger.error("Could not initialize jdbc operation. Throwing Exception", (Throwable)e);
            throw new Exception("Could not initialize jdbc operation");
        }
    }
}

