/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.transform;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.Unary;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.transform.ScriptWorker;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptOp
extends Unary {
    private Logger logger = LoggerFactory.getLogger((String)ScriptOp.class.getName());
    private String script;
    private List<File> tempFiles = new ArrayList<File>();
    private String schema;

    public ScriptOp(URI inLocator, Map<String, String> operatorParameters, StatsContainer stats) throws Exception {
        super(inLocator, operatorParameters, stats);
        this.init();
    }

    public ScriptOp(URI inLocator, Map<String, String> operatorParameters, StatsContainer stats, long timeout, TimeUnit timeUnit) throws Exception {
        super(inLocator, operatorParameters, stats, timeout, timeUnit);
        this.init();
    }

    private void init() throws Exception {
        this.script = (String)this.operatorParameters.get("scriptCmd");
        this.schema = (String)this.operatorParameters.get("schema");
        if (this.script.isEmpty()) {
            throw new Exception("script not specified in opearator parameters");
        }
        for (String key : this.operatorParameters.keySet()) {
            String scriptName;
            if (key.equals("script") || key.equals("schema") || !this.script.contains(scriptName = key.replace("CDATA:", ""))) continue;
            File f = ScriptOp.decompressToFile(Base64.decode((String)this.operatorParameters.get(key)));
            this.script = this.script.replace(scriptName, f.getAbsolutePath());
            this.tempFiles.add(f);
        }
        this.logger.info("initialised script operator with script: " + this.script);
    }

    @Override
    public URI compute() throws Exception {
        try {
            long start = Calendar.getInstance().getTimeInMillis();
            ForwardReader reader = new ForwardReader(this.inLocator);
            final ScriptWorker worker = new ScriptWorker(reader, this.script, this.schema, this.stats, this.timeout, this.timeUnit);
            worker.start();
            long readerstop = Calendar.getInstance().getTimeInMillis();
            this.stats.timeToInitialize(readerstop - start);
            new Thread(){

                @Override
                public void run() {
                    try {
                        worker.join();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    for (File f : ScriptOp.this.tempFiles) {
                        f.delete();
                    }
                }
            }.start();
            return worker.getLocator();
        }
        catch (Exception e) {
            this.logger.error("Could not initialize transform operation. Throwing Exception", (Throwable)e);
            throw new Exception("Could not initialize transform operation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File decompressToFile(byte[] zipped) {
        File tmp = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            tmp = File.createTempFile("script", ".tmp");
            ByteArrayInputStream in = new ByteArrayInputStream(zipped);
            inputStream = new GZIPInputStream(in);
            outputStream = new FileOutputStream(tmp);
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, read);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return tmp;
    }
}

