/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.datasink.predefined;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.reader.IRecordReader;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FileField;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.FieldNaming;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.datasink.DataSink;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.utils.FileUtils;
import java.io.File;
import java.net.URI;
import java.util.Calendar;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathDataSink<T extends Record>
extends DataSink {
    private static Logger log = LoggerFactory.getLogger((String)PathDataSink.class.getName());
    private String sinkPath = this.output;
    private IRecordReader<T> reader = null;

    public PathDataSink(URI inLocator, String output, Map<String, String> outputParameters, StatsContainer statsCont) throws Exception {
        super(inLocator, output, outputParameters, statsCont);
        if (!this.sinkPath.endsWith(File.separator)) {
            this.sinkPath = this.sinkPath + File.separator;
        }
        this.reader = new ForwardReader(inLocator);
        RecordDefinition defs = this.reader.getRecordDefinitions()[0];
        if (defs.getDefinition(FieldNaming.LocalFieldName.id.name()) < 0 || defs.getDefinition(FieldNaming.LocalFieldName.bytestream.name()) < 0 || defs.getDefinition(FieldNaming.LocalFieldName.mimeType.name()) < 0) {
            log.error("LocalDataSink could not be initialized, cause corresponding fields are missing from resultSet");
            throw new Exception("LocalDataSink could not be initialized, cause corresponding fields are missing from resultSet");
        }
        if (!new File(this.sinkPath).exists()) {
            throw new Exception("path does not exist: " + this.sinkPath);
        }
        log.info("Ininializing local data sink at: " + this.sinkPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int rc;
        long firstOutputStop;
        long firstInputStop;
        long start;
        block22: {
            Thread.currentThread().setName(PathDataSink.class.getName());
            firstInputStop = start = Calendar.getInstance().getTimeInMillis();
            firstOutputStop = start;
            rc = 0;
            try {
                while (true) {
                    try {
                        while (this.reader.getStatus() != IBuffer.Status.Dispose) {
                            String contentType;
                            File payload;
                            String recordId;
                            block23: {
                                if (this.reader.getStatus() == IBuffer.Status.Close && this.reader.availableRecords() == 0) {
                                    break block22;
                                }
                                Record rec = this.reader.get(this.timeout, this.timeUnit);
                                if (rec == null) {
                                    if (this.reader.getStatus() != IBuffer.Status.Open) break block22;
                                    log.warn("Producer has timed out");
                                }
                                if (rc == 0) {
                                    firstInputStop = Calendar.getInstance().getTimeInMillis();
                                }
                                recordId = null;
                                payload = null;
                                contentType = "";
                                try {
                                    Field contentTypeField;
                                    Field payloadField;
                                    Field recIdField = rec.getField(FieldNaming.LocalFieldName.id.name());
                                    if (recIdField instanceof StringField) {
                                        recordId = ((StringField)recIdField).getPayload();
                                    }
                                    if ((payloadField = rec.getField(FieldNaming.LocalFieldName.bytestream.name())) instanceof FileField) {
                                        payload = ((FileField)payloadField).getPayload();
                                    }
                                    if (!((contentTypeField = rec.getField(FieldNaming.LocalFieldName.mimeType.name())) instanceof StringField)) break block23;
                                    contentType = ((StringField)contentTypeField).getPayload();
                                }
                                catch (Exception e) {
                                    log.warn("Could not extract payload from record #" + rc + ". Continuing");
                                    continue;
                                }
                            }
                            String filename = recordId.hashCode() + contentType.replaceAll("/", ".");
                            log.info("Trying to persist file " + this.sinkPath + filename);
                            FileUtils.copyFile(payload, new File(this.sinkPath + filename));
                            if (++rc != 1) continue;
                            firstOutputStop = Calendar.getInstance().getTimeInMillis();
                        }
                    }
                    catch (GRS2ReaderException e) {
                        log.error("Could not retrieve and store the record. Continuing", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                log.error("Error during datasink retrieval. Closing", (Throwable)e);
            }
            finally {
                try {
                    this.reader.close();
                }
                catch (Exception ee) {}
            }
        }
        long closeStop = Calendar.getInstance().getTimeInMillis();
        this.stats.timeToComplete(closeStop - start);
        this.stats.timeToFirstInput(firstInputStop - start);
        this.stats.timeToFirst(firstOutputStop - start);
        this.stats.producedResults((long)rc);
        this.stats.productionRate((float)rc / (float)(closeStop - start) * 1000.0f);
        log.info("DATASINK OPERATOR:Produced first result in " + (firstOutputStop - start) + " milliseconds\n" + "Produced last result in " + (closeStop - start) + " milliseconds\n" + "Produced " + rc + " results\n" + "Production rate was " + (float)rc / (float)(closeStop - start) * 1000.0f + " records per second");
    }

    @Override
    public String getOutput() {
        return this.sinkPath;
    }
}

