/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.datafusion.helpers;

import gr.uoa.di.madgik.grs.record.GenericRecord;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;
import org.gcube.search.datafusion.datatypes.Pair;
import org.gcube.search.datafusion.datatypes.PositionalRecordWrapper;
import org.gcube.search.datafusion.datatypes.RankedRecord;
import org.gcube.search.datafusion.helpers.RecordHelper;
import org.gcube.search.datafusion.helpers.ResultSetHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexHelper.class);
    private static final Analyzer ANALYZER = new SimpleAnalyzer(Version.LUCENE_41);

    public static Directory initializeIndex() throws IOException {
        return new RAMDirectory();
    }

    public static IndexWriter initializeIndexWriter(Directory index) throws IOException {
        IndexWriterConfig config = new IndexWriterConfig(Version.LUCENE_41, ANALYZER);
        return new IndexWriter(index, config);
    }

    public static Map<String, Pair> rankDocuments(Directory index, String query, int count) throws ParseException, IOException {
        return IndexHelper.rankDocuments(index, query, count, count);
    }

    public static Map<String, Pair> rankDocuments(Directory index, String query, int count, int hitsCount) throws ParseException, IOException {
        LOGGER.info("Ranking documents. checking for first : " + count + " hits");
        HashMap<String, Pair> scores = new HashMap<String, Pair>();
        BooleanQuery bq = new BooleanQuery();
        Query q = new QueryParser(Version.LUCENE_41, "query_field", ANALYZER).parse(query);
        MatchAllDocsQuery everyDocClause = new MatchAllDocsQuery();
        bq.add((Query)everyDocClause, BooleanClause.Occur.MUST);
        bq.add(q, BooleanClause.Occur.SHOULD);
        int hitsPerPage = count;
        DirectoryReader reader = DirectoryReader.open((Directory)index);
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)hitsPerPage, (boolean)true);
        searcher.search((Query)bq, (Collector)collector);
        ScoreDoc[] hits = collector.topDocs().scoreDocs;
        LOGGER.info("hits returned  : " + hits.length);
        for (ScoreDoc hit : hits) {
            int docId = hit.doc;
            Document d = searcher.doc(docId);
            String id = d.get("ID_FIELD");
            Float score = Float.valueOf(hit.score);
            if (scores.containsKey(id) && !(((Pair)scores.get(id)).getScore().floatValue() < score.floatValue())) continue;
            Pair p = new Pair(score, docId);
            scores.put(id, p);
        }
        LOGGER.info("distinct hits returned  : " + scores.size());
        if (scores.size() < hitsCount) {
            scores = null;
            q = null;
            reader.close();
            searcher = null;
            collector = null;
            hits = null;
            return IndexHelper.rankDocuments(index, query, 2 * count, hitsCount);
        }
        return scores;
    }

    public static List<GenericRecord> multiget(List<RankedRecord> recs, Directory index, Set<String> fieldsName) throws Exception {
        ArrayList<GenericRecord> rsRecs = new ArrayList<GenericRecord>();
        DirectoryReader reader = DirectoryReader.open((Directory)index);
        for (RankedRecord rec : recs) {
            Integer docID = rec.getLuceneDocID();
            Document doc = null;
            if (docID != null) {
                doc = reader.document(docID.intValue());
            }
            GenericRecord rsRec = RecordHelper.luceneToRSRecord(doc, fieldsName, RankedRecord.calcScore(rec));
            rsRecs.add(rsRec);
        }
        return rsRecs;
    }

    public static Map<String, Long> feedLucene(Directory index, Iterator<PositionalRecordWrapper> iter, List<String> snippetFields, Set<String> fields, int count) throws Exception {
        long starttime = 0L;
        long endtime = 0L;
        IndexWriter w = IndexHelper.initializeIndexWriter(index);
        HashMap<String, Long> recs = new HashMap<String, Long>();
        int cnt = 0;
        int added = 0;
        while (iter.hasNext() && (count == -1 || cnt < count)) {
            starttime = System.currentTimeMillis();
            PositionalRecordWrapper prec = iter.next();
            endtime = System.currentTimeMillis();
            LOGGER.info(" ~~> feedLucene: getting next record time : " + (double)(endtime - starttime) / 1000.0 + " secs");
            starttime = System.currentTimeMillis();
            Long pos = prec.getPosition();
            String id = RecordHelper.getRecordID(prec.getRec());
            endtime = System.currentTimeMillis();
            LOGGER.info(" ~~> feedLucene: getting record id time : " + (double)(endtime - starttime) / 1000.0 + " secs");
            starttime = System.currentTimeMillis();
            String queryFieldPayload = RecordHelper.getQuerySnippetFields(prec.getRec(), snippetFields);
            endtime = System.currentTimeMillis();
            LOGGER.info(" ~~> feedLucene: getting record snippet time : " + (double)(endtime - starttime) / 1000.0 + " secs");
            starttime = System.currentTimeMillis();
            RecordHelper.rsRecToLucene(w, id, prec.getRec(), queryFieldPayload);
            endtime = System.currentTimeMillis();
            LOGGER.info(" ~~> feedLucene: storing record to lucene time : " + (double)(endtime - starttime) / 1000.0 + " secs");
            starttime = System.currentTimeMillis();
            if (!recs.containsKey(id)) {
                recs.put(id, pos);
                fields.addAll(ResultSetHelper.getRSRecFields(prec.getRec()));
                ++cnt;
            } else if ((Long)recs.get(id) > pos) {
                recs.put(id, pos);
                fields.addAll(ResultSetHelper.getRSRecFields(prec.getRec()));
            }
            endtime = System.currentTimeMillis();
            LOGGER.info(" ~~> feedLucene: getting fields of record time : " + (double)(endtime - starttime) / 1000.0 + " secs");
            ++added;
            LOGGER.info("Total records read from fused iterator : " + cnt);
        }
        iter.remove();
        LOGGER.info("Distinct records read from fused iterator : " + cnt);
        LOGGER.info("Records added : " + added);
        w.close();
        return recs;
    }
}

