/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.updater;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.resourcemanagement.updater.AccessPointUpdater;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    static final Logger logger = LoggerFactory.getLogger(Utils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Properties loadProperties(String filePath) throws IOException {
        Properties prop;
        block9: {
            InputStream input = null;
            prop = new Properties();
            try {
                String propFileName = filePath;
                input = AccessPointUpdater.class.getClassLoader().getResourceAsStream(propFileName);
                if (input != null) {
                    prop.load(input);
                    break block9;
                }
                throw new FileNotFoundException("property file '" + propFileName + "' not found in the classpath");
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return prop;
    }

    protected static Properties loadSystemCommands(Properties props) {
        for (String name : props.stringPropertyNames()) {
            boolean isSystem = name.startsWith("/");
            if (!isSystem) continue;
            AccessPointUpdater.getSysSoftware().add(name + " " + props.getProperty(name));
            props.remove(name);
        }
        return props;
    }

    protected static void update(Resource resource) {
        logger.debug("resource updating " + resource.id());
        String currentScope = ScopeProvider.instance.get();
        RegistryPublisher rp = RegistryPublisherFactory.create();
        rp.vosUpdate(resource);
        logger.info("resource updated ");
    }

    protected static ServiceEndpoint getResource(String scope, String category, String name) {
        ScopeProvider.instance.set(scope);
        logger.debug("find from " + scope + " and Category: " + category + " the following name " + name);
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq '" + category + "'");
        query.addCondition("$resource/Profile/Name/text() eq '" + name + "'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List se = client.submit((Query)query);
        return (ServiceEndpoint)se.get(0);
    }

    protected static List<ServiceEndpoint> getResources(String scope, String category, String name) {
        ScopeProvider.instance.set(scope);
        logger.debug("find from " + scope + " and Category: " + category + " the following name " + name);
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq '" + category + "'");
        query.addCondition("$resource/Profile/Name/text() eq '" + name + "'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List se = client.submit((Query)query);
        return se;
    }

    protected static ServiceEndpoint.AccessPoint getAccessPoint(ServiceEndpoint endpoint, String accessPointName) {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        Group accesspoints = endpoint.profile().accessPoints();
        for (ServiceEndpoint.AccessPoint point : accesspoints) {
            if (!point.name().equals(accessPointName)) continue;
            System.out.println("AccessPoint found: " + point.name() + " address: " + point.address());
            return point;
        }
        return null;
    }

    protected static List<ServiceEndpoint.AccessPoint> getAccessPoints(List<ServiceEndpoint> endpoints, String accessPointName) {
        logger.debug("finding the following accessPoint " + accessPointName);
        ArrayList<ServiceEndpoint.AccessPoint> points = new ArrayList<ServiceEndpoint.AccessPoint>();
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        for (ServiceEndpoint endpoint : endpoints) {
            Group accesspoints = endpoint.profile().accessPoints();
            for (ServiceEndpoint.AccessPoint point : accesspoints) {
                if (!point.name().equals(accessPointName)) continue;
                System.out.println("AccessPoint found: " + point.name() + " address: " + point.address());
                points.add(point);
            }
        }
        return points;
    }

    protected static ServiceEndpoint getResourceFromHostField(String hostedOnField, List<ServiceEndpoint> resources) {
        logger.debug("resources found: " + resources.size());
        ServiceEndpoint resourceTarget = null;
        for (ServiceEndpoint resource : resources) {
            String resourceHost = resource.profile().runtime().hostedOn();
            System.out.println("host field " + resourceHost);
            if (!hostedOnField.equals(resourceHost)) continue;
            resourceTarget = resource;
            logger.info("resource found: " + resourceTarget);
            break;
        }
        return resourceTarget;
    }
}

