/**
 * 
 */
package org.gcube.resourcemanagement.updater;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.ServiceEndpoint.AccessPoint;

/**
 * @author Roberto Cirillo (ISTI-CNR) 2018
 * 
 *
 */
public class AccessPointUpdater {

	
	/**
	 * List of all the packages retrieved from system
	 */
	protected static ArrayList <String> sysSoftware=new ArrayList<String>();
	private static final String ACCESS_POINT_NAME="Cluster";




	/**
	 * @param args
	 * @throws IOException 
	 */
	public static void main(String[] args) throws Exception {
		for (int i=0; i<args.length;i++) 
			System.out.println("param N." +i + ": " + args[i]);
		System.out.println("ACCESS POINT UPDATER CLI");
		if((args.length != 5)){
			System.out.println("Usage:");
			System.out.println("\tjava  AccessPointUpdater  scope  Category Name HostedOnField file.properties\n\n");
			System.out.println("Example:");
			System.out.println("\tjava  AccessPointUpdater  /gcube DataAnalysis Dataminer dataminer.garr.d4science.org /test/environment.properties \n\n");
			return;
		}
		
		String scope=args[0];
		String category=args[1];
		String name=args[2];
		String hostedOnField=args[3];
		String filePath=args[4]; 
		Properties props=Utils.loadProperties(filePath);
		props=Utils.loadSystemCommands(props);
		List <ServiceEndpoint> resources = Utils.getResources(scope, category, name);
		if(resources!=null){
			ServiceEndpoint resourceTarget = Utils.getResourceFromHostField(hostedOnField, resources);
			if (Objects.isNull(resourceTarget))
				throw new IllegalArgumentException("Resource not found on IS. Please check the input parameters");
			AccessPoint accesspoint = Utils.getAccessPoint(resourceTarget, ACCESS_POINT_NAME);
			if (accesspoint != null){
		//retrieve software and versions from properties file		
				fill(props, accesspoint);
		//retrieve software to ask to the system from properties file. 
				fillVersionFromSystem(accesspoint, getSysSoftware());
				Utils.update(resourceTarget);
			}
//			}
		}else{
			System.out.println("No resource found on scope "+scope+" with category: "+category+" and name: "+name);
		}
	}

	private static void fill(Properties props, AccessPoint point) {
		   for(String name : props.stringPropertyNames()) {
	        	  String value = props.getProperty(name);
	        	  System.out.println("Adding "+name+ " "+value+" version defined in props");
	        	  point.properties().add(new ServiceEndpoint.Property().nameAndValue(name, value));
		   }
	}

/**
 * Ask to the system some software versions and update the AccessPoint
 * This fields are stored in the properties file in a special format: /absolute/path/to/the/software/software=argumentUsedForAskTheVersion 
 *	// e.g. /usr/bin/python=--version	
 * where "/usr/bin/python"is the prop name and "--version" is the prop value
 * @param point: AccessPoint to update with the info retrieved by System
 * @param systemSoftware contains shell commands 
 */
	private static void fillVersionFromSystem(AccessPoint point, ArrayList <String> systemSoftware)  { 
		for (String command : systemSoftware) {
			  Process proc=exec(command);
			  String name=null;
			  String version=null;
			  try {
				  name=formatName(command);
				  version=formatResults(proc,command );
				  System.out.println("\n\t software:  name: "+name+"\t version "+version);
				  if(Objects.nonNull(name) && Objects.nonNull(version))
					  point.properties().add(new ServiceEndpoint.Property().nameAndValue(name.trim(), version.trim()));
			} catch (Exception e) {
				System.out.println("ERROR");
			}
		  }
		

		   
	}
	/**
	 * Exec a bash shell command
	 * @param command command to exec
	 * @return the external process
	 */
	public static Process exec(String command)  {
		Process process;
		try {
			process = Runtime.getRuntime().exec(new String[] { "/bin/bash", "-c", command });
			return process;
		} catch (IOException e) {
			System.out.println("Something went wrong!");
		}
		return null;
	}
	
	/**
	 * Print console results
	 * @param process
	 * @throws IOException
	 * @throws InterruptedException
	 */
	public static void printResults(Process process) throws IOException, InterruptedException {
		StringBuilder output = new StringBuilder();
		BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
	    String line = "";
	    while ((line = reader.readLine()) != null) {
	    	output.append(line + "\n");
	    }
	    int exitVal = process.waitFor();
		if (exitVal == 0) {
			System.out.println("exit status Success!");
		} else {
			System.out.println("exit status Failed");
		}
	}
	
	
	/**
	 * Extract version from process result. Notice that the process output is not the same for any software. 
	 * In this method is treated a special case only the R software
	 * @param process
	 * @param command
	 * @return
	 * @throws IOException
	 * @throws InterruptedException
	 */
	private static String formatResults(Process process, String command) throws IOException, InterruptedException {
		StringBuilder output = new StringBuilder();
		BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
	    String line = "";
	    while ((line = reader.readLine()) != null) {
	    	output.append(line + "\n");
	    }
	    int exitVal = process.waitFor();
		if (exitVal == 0) {
			System.out.println("command"+command+" exit status Success!");
		} else {
			System.out.println("Problem retrieving software version "+command);
		}
		String out=output.toString();
		if (command.contains("R --version")) {
			String rVersion=out.substring(out.indexOf("R version ")+10, out.indexOf("(")).trim();
			System.out.println("R version extracted is  " +rVersion);
			return rVersion;
		}else {
			String version=out.substring(out.indexOf(" ")+1);
			return version;
		}
	}
	
	/**
	 * Extract the software name (e.g. python, R) from command
	 * @param command the input command e.g.: "python --version"
	 * @return software name
	 */
	private static String formatName(String command) {
		String name=null;
		name=command.substring(command.lastIndexOf("/")+1, command.indexOf("-")).trim();
		return name;
	}
	protected static ArrayList<String> getSysSoftware() {
		return sysSoftware;
	}

}
