package org.gcube.informationsystem.publisher.stubs.registry;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

import javax.net.ssl.HttpsURLConnection;

import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.stubs.registry.faults.CreateException;
import org.gcube.informationsystem.publisher.stubs.registry.faults.InvalidResourceException;
import org.gcube.informationsystem.publisher.stubs.registry.faults.RemoveException;
import org.gcube.informationsystem.publisher.stubs.registry.faults.ResourceDoesNotExistException;
import org.gcube.informationsystem.publisher.stubs.registry.faults.ResourceNotAcceptedException;
import org.gcube.informationsystem.publisher.stubs.registry.faults.UpdateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectorStubs implements RegistryStub {

	private static Logger log = LoggerFactory.getLogger(CollectorStubs.class);

	public static final String TOKEN_HEADER_ENTRY = "gcube-token";
	public static final String SCOPE_HEADER_ENTRY = "gcube-scope";
	
	private String endopoint;

	public CollectorStubs(String endopoint) {
		super();
		this.endopoint = endopoint;
	}



	@Override
	public void create(String profile, String type)
			throws InvalidResourceException, ResourceNotAcceptedException, CreateException {
		StringBuilder callUrl = new StringBuilder(endopoint).append("/").append(type);
		try {
			URL url = new URL(callUrl.toString());
			HttpURLConnection connection = makeRequest(url, "POST", false);
			connection.setDoOutput(true);
			connection.setRequestProperty("Content-type", "text/xml");

			try(OutputStream os = new BufferedOutputStream(connection.getOutputStream())){
				os.write(profile.getBytes());
			}

			if (connection.getResponseCode()!=200) throw new Exception("error creating resource "+connection.getResponseCode());
		}catch (Exception e) {
			log.error("error on create",e);
			throw new RemoveException(e.getMessage());
		}
	}



	@Override
	public void update(String id, String type, String profile)
			throws InvalidResourceException, ResourceNotAcceptedException, UpdateException {
		StringBuilder callUrl = new StringBuilder(endopoint).append("/").append(type).append("/").append(id);
		try {
			URL url = new URL(callUrl.toString());
			HttpURLConnection connection = makeRequest(url, "PUT", false);
			connection.setDoOutput(true);
			connection.setRequestProperty("Content-type", "text/xml");

			try(OutputStream os = new BufferedOutputStream(connection.getOutputStream())){
				os.write(profile.getBytes());
			}

			if (connection.getResponseCode()!=200) throw new Exception("error updating resource "+connection.getResponseCode());
		}catch (Exception e) {
			log.error("error on remove",e);
			throw new RemoveException(e.getMessage());
		}
	}



	@Override
	public void remove(String id, String type) throws ResourceDoesNotExistException, RemoveException {
		StringBuilder callUrl = new StringBuilder(endopoint).append("/").append(type).append("/").append(id);
		try {
			URL url = new URL(callUrl.toString());
			HttpURLConnection connection = makeRequest(url, "DELETE", false);
			connection.setDoInput(true);		
			if (connection.getResponseCode()!=200){
				log.info("response code is not 200");
				throw new Exception("error removing resource with id "+id);
			}
		}catch (Exception e) {
			log.error("error on remove",e);
			throw new RemoveException(e.getMessage());
		}
	}



	private HttpURLConnection makeRequest(URL url, String method, boolean includeTokenInHeader) throws Exception{
		HttpURLConnection connection;
		if (url.toString().startsWith("https://"))
			connection = (HttpsURLConnection)url.openConnection();
		else connection = (HttpURLConnection)url.openConnection();

		if (includeTokenInHeader){
			if (SecurityTokenProvider.instance.get()==null) throw new RuntimeException("null token passed");
			connection.setRequestProperty(TOKEN_HEADER_ENTRY,SecurityTokenProvider.instance.get());
		} else {
			if (ScopeProvider.instance.get()==null) throw new RuntimeException("null scope passed");
			connection.setRequestProperty(SCOPE_HEADER_ENTRY,ScopeProvider.instance.get());
		}
		connection.setRequestMethod(method);
		return connection;
	}		

}
