/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.publisher;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.UUID;
import javax.xml.ws.soap.SOAPFaultException;
import org.gcube.common.clients.stubs.jaxws.JAXWSUtils;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ResourceMediator;
import org.gcube.common.resources.gcore.Resources;
import org.gcube.common.resources.gcore.ScopeGroup;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.informationsystem.publisher.exception.RegistryNotFoundException;
import org.gcube.informationsystem.publisher.scope.ValidatorProvider;
import org.gcube.informationsystem.publisher.stubs.registry.RegistryStub;
import org.gcube.informationsystem.publisher.stubs.registry.faults.CreateException;
import org.gcube.informationsystem.publisher.stubs.registry.faults.InvalidResourceException;
import org.gcube.informationsystem.publisher.stubs.registry.faults.ResourceNotAcceptedException;
import org.gcube.informationsystem.publisher.stubs.registry.faults.UpdateException;
import org.gcube.informationsystem.publisher.utils.RegistryStubs;
import org.gcube.informationsystem.publisher.utils.ValidationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryPublisherImpl
implements RegistryPublisher {
    private static final Logger log = LoggerFactory.getLogger(RegistryPublisher.class);
    private static final int REGISTRY_THRESHOLD = 5;
    private RegistryStubs registry = new RegistryStubs();
    private String scopeCreated;

    protected RegistryPublisherImpl() {
    }

    @Override
    public <T extends Resource> T create(T resource) {
        log.trace("registry-publisher: create method");
        String scope = ScopeProvider.instance.get();
        ValidationUtils.valid("resource", resource);
        ValidationUtils.valid("scopes", scope);
        if (ValidationUtils.isPresent(resource, scope)) {
            throw new IllegalStateException("The scope " + scope + " is already present in the resource. The create operation can't be performed ");
        }
        String id = UUID.randomUUID().toString();
        log.debug("id generated: " + id);
        ResourceMediator.setId(resource, id);
        log.debug("scope setted in resource: " + scope);
        ResourceMediator.setScope(resource, scope);
        ValidatorProvider.getValidator(resource).checkScopeCompatibility(resource, Arrays.asList(scope));
        try {
            Resources.validate(resource);
        }
        catch (Exception e) {
            log.error("the resource is not valid", (Throwable)e);
            throw new IllegalArgumentException("the resource is not valid ", e.getCause());
        }
        RegistryStub stub = null;
        try {
            stub = this.registry.getStubs();
        }
        catch (RegistryNotFoundException e) {
            throw new IllegalArgumentException(e.getCause());
        }
        try {
            log.info("create resource with id " + resource.id() + " in scope: " + scope);
            stub.create(this.toXml(resource), resource.type().toString());
        }
        catch (InvalidResourceException e) {
            throw new IllegalArgumentException(e.getCause());
        }
        catch (ResourceNotAcceptedException e) {
            throw new IllegalArgumentException(e.getCause());
        }
        catch (CreateException e) {
            throw new IllegalArgumentException(e.getCause());
        }
        catch (SOAPFaultException e) {
            throw new IllegalArgumentException(JAXWSUtils.remoteCause((SOAPFaultException)e));
        }
        log.info("created resource " + resource.id() + " on scope " + scope);
        this.scopeCreated = scope;
        resource = this.update(resource);
        return resource;
    }

    @Override
    public <T extends Resource> T update(T resource) {
        log.trace(" update resource with id : " + resource.id());
        ValidationUtils.valid("resource", resource);
        this.validateScope(resource);
        try {
            Resources.validate(resource);
        }
        catch (Exception e) {
            log.error("the resource is not valid", (Throwable)e);
            throw new IllegalArgumentException("the resource is not valid", e);
        }
        ScopeGroup scopes = resource.scopes();
        int tries = 0;
        for (String scope : scopes) {
            log.debug(" check update operation on scope " + scope);
            if (this.scopeCreated == null || this.scopeCreated != null && !this.scopeCreated.equals(scope)) {
                log.debug("update operation: updating resource on scope: " + scope);
                ScopeProvider.instance.set(scope);
                this.registryUpdate(resource, tries);
                tries = 0;
                continue;
            }
            log.trace("skip updating on scope " + this.scopeCreated);
        }
        this.scopeCreated = null;
        return resource;
    }

    @Override
    public <T extends Resource> T remove(T resource) {
        String currentScope = ScopeProvider.instance.get();
        log.info(" remove resource with id : " + resource.id() + " from scope: " + currentScope);
        ValidationUtils.valid("resource", resource);
        ValidationUtils.valid("scopes", currentScope);
        this.validateScope(resource);
        try {
            Resources.validate(resource);
        }
        catch (Exception e) {
            log.error("the resource is not valid", (Throwable)e);
            throw new IllegalArgumentException("the resource is not valid", e);
        }
        ResourceMediator.removeScope(resource, currentScope);
        ScopeGroup scopes = resource.scopes();
        int tries = 0;
        if (scopes.size() > 0) {
            for (String scope : scopes) {
                log.debug(" check update operation on scope " + scope);
                log.debug("remove operation: updating resource on scope: " + scope);
                ScopeProvider.instance.set(scope);
                this.registryUpdate(resource, tries);
            }
            ScopeProvider.instance.set(currentScope);
            log.debug("updating resource on current scope: " + currentScope);
            this.registryUpdate(resource, tries);
        } else {
            try {
                this.registry.getStubs().remove(resource.id(), resource.type().toString());
            }
            catch (Exception e) {
                log.error("the resource can't be removed ", (Throwable)e);
                throw new IllegalArgumentException("the resource can't be removed from scope " + currentScope, e);
            }
        }
        return resource;
    }

    private void registryUpdate(Resource resource, int tries) {
        log.trace("try to update resource with id: " + resource.id() + " times " + (tries + 1) + " on scope: " + ScopeProvider.instance.get());
        try {
            this.registry.getStubs().update(resource.id(), resource.type().toString(), this.toXml(resource));
        }
        catch (RegistryNotFoundException e) {
            throw new IllegalArgumentException(e.getCause());
        }
        catch (InvalidResourceException e) {
            throw new IllegalArgumentException(e.getCause());
        }
        catch (ResourceNotAcceptedException e) {
            throw new IllegalArgumentException(e.getCause());
        }
        catch (UpdateException e) {
            throw new IllegalArgumentException(e.getCause());
        }
        catch (SOAPFaultException e) {
            log.warn("Failed update resource on " + this.registry.getEndPoints().get(0) + " times: " + (tries + 1));
            if (tries < 5) {
                ++tries;
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                this.registryUpdate(resource, tries);
            }
            throw new IllegalArgumentException(JAXWSUtils.remoteCause((SOAPFaultException)e));
        }
    }

    private String toXml(Resource resource) {
        StringWriter writer = new StringWriter();
        Resources.marshal((Object)resource, (Writer)writer);
        return writer.toString();
    }

    private void validateScope(Resource resource) {
        ValidatorProvider.getValidator(resource).validate(resource);
    }

    private boolean isPresent(Resource resource, String currentScope) {
        ScopeGroup scopes = resource.scopes();
        boolean founded = false;
        for (String scope : scopes) {
            if (!scope.equals(currentScope)) continue;
            founded = true;
        }
        if (founded) {
            throw new IllegalArgumentException(" scope " + currentScope + " is already present in resource");
        }
        return false;
    }
}

