/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.publisher;

import java.util.LinkedList;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ResourceMediator;
import org.gcube.common.resources.gcore.ScopeGroup;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.exception.RegistryNotFoundException;
import org.gcube.informationsystem.publisher.stubs.registry.RegistryStub;
import org.gcube.informationsystem.publisher.stubs.registry.faults.ResourceDoesNotExistException;
import org.gcube.informationsystem.publisher.utils.RegistryStubs;

public abstract class AdvancedPublisherCommonUtils {
    protected RegistryStubs registry;

    public <T extends Resource> T removeFromAllScopes(T resource) {
        RegistryStub stub = null;
        this.registry = new RegistryStubs();
        String currentScope = ScopeProvider.instance.get();
        ScopeGroup scopes = resource.scopes();
        LinkedList<String> scopesToRemove = new LinkedList<String>();
        for (String scope : scopes) {
            ScopeProvider.instance.set(scope);
            try {
                stub = this.registry.getStubs();
            }
            catch (RegistryNotFoundException e) {
                throw new IllegalArgumentException(e.getCause());
            }
            try {
                stub.remove(resource.id(), resource.type().toString());
            }
            catch (ResourceDoesNotExistException resourceDoesNotExistException) {
                // empty catch block
            }
            scopesToRemove.add(scope);
        }
        for (String scope : scopesToRemove) {
            ResourceMediator.removeScope(resource, scope);
        }
        ScopeProvider.instance.set(currentScope);
        return resource;
    }
}

