/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.publisher;

import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.List;
import javax.xml.ws.soap.SOAPFaultException;
import org.gcube.common.clients.stubs.jaxws.JAXWSUtils;
import org.gcube.common.clients.stubs.jaxws.StubFactory;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.Resources;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.informationsystem.publisher.stubs.registry.RegistryConstants;
import org.gcube.informationsystem.publisher.stubs.registry.RegistryStub;
import org.gcube.informationsystem.publisher.stubs.registry.faults.InvalidResourceException;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.api.ResultParser;
import org.gcube.resources.discovery.client.impl.DelegateClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICClient;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryPublisherImpl
implements RegistryPublisher {
    private static final Logger log = LoggerFactory.getLogger(RegistryPublisher.class);

    protected RegistryPublisherImpl() {
    }

    @Override
    public String create(Resource resource) {
        try {
            Resources.validate((Resource)resource);
        }
        catch (Exception e) {
            log.error("the resource is not valid", (Throwable)e);
            throw new InvalidResourceException(e);
        }
        try {
            this.getStubs().create(this.toXml(resource), resource.type().toString());
        }
        catch (SOAPFaultException e) {
            throw new RuntimeException(JAXWSUtils.remoteCause((SOAPFaultException)e));
        }
        return resource.id();
    }

    @Override
    public void update(Resource resource) {
        try {
            Resources.validate((Resource)resource);
        }
        catch (Exception e) {
            log.error("the resource is not valid", (Throwable)e);
            throw new InvalidResourceException(e);
        }
        try {
            this.getStubs().update(resource.id(), this.toXml(resource), resource.type().toString());
        }
        catch (SOAPFaultException e) {
            throw new RuntimeException(JAXWSUtils.remoteCause((SOAPFaultException)e));
        }
    }

    @Override
    public void remove(String id, Resource.Type type) {
        this.getStubs().remove(id, type.toString());
    }

    private List<URI> getEndPoints() {
        XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
        ResultParser<URI> uriParser = new ResultParser<URI>(){

            public URI parse(String result) throws Exception {
                return new URI(result.replaceAll("\n", ""));
            }
        };
        DelegateClient client = new DelegateClient((ResultParser)uriParser, (DiscoveryClient)new ICClient());
        query.addCondition("$resource/Profile/ServiceClass/text() eq '" + RegistryConstants.service_class + "'").addCondition("$resource/Profile/ServiceName/text() eq '" + RegistryConstants.service_name + "'").setResult("$resource/Profile/AccessPoint/RunningInstanceInterfaces/Endpoint[string(@EntryName) eq '" + RegistryConstants.service_entrypoint + "']/string()");
        log.trace("query is {}", (Object)query.expression());
        List services = client.submit((Query)query);
        log.trace("endpoints found {} ", (Object)services);
        return services;
    }

    private RegistryStub getStubs() {
        URI endpoint = this.getEndPoints().get(0);
        log.trace("endpoint found is {}", (Object)endpoint);
        return (RegistryStub)StubFactory.stubFor(RegistryConstants.registry).at(endpoint);
    }

    private String toXml(Resource resource) {
        StringWriter writer = new StringWriter();
        Resources.marshal((Object)resource, (Writer)writer);
        return writer.toString();
    }
}

