/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vomanagement.occi.datamodel.security;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.UUID;
import org.gcube.vomanagement.occi.datamodel.security.Credentials;
import org.gcube.vomanagement.occi.utils.ScriptUtil;

public class X509Credentials
extends Credentials {
    private String certificateContent;
    private File certificateFile;

    public X509Credentials(String certificate) {
        this.certificateContent = certificate;
    }

    public X509Credentials(File pem) {
        this.certificateFile = pem;
    }

    public String getCertificateContent() {
        if (this.certificateContent == null) {
            try {
                this.certificateContent = ScriptUtil.getScriptFromFile(this.certificateFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.certificateContent;
    }

    public File getCertificateFile() {
        if (this.certificateFile == null) {
            try {
                String fileName = "/tmp/" + UUID.randomUUID().toString() + ".pem";
                PrintWriter out = new PrintWriter(fileName);
                out.print(this.certificateContent);
                out.close();
                this.certificateFile = new File(fileName);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return this.certificateFile;
    }
}

